/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;

public abstract class FacesContext {
    private static ThreadLocal<FacesContext> currentInstance = new ThreadLocal();
    private static ThreadLocal<FacesContext> firstInstance = new ThreadLocal();

    public abstract void addMessage(String var1, FacesMessage var2);

    public abstract Application getApplication();

    public Map<Object, Object> getAttributes() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getAttributes();
    }

    public abstract Iterator<String> getClientIdsWithMessages();

    public static FacesContext getCurrentInstance() {
        return currentInstance.get();
    }

    public PhaseId getCurrentPhaseId() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getCurrentPhaseId();
    }

    public ELContext getELContext() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new NullPointerException(FacesContext.class.getName());
        }
        ELContext elctx = ctx.getELContext();
        if (elctx == null) {
            throw new UnsupportedOperationException();
        }
        return elctx;
    }

    public ExceptionHandler getExceptionHandler() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getExceptionHandler();
    }

    public abstract ExternalContext getExternalContext();

    public abstract FacesMessage.Severity getMaximumSeverity();

    public List<FacesMessage> getMessageList() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getMessageList();
    }

    public List<FacesMessage> getMessageList(String clientId) {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getMessageList(clientId);
    }

    public abstract Iterator<FacesMessage> getMessages();

    public abstract Iterator<FacesMessage> getMessages(String var1);

    public PartialViewContext getPartialViewContext() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.getPartialViewContext();
    }

    public abstract RenderKit getRenderKit();

    public abstract boolean getRenderResponse();

    public abstract boolean getResponseComplete();

    public abstract ResponseStream getResponseStream();

    public abstract ResponseWriter getResponseWriter();

    public boolean isValidationFailed() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.isValidationFailed();
    }

    public abstract UIViewRoot getViewRoot();

    public boolean isPostback() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.isPostback();
    }

    public boolean isProcessingEvents() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.isProcessingEvents();
    }

    public abstract void release();

    public abstract void renderResponse();

    public abstract void responseComplete();

    protected static void setCurrentInstance(FacesContext context) {
        if (context == null) {
            currentInstance.remove();
            firstInstance.remove();
        } else {
            currentInstance.set(context);
            if (firstInstance.get() == null) {
                firstInstance.set(context);
            }
        }
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        ctx.setCurrentPhaseId(currentPhaseId);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        ctx.setExceptionHandler(exceptionHandler);
    }

    public void setProcessingEvents(boolean processingEvents) {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        ctx.setProcessingEvents(processingEvents);
    }

    public abstract void setResponseStream(ResponseStream var1);

    public abstract void setResponseWriter(ResponseWriter var1);

    public abstract void setViewRoot(UIViewRoot var1);

    public void validationFailed() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        ctx.validationFailed();
    }

    public boolean isProjectStage(ProjectStage stage) {
        if (stage == null) {
            throw new NullPointerException();
        }
        return stage.equals((Object)this.getApplication().getProjectStage());
    }

    public boolean isReleased() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            throw new UnsupportedOperationException();
        }
        return ctx.isReleased();
    }

    public List<String> getResourceLibraryContracts() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            return Collections.emptyList();
        }
        return ctx.getResourceLibraryContracts();
    }

    public void setResourceLibraryContracts(List<String> contracts) {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            return;
        }
        ctx.setResourceLibraryContracts(contracts);
    }

    public char getNamingContainerSeparatorChar() {
        FacesContext ctx = firstInstance.get();
        if (ctx == null) {
            return UINamingContainer.getSeparatorChar(this);
        }
        return ctx.getNamingContainerSeparatorChar();
    }
}

