/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.myfaces.config.ManagedBeanDestroyer;

public class ManagedBeanDestroyerListener
implements HttpSessionAttributeListener,
HttpSessionListener,
ServletContextListener,
ServletContextAttributeListener,
ServletRequestListener,
ServletRequestAttributeListener {
    public static final String APPLICATION_MAP_KEY = "org.apache.myfaces.ManagedBeanDestroyerListener";
    private ManagedBeanDestroyer _destroyer = null;

    public void setManagedBeanDestroyer(ManagedBeanDestroyer destroyer) {
        this._destroyer = destroyer;
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void contextInitialized(ServletContextEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this._destroyer != null) {
            ServletContext ctx = event.getServletContext();
            Enumeration attributes = ctx.getAttributeNames();
            if (!attributes.hasMoreElements()) {
                return;
            }
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                Object value = ctx.getAttribute(name);
                this._destroyer.destroy(name, value);
            }
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (this._destroyer != null) {
            ServletRequest request = event.getServletRequest();
            Enumeration attributes = request.getAttributeNames();
            if (!attributes.hasMoreElements()) {
                return;
            }
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                Object value = request.getAttribute(name);
                this._destroyer.destroy(name, value);
            }
        }
    }
}

