/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.sax.impl;

import java.util.Collections;
import java.util.List;
import org.apache.vysper.xml.sax.impl.Attribute;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributes
implements Attributes {
    private List<Attribute> attributes;

    public DefaultAttributes() {
        this.attributes = Collections.emptyList();
    }

    public DefaultAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = this.attributes.get(i);
            if (!qName.equals(attribute.getQname())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = this.attributes.get(i);
            if (!uri.equals(attribute.getURI()) || !localName.equals(attribute.getLocalName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.attributes.size();
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index).getLocalName();
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index).getQname();
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return "CDATA";
    }

    @Override
    public String getType(String qName) {
        return this.getType(this.getIndex(qName));
    }

    @Override
    public String getType(String uri, String localName) {
        return this.getType(this.getIndex(uri, localName));
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index).getURI();
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index).getValue();
    }

    @Override
    public String getValue(String qName) {
        return this.getValue(this.getIndex(qName));
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.getValue(this.getIndex(uri, localName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAttributes other = (DefaultAttributes)obj;
        return !(this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes));
    }
}

