/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server;

import org.apache.commons.lang.StringUtils;

public class XMPPVersion {
    public static final XMPPVersion VERSION_1_0 = new XMPPVersion(1, 0);
    private int major = 1;
    private int minor = 0;
    private static final String STRING_ZERO = "0";
    private static final String STRING_UNO = "1";
    private static final String STRING_DOT = ".";

    public XMPPVersion() {
    }

    public XMPPVersion(int major, int minor) {
        if (major < 0) {
            throw new IllegalArgumentException("major must at least be 0");
        }
        this.major = major;
        if (minor < 0) {
            throw new IllegalArgumentException("minor must at least be 0");
        }
        this.minor = minor;
    }

    public XMPPVersion(String version) {
        String[] parts = version.split("\\.");
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException("XMPP version must be of format 'x.y'");
        }
        this.major = this.convertToInt(parts[0]);
        if (this.major < 0) {
            throw new IllegalArgumentException("major must at least be 0");
        }
        this.minor = this.convertToInt(parts[1]);
        if (this.minor < 0) {
            throw new IllegalArgumentException("minor must at least be 0");
        }
    }

    private int convertToInt(String part) {
        if (StringUtils.isEmpty((String)part)) {
            throw new IllegalArgumentException("version part is empty");
        }
        if (STRING_ZERO.equals(part)) {
            return 0;
        }
        if (STRING_UNO.equals(part)) {
            return 1;
        }
        if ((part = part.trim()).startsWith("+") || part.startsWith("-")) {
            throw new IllegalArgumentException("version part must contain only numbers");
        }
        if (part.startsWith(STRING_ZERO)) {
            return this.convertToInt(part.substring(1));
        }
        return Integer.parseInt(part);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return "" + this.major + STRING_DOT + this.minor;
    }

    public boolean isUnknownVersion() {
        return this.major == 0 && this.minor == 0;
    }

    public static XMPPVersion getCommonDenomitator(XMPPVersion v1, XMPPVersion v2) {
        if (v1.getMajor() != v2.getMajor()) {
            return v1.getMajor() < v2.getMajor() ? v1 : v2;
        }
        return v1.getMinor() < v2.getMinor() ? v1 : v2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XMPPVersion that = (XMPPVersion)o;
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 29 * result + this.minor;
        return result;
    }
}

