/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.protocol.HandlerDictionary;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.stanza.Stanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHandlerDictionary
implements HandlerDictionary {
    private List<StanzaHandler> handlerList = new ArrayList<StanzaHandler>();
    private boolean sealed = false;

    public DefaultHandlerDictionary() {
    }

    public DefaultHandlerDictionary(List<StanzaHandler> handlerList) {
        if (handlerList != null) {
            for (StanzaHandler stanzaHandler : handlerList) {
                this.register(stanzaHandler);
            }
        }
        this.seal();
    }

    public DefaultHandlerDictionary(StanzaHandler stanzaHandler) {
        this.register(stanzaHandler);
        this.seal();
    }

    @Override
    public void register(StanzaHandler stanzaHandler) {
        if (this.sealed) {
            throw new IllegalStateException("stanza directory is sealed. registering denied.");
        }
        if (stanzaHandler == null || stanzaHandler.getName() == null) {
            throw new IllegalArgumentException("stanza handler not complete");
        }
        if (this.handlerList.contains(stanzaHandler)) {
            throw new IllegalStateException("stanza handler already in handlerList: " + stanzaHandler.getName());
        }
        this.handlerList.add(stanzaHandler);
    }

    @Override
    public void seal() {
        this.sealed = true;
    }

    @Override
    public StanzaHandler get(Stanza stanza) {
        for (StanzaHandler stanzaHandler : this.handlerList) {
            if (!stanzaHandler.verify(stanza)) continue;
            return stanzaHandler;
        }
        return null;
    }
}

