/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.sasl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.vysper.xmpp.server.SessionContext;

public class AuthorizationRetriesCounter {
    public static final String SESSION_ATTRIBUTE_ABORTION_COUNTER = "authorizationRetriesCounter";
    AtomicInteger counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthorizationRetriesCounter getFromSession(SessionContext sessionContext) {
        AuthorizationRetriesCounter counter = (AuthorizationRetriesCounter)sessionContext.getAttribute(SESSION_ATTRIBUTE_ABORTION_COUNTER);
        SessionContext sessionContext2 = sessionContext;
        synchronized (sessionContext2) {
            if (counter == null) {
                int retries = sessionContext.getServerRuntimeContext().getServerFeatures().getAuthenticationRetries();
                counter = new AuthorizationRetriesCounter(retries);
                sessionContext.putAttribute(SESSION_ATTRIBUTE_ABORTION_COUNTER, counter);
            }
        }
        return counter;
    }

    public static void removeFromSession(SessionContext sessionContext) {
        sessionContext.putAttribute(SESSION_ATTRIBUTE_ABORTION_COUNTER, null);
    }

    public AuthorizationRetriesCounter(int counter) {
        if (counter <= 0) {
            throw new IllegalArgumentException("counter must be positive");
        }
        this.counter = new AtomicInteger(counter);
    }

    public boolean hasTriesLeft() {
        return this.counter.intValue() > 0;
    }

    public boolean countFailedTry() {
        if (!this.hasTriesLeft()) {
            return false;
        }
        return this.counter.decrementAndGet() > 0;
    }

    public int getTriesLeft() {
        return this.counter.intValue();
    }
}

