/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.vysper.xmpp.extension.xep0124.BoshServlet;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoshEndpoint
implements Endpoint {
    protected static final Logger logger = LoggerFactory.getLogger(BoshEndpoint.class);
    protected ServerRuntimeContext serverRuntimeContext;
    protected int port = 8080;
    protected Server server;
    protected boolean isSSLEnabled;
    protected String sslKeystorePath;
    protected String sslKeystorePassword;
    protected List<String> accessControlAllowOrigin;
    protected String contextPath = "/";

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSSLCertificateKeystore(String keystorePath) {
        this.sslKeystorePath = keystorePath;
    }

    public void setSSLCertificateKeystorePassword(String password) {
        this.sslKeystorePassword = password;
    }

    public void setSSLEnabled(boolean value) {
        this.isSSLEnabled = value;
    }

    public List<String> getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(List<String> accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        this.contextPath = contextPath;
    }

    protected Server createJettyServer() {
        SelectChannelConnector connector;
        Server server = new Server();
        if (this.isSSLEnabled) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            sslConnector.setKeystore(this.sslKeystorePath);
            sslConnector.setPassword(this.sslKeystorePassword);
            sslConnector.setKeyPassword(this.sslKeystorePassword);
            connector = sslConnector;
        } else {
            connector = new SelectChannelConnector();
        }
        connector.setPort(this.port);
        server.setConnectors(new Connector[]{connector});
        return server;
    }

    protected Handler createHandler() {
        ServletContextHandler boshContext = new ServletContextHandler(1);
        boshContext.setContextPath(this.contextPath);
        BoshServlet boshServlet = new BoshServlet();
        boshServlet.setServerRuntimeContext(this.serverRuntimeContext);
        boshServlet.setAccessControlAllowOrigin(this.accessControlAllowOrigin);
        boshContext.addServlet(new ServletHolder((Servlet)boshServlet), "/");
        return boshContext;
    }

    public void start() throws IOException {
        this.server = this.createJettyServer();
        Handler handler = this.createHandler();
        this.server.setHandler(handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("Could not stop the Jetty server", (Throwable)e);
        }
    }
}

