/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.util.LinkedList;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.extension.xep0124.BoshHandler;
import org.apache.vysper.xmpp.extension.xep0124.BoshRequest;
import org.apache.vysper.xmpp.extension.xep0124.BoshResponse;
import org.apache.vysper.xmpp.extension.xep0124.InactivityChecker;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.AbstractSessionContext;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.writer.StanzaWriter;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoshBackedSessionContext
extends AbstractSessionContext
implements StanzaWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoshBackedSessionContext.class);
    private final BoshHandler boshHandler;
    private final int maxpause = 120;
    private final int inactivity = 60;
    private final int polling = 15;
    private final int maximumSentResponses = 10;
    private final int brokenConnectionReportTimeout = 1000;
    private final SortedMap<Long, BoshRequest> requestsWindow;
    private final Queue<Stanza> delayedResponseQueue;
    private final SortedMap<Long, BoshResponse> sentResponses;
    private int requests = 2;
    private String boshVersion = "1.9";
    private String contentType = "text/xml; charset=UTF-8";
    private int wait = 60;
    private int hold = 1;
    private int currentInactivity = 60;
    private Long highestReadRid = null;
    private Long currentProcessingRequest = null;
    private BoshRequest latestEmptyPollingRequest = null;
    private boolean clientAcknowledgements;
    private long latestWriteTimestamp = System.currentTimeMillis();
    private final InactivityChecker inactivityChecker;
    private Long lastInactivityExpireTime;
    private boolean isWatchedByInactivityChecker;

    public BoshBackedSessionContext(BoshHandler boshHandler, ServerRuntimeContext serverRuntimeContext, InactivityChecker inactivityChecker) {
        super(serverRuntimeContext, new SessionStateHolder());
        this.sessionStateHolder.setState(SessionState.ENCRYPTED);
        this.boshHandler = boshHandler;
        this.requestsWindow = new TreeMap<Long, BoshRequest>();
        this.delayedResponseQueue = new LinkedList<Stanza>();
        this.sentResponses = new TreeMap<Long, BoshResponse>();
        this.inactivityChecker = inactivityChecker;
        this.updateInactivityChecker();
    }

    public boolean isWatchedByInactivityChecker() {
        return this.isWatchedByInactivityChecker;
    }

    private void updateInactivityChecker() {
        Long newInactivityExpireTime = null;
        if (this.requestsWindow.isEmpty() ? (newInactivityExpireTime = Long.valueOf(this.latestWriteTimestamp + (long)(this.currentInactivity * 1000))) == this.lastInactivityExpireTime : !this.isWatchedByInactivityChecker) {
            return;
        }
        this.isWatchedByInactivityChecker = this.inactivityChecker.updateExpireTime(this, this.lastInactivityExpireTime, newInactivityExpireTime);
        this.lastInactivityExpireTime = newInactivityExpireTime;
    }

    public long getHighestReadRid() {
        return this.highestReadRid;
    }

    public SessionStateHolder getStateHolder() {
        return this.sessionStateHolder;
    }

    public StanzaWriter getResponseWriter() {
        return this;
    }

    public void setIsReopeningXMLStream() {
    }

    public synchronized void write(Stanza stanza) {
        this.write0(this.boshHandler.wrapStanza(stanza));
    }

    void write0(Stanza response) {
        if (this.requestsWindow.isEmpty() || this.requestsWindow.firstKey() > this.highestReadRid) {
            this.delayedResponseQueue.offer(response);
            return;
        }
        BoshRequest req = (BoshRequest)this.requestsWindow.remove(this.requestsWindow.firstKey());
        BoshResponse boshResponse = this.getBoshResponse(response, req.getRid().equals(this.highestReadRid) ? null : this.highestReadRid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BOSH writing response: {}", (Object)new String(boshResponse.getContent()));
        }
        if (this.isResponseSavable(req, response)) {
            this.sentResponses.put(req.getRid(), boshResponse);
            if (this.sentResponses.size() > 10 || !this.isClientAcknowledgements() && this.sentResponses.size() > this.requests) {
                this.sentResponses.remove(this.sentResponses.firstKey());
            }
        }
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)req.getHttpServletRequest());
        continuation.setAttribute("response", (Object)boshResponse);
        continuation.resume();
        this.latestWriteTimestamp = System.currentTimeMillis();
        this.updateInactivityChecker();
    }

    private boolean isResponseSavable(BoshRequest req, Stanza response) {
        if (req.getBody().getAttributeValue("pause") != null) {
            return false;
        }
        for (XMLElement element : response.getInnerElements()) {
            if (!"iq".equals(element.getName()) || !"error".equals(element.getAttributeValue("type"))) continue;
            for (XMLElement subelement : element.getInnerElements()) {
                if (!"bind".equals(subelement.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private void error(BoshRequest br, String condition) {
        this.requestsWindow.put(br.getRid(), br);
        BoshRequest req = (BoshRequest)this.requestsWindow.remove(this.requestsWindow.firstKey());
        Stanza body = this.boshHandler.getTerminateResponse();
        body = this.boshHandler.addAttribute(body, "condition", condition);
        BoshResponse boshResponse = this.getBoshResponse(body, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BOSH writing response: {}", (Object)new String(boshResponse.getContent()));
        }
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)req.getHttpServletRequest());
        continuation.setAttribute("response", (Object)boshResponse);
        continuation.resume();
        this.close();
    }

    public synchronized void close() {
        while (!this.requestsWindow.isEmpty()) {
            BoshRequest req = (BoshRequest)this.requestsWindow.remove(this.requestsWindow.firstKey());
            Stanza body = this.boshHandler.getTerminateResponse();
            BoshResponse boshResponse = this.getBoshResponse(body, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("BOSH writing response: {}", (Object)new String(boshResponse.getContent()));
            }
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)req.getHttpServletRequest());
            continuation.setAttribute("response", (Object)boshResponse);
            continuation.resume();
        }
        this.serverRuntimeContext.getResourceRegistry().unbindSession((SessionContext)this);
        this.sessionStateHolder.setState(SessionState.CLOSED);
        this.inactivityChecker.updateExpireTime(this, this.lastInactivityExpireTime, null);
        this.lastInactivityExpireTime = null;
        LOGGER.info("BOSH session {} closed", (Object)this.getSessionId());
    }

    public void switchToTLS(boolean delayed, boolean clientTls) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getMaxPause() {
        return 120;
    }

    public void setWait(int wait) {
        this.wait = Math.min(wait, this.wait);
    }

    public int getWait() {
        return this.wait;
    }

    public void setHold(int hold) {
        this.hold = hold;
        if (hold >= 2) {
            this.requests = hold + 1;
        }
    }

    public int getHold() {
        return this.hold;
    }

    public void setClientAcknowledgements(boolean value) {
        this.clientAcknowledgements = value;
    }

    public boolean isClientAcknowledgements() {
        return this.clientAcknowledgements;
    }

    public void setBoshVersion(String version) {
        String[] v = this.boshVersion.split("\\.");
        int major = Integer.parseInt(v[0]);
        int minor = Integer.parseInt(v[1]);
        v = version.split("\\.");
        if (v.length == 2) {
            int clientMajor = Integer.parseInt(v[0]);
            int clientMinor = Integer.parseInt(v[1]);
            if (clientMajor < major || clientMajor == major && clientMinor < minor) {
                this.boshVersion = version;
            }
        }
    }

    public String getBoshVersion() {
        return this.boshVersion;
    }

    public int getInactivity() {
        return 60;
    }

    public int getPolling() {
        return 15;
    }

    public int getRequests() {
        return this.requests;
    }

    private synchronized void requestExpired(Continuation continuation) {
        BoshRequest req = (BoshRequest)continuation.getAttribute("request");
        if (req == null) {
            LOGGER.warn("Continuation expired without having an associated request!");
            return;
        }
        while (!this.requestsWindow.isEmpty() && this.requestsWindow.firstKey() <= req.getRid()) {
            this.write0(this.boshHandler.getEmptyResponse());
        }
    }

    public void insertRequest(BoshRequest br) {
        Stanza delayedResponse;
        this.currentInactivity = 60;
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)br.getHttpServletRequest());
        this.addContinuationExpirationListener(continuation);
        continuation.setTimeout((long)(this.wait * 1000));
        continuation.setAttribute("request", (Object)br);
        continuation.suspend();
        if (this.highestReadRid != null && this.highestReadRid + (long)this.requests < br.getRid()) {
            LOGGER.warn("BOSH received RID greater than the permitted window of concurrent requests");
            this.error(br, "item-not-found");
            return;
        }
        if (this.highestReadRid != null && br.getRid() <= this.highestReadRid) {
            if (this.sentResponses.containsKey(br.getRid())) {
                this.resendResponse(br);
            } else {
                LOGGER.warn("BOSH response not in buffer error");
                this.error(br, "item-not-found");
            }
            return;
        }
        if (this.requestsWindow.size() + 1 > this.requests && !"terminate".equals(br.getBody().getAttributeValue("type")) && br.getBody().getAttributeValue("pause") == null) {
            LOGGER.warn("BOSH Overactivity: Too many simultaneous requests");
            this.error(br, "policy-violation");
            return;
        }
        if (this.requestsWindow.size() + 1 == this.requests && !"terminate".equals(br.getBody().getAttributeValue("type")) && br.getBody().getAttributeValue("pause") == null && br.getBody().getInnerElements().isEmpty() && !this.requestsWindow.isEmpty() && br.getTimestamp() - ((BoshRequest)this.requestsWindow.get(this.requestsWindow.lastKey())).getTimestamp() < 15000L) {
            LOGGER.warn("BOSH Overactivity: Too frequent requests");
            this.error(br, "policy-violation");
            return;
        }
        if ((this.wait == 0 || this.hold == 0) && br.getBody().getInnerElements().isEmpty()) {
            if (this.latestEmptyPollingRequest != null && br.getTimestamp() - this.latestEmptyPollingRequest.getTimestamp() < 15000L) {
                LOGGER.warn("BOSH Overactivity for polling: Too frequent requests");
                this.error(br, "policy-violation");
                return;
            }
            this.latestEmptyPollingRequest = br;
        }
        this.requestsWindow.put(br.getRid(), br);
        this.updateInactivityChecker();
        if (this.highestReadRid == null) {
            this.highestReadRid = br.getRid();
        }
        while (this.requestsWindow.containsKey(this.highestReadRid + 1L)) {
            Long l = this.highestReadRid;
            Long l2 = this.highestReadRid = Long.valueOf(this.highestReadRid + 1L);
        }
        if (this.isClientAcknowledgements()) {
            long delta;
            long ack;
            if (br.getBody().getAttribute("ack") == null) {
                this.sentResponses.clear();
            } else if (!this.sentResponses.isEmpty() && (ack = Long.parseLong(br.getBody().getAttributeValue("ack"))) < this.sentResponses.lastKey() && this.sentResponses.containsKey(ack + 1L) && (delta = System.currentTimeMillis() - ((BoshResponse)this.sentResponses.get(ack + 1L)).getTimestamp()) >= 1000L) {
                this.sendBrokenConnectionReport(ack + 1L, delta);
                return;
            }
        }
        if (br.getBody().getAttribute("pause") != null && br.getRid().equals(this.requestsWindow.lastKey()) && this.highestReadRid.equals(br.getRid())) {
            int pause = Integer.parseInt(br.getBody().getAttributeValue("pause"));
            if (pause > 120) {
                pause = 120;
            }
            if (pause < 0) {
                pause = 0;
            }
            this.respondToPause(pause);
            return;
        }
        Stanza mergedResponse = null;
        while ((delayedResponse = this.delayedResponseQueue.poll()) != null) {
            mergedResponse = this.boshHandler.mergeResponses(mergedResponse, delayedResponse);
        }
        if (mergedResponse != null) {
            this.write0(mergedResponse);
            return;
        }
        if (this.requestsWindow.size() > this.hold) {
            this.write0(this.boshHandler.getEmptyResponse());
        }
    }

    private void respondToPause(int pause) {
        BoshRequest boshRequest;
        LOGGER.debug("Setting inactivity period to {}", (Object)pause);
        this.currentInactivity = pause;
        while ((boshRequest = this.getNextRequest()) != null) {
            this.write0(this.boshHandler.getEmptyResponse());
        }
    }

    private void sendBrokenConnectionReport(long report, long delta) {
        Stanza body = this.boshHandler.getTerminateResponse();
        body = this.boshHandler.addAttribute(body, "report", Long.toString(report));
        body = this.boshHandler.addAttribute(body, "time", Long.toString(delta));
        this.write0(body);
    }

    private void addContinuationExpirationListener(Continuation continuation) {
        continuation.addContinuationListener(new ContinuationListener(){

            public void onTimeout(Continuation continuation) {
                BoshBackedSessionContext.this.requestExpired(continuation);
            }

            public void onComplete(Continuation continuation) {
            }
        });
    }

    private void resendResponse(BoshRequest br) {
        BoshResponse boshResponse = (BoshResponse)this.sentResponses.get(br.getRid());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BOSH writing response: {}", (Object)new String(boshResponse.getContent()));
        }
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)br.getHttpServletRequest());
        continuation.setAttribute("response", (Object)boshResponse);
        continuation.resume();
        this.latestWriteTimestamp = System.currentTimeMillis();
        this.updateInactivityChecker();
    }

    private BoshResponse getBoshResponse(Stanza stanza, Long ack) {
        if (ack != null) {
            stanza = this.boshHandler.addAttribute(stanza, "ack", ack.toString());
        }
        byte[] content = new Renderer((XMLElement)stanza).getComplete().getBytes();
        return new BoshResponse(this.contentType, content);
    }

    public BoshRequest getNextRequest() {
        if (this.requestsWindow.isEmpty()) {
            return null;
        }
        if (this.currentProcessingRequest == null || this.currentProcessingRequest < this.requestsWindow.firstKey()) {
            this.currentProcessingRequest = this.requestsWindow.firstKey();
        }
        if (this.currentProcessingRequest > this.highestReadRid) {
            return null;
        }
        Long l = this.currentProcessingRequest;
        Long l2 = this.currentProcessingRequest = Long.valueOf(this.currentProcessingRequest + 1L);
        return (BoshRequest)this.requestsWindow.get(this.currentProcessingRequest - 1L);
    }
}

