/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.IOException;
import java.util.Iterator;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;

public class WriteDecodedDoc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(in);
            if (doc.isEncrypted()) {
                try {
                    doc.decrypt("");
                }
                catch (InvalidPasswordException e) {
                    System.err.println("Error: The document is encrypted.");
                }
                catch (CryptographyException e) {
                    e.printStackTrace();
                }
            }
            Iterator i = doc.getDocument().getObjects().iterator();
            while (i.hasNext()) {
                COSBase base = ((COSObject)i.next()).getObject();
                if (!(base instanceof COSStream)) continue;
                COSStream cosStream = (COSStream)base;
                cosStream.getUnfilteredStream();
                cosStream.setFilters(null);
            }
            doc.save(out);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        WriteDecodedDoc app = new WriteDecodedDoc();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <output-file>");
    }
}

