/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.io.DefaultIoConnectFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.mina.MinaService;

public class MinaConnector
extends MinaService
implements IoConnector {
    private static final Object CONNECT_FUTURE_KEY = new Object();
    protected final AtomicReference<org.apache.mina.core.service.IoConnector> connectorHolder = new AtomicReference<Object>(null);

    public MinaConnector(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
    }

    protected org.apache.mina.core.service.IoConnector createConnector() {
        NioSocketConnector connector = new NioSocketConnector(this.ioProcessor);
        this.configure(connector.getSessionConfig());
        CoreModuleProperties.IO_CONNECT_TIMEOUT.get((PropertyResolver)this.manager).ifPresent(d -> {
            long millis;
            if (d.isZero() || d.isNegative()) {
                return;
            }
            try {
                millis = d.toMillis();
            }
            catch (ArithmeticException e) {
                millis = Long.MAX_VALUE;
            }
            connector.setConnectTimeoutMillis(millis);
        });
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoConnector getConnector() {
        org.apache.mina.core.service.IoConnector connector;
        AtomicReference<org.apache.mina.core.service.IoConnector> atomicReference = this.connectorHolder;
        synchronized (atomicReference) {
            connector = this.connectorHolder.get();
            if (connector != null) {
                return connector;
            }
            connector = this.createConnector();
            connector.setHandler((org.apache.mina.core.service.IoHandler)this);
            this.connectorHolder.set(connector);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created IoConnector: {}", (Object)connector);
        }
        return connector;
    }

    @Override
    protected IoService getIoService() {
        return this.getConnector();
    }

    public void sessionCreated(org.apache.mina.core.session.IoSession session) throws Exception {
        IoServiceEventListener listener = this.getIoServiceEventListener();
        SocketAddress local = session.getLocalAddress();
        SocketAddress remote = session.getRemoteAddress();
        AttributeRepository context = (AttributeRepository)session.getAttribute(AttributeRepository.class);
        try {
            if (listener != null) {
                try {
                    listener.connectionEstablished((IoConnector)this, local, context, remote);
                }
                catch (Exception e) {
                    session.closeNow();
                    throw e;
                }
            }
            this.sessionCreated(session, null);
        }
        catch (Exception e) {
            if (listener != null) {
                try {
                    listener.abortEstablishedConnection((IoConnector)this, local, context, remote, (Throwable)e);
                }
                catch (Exception exc) {
                    this.debug("sessionCreated({}) ignoring abort connection failure={}: {}", session, exc.getClass().getSimpleName(), exc.getMessage(), exc);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(org.apache.mina.core.session.IoSession ioSession) throws Exception {
        try {
            super.sessionClosed(ioSession);
        }
        finally {
            CancelFuture cancellation;
            IoConnectFuture future = (IoConnectFuture)ioSession.removeAttribute(CONNECT_FUTURE_KEY);
            if (future != null && (cancellation = future.cancel()) != null) {
                cancellation.setCanceled();
            }
        }
    }

    public IoConnectFuture connect(SocketAddress address, final AttributeRepository context, SocketAddress localAddress) {
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null){

            public void setSession(IoSession session) {
                if (context != null) {
                    session.setAttribute(AttributeRepository.class, (Object)context);
                }
                super.setSession(session);
            }
        };
        org.apache.mina.core.service.IoConnector connector = this.getConnector();
        AtomicReference createdSession = new AtomicReference();
        ConnectFuture connectFuture = connector.connect(address, localAddress, (arg_0, arg_1) -> MinaConnector.lambda$connect$1((IoConnectFuture)future, createdSession, context, arg_0, arg_1));
        future.addListener(arg_0 -> MinaConnector.lambda$connect$2(connectFuture, (IoConnectFuture)future, arg_0));
        connectFuture.addListener(arg_0 -> this.lambda$connect$3((IoConnectFuture)future, createdSession, context, arg_0));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$connect$3(IoConnectFuture future, AtomicReference createdSession, AttributeRepository context, ConnectFuture cf) {
        Throwable t = cf.getException();
        if (t != null) {
            future.setException(t);
        } else if (cf.isCanceled()) {
            org.apache.mina.core.session.IoSession ioSession = createdSession.getAndSet(null);
            CancelFuture cancellation = future.cancel();
            if (ioSession != null) {
                ioSession.setAttribute(CONNECT_FUTURE_KEY, (Object)future);
                ioSession.closeNow();
            } else if (cancellation != null) {
                cancellation.setCanceled();
            }
        } else {
            org.apache.mina.core.session.IoSession ioSession = cf.getSession();
            IoSession sshSession = this.getSession(ioSession);
            if (context != null) {
                sshSession.setAttribute(AttributeRepository.class, (Object)context);
            }
            future.setSession(sshSession);
            if (future.getSession() != sshSession) {
                try {
                    sshSession.close(true);
                }
                finally {
                    CancelFuture cancellation = future.getCancellation();
                    if (cancellation != null) {
                        cancellation.setCanceled();
                    }
                }
            } else {
                ioSession.removeAttribute(CONNECT_FUTURE_KEY);
            }
        }
    }

    private static /* synthetic */ void lambda$connect$2(ConnectFuture connectFuture, IoConnectFuture future, IoConnectFuture f) {
        if (f.isCanceled()) {
            connectFuture.cancel();
            org.apache.mina.core.session.IoSession ioSession = connectFuture.getSession();
            if (ioSession != null) {
                ioSession.setAttribute(CONNECT_FUTURE_KEY, (Object)future);
                ioSession.closeNow();
            }
        }
    }

    private static /* synthetic */ void lambda$connect$1(IoConnectFuture future, AtomicReference createdSession, AttributeRepository context, org.apache.mina.core.session.IoSession s, ConnectFuture f) {
        s.setAttribute(CONNECT_FUTURE_KEY, (Object)future);
        if (f.isCanceled()) {
            s.closeNow();
        } else {
            createdSession.set(s);
        }
        if (context != null) {
            s.setAttribute(AttributeRepository.class, (Object)context);
        }
    }
}

