/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.LoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpLoggingFilter
extends LoggingFilter {
    private boolean maskPassword = true;
    private final Logger logger;

    public FtpLoggingFilter() {
        this(FtpLoggingFilter.class.getName());
    }

    public FtpLoggingFilter(Class<?> clazz) {
        this(clazz.getName());
    }

    public FtpLoggingFilter(String name) {
        super(name);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        String request = (String)message;
        if (this.maskPassword && request.trim().toUpperCase().startsWith("PASS ")) {
            this.logger.info("RECEIVED: PASS *****");
        } else {
            this.logger.info("RECEIVED: {}", (Object)request);
        }
        nextFilter.messageReceived(session, message);
    }

    public boolean isMaskPassword() {
        return this.maskPassword;
    }

    public void setMaskPassword(boolean maskPassword) {
        this.maskPassword = maskPassword;
    }
}

