/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.project.MavenProject;

class ProjectExecutorService {
    private final ExecutorService executor;
    private final BlockingQueue<Future<MavenProject>> completion = new LinkedBlockingQueue<Future<MavenProject>>();
    private final Comparator<Runnable> taskComparator;

    public ProjectExecutorService(int degreeOfConcurrency, Comparator<MavenProject> projectComparator) {
        this.taskComparator = Comparator.comparing(r -> ((ProjectRunnable)r).getProject(), projectComparator);
        PriorityBlockingQueue<Runnable> executorWorkQueue = new PriorityBlockingQueue<Runnable>(degreeOfConcurrency, this.taskComparator);
        this.executor = new ThreadPoolExecutor(degreeOfConcurrency, degreeOfConcurrency, 0L, TimeUnit.MILLISECONDS, executorWorkQueue, (ThreadFactory)new BuildThreadFactory()){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                ProjectExecutorService.this.beforeExecute(t, r);
            }
        };
    }

    public void submitAll(Collection<? extends ProjectRunnable> tasks) {
        tasks.stream().sorted(this.taskComparator).map(projectRunnable -> new ProjectFutureTask((ProjectRunnable)projectRunnable)).forEach(this.executor::execute);
    }

    public MavenProject take() throws InterruptedException, ExecutionException {
        return this.completion.take().get();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void cancel() {
        this.executor.shutdownNow();
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    public void awaitShutdown() throws InterruptedException {
        this.executor.shutdown();
        while (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
        }
    }

    private class ProjectFutureTask
    extends FutureTask<MavenProject>
    implements ProjectRunnable {
        private ProjectRunnable task;

        public ProjectFutureTask(ProjectRunnable task) {
            super(task, task.getProject());
            this.task = task;
        }

        @Override
        protected void done() {
            ProjectExecutorService.this.completion.add(this);
        }

        @Override
        public MavenProject getProject() {
            return this.task.getProject();
        }
    }

    static interface ProjectRunnable
    extends Runnable {
        public MavenProject getProject();
    }
}

