/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Server
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String username;
    final String password;
    final String privateKey;
    final String passphrase;
    final String filePermissions;
    final String directoryPermissions;
    final XmlNode configuration;

    protected Server(Builder builder) {
        super(builder);
        String string = builder.username != null ? builder.username : (this.username = builder.base != null ? builder.base.username : null);
        String string2 = builder.password != null ? builder.password : (this.password = builder.base != null ? builder.base.password : null);
        String string3 = builder.privateKey != null ? builder.privateKey : (this.privateKey = builder.base != null ? builder.base.privateKey : null);
        String string4 = builder.passphrase != null ? builder.passphrase : (this.passphrase = builder.base != null ? builder.base.passphrase : null);
        String string5 = builder.filePermissions != null ? builder.filePermissions : (this.filePermissions = builder.base != null ? builder.base.filePermissions : null);
        String string6 = builder.directoryPermissions != null ? builder.directoryPermissions : (this.directoryPermissions = builder.base != null ? builder.base.directoryPermissions : null);
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getFilePermissions() {
        return this.filePermissions;
    }

    public String getDirectoryPermissions() {
        return this.directoryPermissions;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Server.newBuilder(this);
    }

    @Override
    @Nonnull
    public Server withId(String id) {
        return Server.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Server withUsername(String username) {
        return Server.newBuilder(this, true).username(username).build();
    }

    @Nonnull
    public Server withPassword(String password) {
        return Server.newBuilder(this, true).password(password).build();
    }

    @Nonnull
    public Server withPrivateKey(String privateKey) {
        return Server.newBuilder(this, true).privateKey(privateKey).build();
    }

    @Nonnull
    public Server withPassphrase(String passphrase) {
        return Server.newBuilder(this, true).passphrase(passphrase).build();
    }

    @Nonnull
    public Server withFilePermissions(String filePermissions) {
        return Server.newBuilder(this, true).filePermissions(filePermissions).build();
    }

    @Nonnull
    public Server withDirectoryPermissions(String directoryPermissions) {
        return Server.newBuilder(this, true).directoryPermissions(directoryPermissions).build();
    }

    @Nonnull
    public Server withConfiguration(XmlNode configuration) {
        return Server.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static Server newInstance() {
        return Server.newInstance(true);
    }

    @Nonnull
    public static Server newInstance(boolean withDefaults) {
        return Server.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Server.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Server from) {
        return Server.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Server from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Server base;
        String username;
        String password;
        String privateKey;
        String passphrase;
        String filePermissions;
        String directoryPermissions;
        XmlNode configuration;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Server base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.username = base.username;
                this.password = base.password;
                this.privateKey = base.privateKey;
                this.passphrase = base.passphrase;
                this.filePermissions = base.filePermissions;
                this.directoryPermissions = base.directoryPermissions;
                this.configuration = base.configuration;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Nonnull
        public Builder passphrase(String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        @Nonnull
        public Builder filePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return this;
        }

        @Nonnull
        public Builder directoryPermissions(String directoryPermissions) {
            this.directoryPermissions = directoryPermissions;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Server build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.username != null && this.username != this.base.username || this.password != null && this.password != this.base.password || this.privateKey != null && this.privateKey != this.base.privateKey || this.passphrase != null && this.passphrase != this.base.passphrase || this.filePermissions != null && this.filePermissions != this.base.filePermissions || this.directoryPermissions != null && this.directoryPermissions != this.base.directoryPermissions || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new Server(this);
        }
    }
}

