/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.Prompter;
import org.apache.maven.api.services.PrompterException;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;

@Singleton
@Named(value="console-prompt")
public class ConsolePasswordPrompt
implements MasterSource,
MasterSourceMeta {
    public static final String NAME = "console-prompt";
    private final Prompter prompter;

    @Inject
    public ConsolePasswordPrompt(Prompter prompter) {
        this.prompter = prompter;
    }

    public String description() {
        return "Secure console password prompt";
    }

    public Optional<String> configTemplate() {
        return Optional.empty();
    }

    public String handle(String config) throws SecDispatcherException {
        if (NAME.equals(config)) {
            try {
                return this.prompter.promptForPassword("Enter the master password: ");
            }
            catch (PrompterException e) {
                throw new SecDispatcherException("Could not collect the password", (Throwable)e);
            }
        }
        return null;
    }

    public SecDispatcher.ValidationResponse validateConfiguration(String config) {
        if (NAME.equals(config)) {
            return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, Map.of(), List.of());
        }
        return null;
    }
}

