/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.sharepoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.CommonsHTTPSender;
import org.apache.manifoldcf.connectorcommon.extmimemap.ExtensionMimeMap;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.util.URLDecoder;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.sharepoint.IFileStream;
import org.apache.manifoldcf.crawler.connectors.sharepoint.MatchMap;
import org.apache.manifoldcf.crawler.connectors.sharepoint.Messages;
import org.apache.manifoldcf.crawler.connectors.sharepoint.NameValue;
import org.apache.manifoldcf.crawler.connectors.sharepoint.SPSProxyHelper;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SharePointRepository
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: SharePointRepository.java 996524 2010-09-13 13:38:01Z kwright $";
    public static final String wsddPathProperty = "org.apache.manifoldcf.sharepoint.wsddpath";
    public static final String ACTIVITY_FETCH = "fetch";
    protected static final long sessionExpirationInterval = 300000L;
    private boolean supportsItemSecurity = false;
    private boolean dspStsWorks = true;
    private boolean attachmentsSupported = false;
    private boolean activeDirectoryAuthority = true;
    private String serverProtocol = null;
    private String serverUrl = null;
    private String fileBaseUrl = null;
    private String userName = null;
    private String strippedUserName = null;
    private String password = null;
    private String ntlmDomain = null;
    private String serverName = null;
    private String serverLocation = null;
    private String encodedServerLocation = null;
    private int serverPort = -1;
    private SPSProxyHelper proxy = null;
    private long sessionTimeout;
    private String keystoreData = null;
    private IKeystoreManager keystoreManager = null;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private static String currentHost = null;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final String[] attachmentDataNames;
    protected static final String[] fileStreamDataNames;
    protected static final String[] listItemStreamDataNames;

    protected void getSession() throws ManifoldCFException {
        if (this.proxy == null) {
            String serverVersion = this.params.getParameter("serverVersion");
            if (serverVersion == null) {
                serverVersion = "2.0";
            }
            this.supportsItemSecurity = !serverVersion.equals("2.0");
            this.dspStsWorks = serverVersion.equals("2.0") || serverVersion.equals("3.0");
            this.attachmentsSupported = !serverVersion.equals("2.0");
            String authorityType = this.params.getParameter("authorityType");
            if (authorityType == null) {
                authorityType = "ActiveDirectory";
            }
            this.activeDirectoryAuthority = authorityType.equals("ActiveDirectory");
            this.serverProtocol = this.params.getParameter("serverProtocol");
            if (this.serverProtocol == null) {
                this.serverProtocol = "http";
            }
            try {
                String serverPort = this.params.getParameter("serverPort");
                this.serverPort = serverPort == null || serverPort.length() == 0 ? (this.serverProtocol.equals("https") ? 443 : 80) : Integer.parseInt(serverPort);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            this.serverLocation = this.params.getParameter("serverLocation");
            if (this.serverLocation == null) {
                this.serverLocation = "";
            }
            if (this.serverLocation.endsWith("/")) {
                this.serverLocation = this.serverLocation.substring(0, this.serverLocation.length() - 1);
            }
            if (this.serverLocation.length() > 0 && !this.serverLocation.startsWith("/")) {
                this.serverLocation = "/" + this.serverLocation;
            }
            this.encodedServerLocation = this.serverLocation;
            this.serverLocation = SharePointRepository.decodePath(this.serverLocation);
            this.userName = this.params.getParameter("userName");
            this.password = this.params.getObfuscatedParameter("password");
            int index = this.userName.indexOf("\\");
            if (index != -1) {
                this.strippedUserName = this.userName.substring(index + 1);
                this.ntlmDomain = this.userName.substring(0, index);
            } else {
                this.strippedUserName = null;
                this.ntlmDomain = null;
            }
            String proxyHost = this.params.getParameter("proxyHost");
            String proxyPortString = this.params.getParameter("proxyPort");
            int proxyPort = 8080;
            if (proxyPortString != null && proxyPortString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            String proxyUsername = this.params.getParameter("proxyUser");
            String proxyPassword = this.params.getParameter("proxyPassword");
            String proxyDomain = this.params.getParameter("proxyDomain");
            this.serverUrl = this.serverProtocol + "://" + this.serverName;
            if (this.serverProtocol.equals("https")) {
                if (this.serverPort != 443) {
                    this.serverUrl = this.serverUrl + ":" + Integer.toString(this.serverPort);
                }
            } else if (this.serverPort != 80) {
                this.serverUrl = this.serverUrl + ":" + Integer.toString(this.serverPort);
            }
            this.fileBaseUrl = this.serverUrl + this.encodedServerLocation;
            this.keystoreData = this.params.getParameter("keystore");
            int connectionTimeout = 60000;
            int socketTimeout = 900000;
            SSLConnectionSocketFactory myFactory = null;
            if (this.keystoreData != null) {
                this.keystoreManager = KeystoreManagerFactory.make((String)"", (String)this.keystoreData);
                myFactory = new SSLConnectionSocketFactory(this.keystoreManager.getSecureSocketFactory(), (HostnameVerifier)new DefaultHostnameVerifier());
            } else {
                myFactory = SSLConnectionSocketFactory.getSocketFactory();
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(60000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.strippedUserName != null) {
                credentialsProvider.setCredentials(new AuthScope(this.serverName, this.serverPort), (Credentials)new NTCredentials(this.strippedUserName, this.password, currentHost, this.ntlmDomain));
            }
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            if (proxyHost != null && proxyHost.length() > 0) {
                if (proxyUsername != null && proxyUsername.length() > 0) {
                    if (proxyPassword == null) {
                        proxyPassword = "";
                    }
                    if (proxyDomain == null) {
                        proxyDomain = "";
                    }
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, currentHost, proxyDomain));
                }
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                requestBuilder.setProxy(proxy);
            }
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            builder.setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = builder.build();
            this.proxy = new SPSProxyHelper(this.serverUrl, this.encodedServerLocation, this.serverLocation, this.userName, this.password, CommonsHTTPSender.class, "client-config.wsdd", this.httpClient);
        }
        this.sessionTimeout = System.currentTimeMillis() + 300000L;
    }

    protected void expireSession() throws ManifoldCFException {
        this.serverUrl = null;
        this.fileBaseUrl = null;
        this.userName = null;
        this.strippedUserName = null;
        this.password = null;
        this.ntlmDomain = null;
        this.serverLocation = null;
        this.encodedServerLocation = null;
        this.serverPort = -1;
        this.keystoreData = null;
        this.keystoreManager = null;
        this.proxy = null;
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.serverName = configParameters.getParameter("serverName");
    }

    public void disconnect() throws ManifoldCFException {
        this.serverUrl = null;
        this.fileBaseUrl = null;
        this.userName = null;
        this.strippedUserName = null;
        this.password = null;
        this.ntlmDomain = null;
        this.serverName = null;
        this.serverLocation = null;
        this.encodedServerLocation = null;
        this.serverPort = -1;
        this.keystoreData = null;
        this.keystoreManager = null;
        this.proxy = null;
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.serverName};
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        try {
            URL urlServer = new URL(this.serverUrl);
        }
        catch (MalformedURLException e) {
            return "Illegal SharePoint url: " + e.getMessage();
        }
        try {
            this.proxy.checkConnection("/", this.supportsItemSecurity);
        }
        catch (ServiceInterruption e) {
            return "SharePoint temporarily unavailable: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return e.getMessage();
        }
        return super.check();
    }

    public void poll() throws ManifoldCFException {
        if (this.proxy != null && System.currentTimeMillis() >= this.sessionTimeout) {
            this.expireSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isConnected() {
        return this.connectionManager != null;
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.startsWith("fields/")) {
            String remainder = command.substring("fields/".length());
            try {
                String sitePath;
                String library;
                int index = remainder.indexOf("/");
                if (index == -1) {
                    library = remainder;
                    sitePath = "";
                } else {
                    library = remainder.substring(0, index);
                    sitePath = remainder.substring(index + 1);
                }
                Map<String, String> fieldSet = this.getLibFieldList(sitePath, library);
                for (String fieldName : fieldSet.keySet()) {
                    String displayName = fieldSet.get(fieldName);
                    ConfigurationNode node = new ConfigurationNode("field");
                    ConfigurationNode child = new ConfigurationNode("name");
                    child.setValue(fieldName);
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("display_name");
                    child.setValue(displayName);
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("listfields/")) {
            String remainder = command.substring("listfields/".length());
            try {
                String sitePath;
                String listName;
                int index = remainder.indexOf("/");
                if (index == -1) {
                    listName = remainder;
                    sitePath = "";
                } else {
                    listName = remainder.substring(0, index);
                    sitePath = remainder.substring(index + 1);
                }
                Map<String, String> fieldSet = this.getListFieldList(sitePath, listName);
                for (String fieldName : fieldSet.keySet()) {
                    String displayName = fieldSet.get(fieldName);
                    ConfigurationNode node = new ConfigurationNode("field");
                    ConfigurationNode child = new ConfigurationNode("name");
                    child.setValue(fieldName);
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("display_name");
                    child.setValue(displayName);
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("sites/")) {
            try {
                String sitePath = command.substring("sites/".length());
                List<NameValue> sites = this.getSites(sitePath);
                int i = 0;
                while (i < sites.size()) {
                    NameValue site = sites.get(i++);
                    ConfigurationNode node = new ConfigurationNode("site");
                    ConfigurationNode child = new ConfigurationNode("name");
                    child.setValue(site.getValue());
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("display_name");
                    child.setValue(site.getPrettyName());
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("libraries/")) {
            try {
                String sitePath = command.substring("libraries/".length());
                List<NameValue> libs = this.getDocLibsBySite(sitePath);
                int i = 0;
                while (i < libs.size()) {
                    NameValue lib = libs.get(i++);
                    ConfigurationNode node = new ConfigurationNode("library");
                    ConfigurationNode child = new ConfigurationNode("name");
                    child.setValue(lib.getValue());
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("display_name");
                    child.setValue(lib.getPrettyName());
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("lists/")) {
            try {
                String sitePath = command.substring("lists/".length());
                List<NameValue> libs = this.getListsBySite(sitePath);
                int i = 0;
                while (i < libs.size()) {
                    NameValue lib = libs.get(i++);
                    ConfigurationNode node = new ConfigurationNode("list");
                    ConfigurationNode child = new ConfigurationNode("name");
                    child.setValue(lib.getValue());
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("display_name");
                    child.setValue(lib.getPrettyName());
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        activities.addSeedDocument("/");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] forcedAcls = SharePointRepository.getAcls(spec);
        SystemMetadataDescription sDesc = new SystemMetadataDescription(spec);
        String pathAttributeName = null;
        MatchMap matchMap = new MatchMap();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode n;
            if ((n = spec.getChild(i++)).getType().equals("pathnameattribute")) {
                pathAttributeName = n.getAttributeValue("value");
                continue;
            }
            if (!n.getType().equals("pathmap")) continue;
            String pathMatch = n.getAttributeValue("match");
            String pathReplace = n.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        StringBuilder pathNameAttributeVersion = new StringBuilder();
        if (pathAttributeName != null) {
            pathNameAttributeVersion.append("=").append(pathAttributeName).append(":").append(matchMap);
        }
        for (String documentIdentifier : documentIdentifiers) {
            activities.checkJobStillActive();
            this.getSession();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Getting version of '" + documentIdentifier + "'"));
            }
            if (documentIdentifier.startsWith("D") || documentIdentifier.startsWith("S")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Removing old-style document identifier '" + documentIdentifier + "'"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            if (documentIdentifier.startsWith("/")) {
                List<NameValue> lists;
                List<NameValue> libraries;
                List<NameValue> subsites;
                String sitePath;
                IFileStream fs;
                Object[] denyTokens;
                Object[] accessTokens;
                String[] fields;
                Map<String, String> fieldNames;
                String encodedSitePath;
                String versionString;
                int dListSeparatorIndex = documentIdentifier.indexOf("///");
                int dLibSeparatorIndex = documentIdentifier.indexOf("//");
                if (dListSeparatorIndex != -1) {
                    String fileUrl;
                    if (dListSeparatorIndex == documentIdentifier.length() - 3) {
                        String listID;
                        if (!this.checkIncludeList(documentIdentifier.substring(0, documentIdentifier.length() - 3), spec)) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: List specification no longer includes list '" + documentIdentifier + "' - removing"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        versionString = "";
                        String siteListPath = documentIdentifier.substring(0, documentIdentifier.length() - 3);
                        int listCutoff = siteListPath.lastIndexOf("/");
                        String site = siteListPath.substring(0, listCutoff);
                        String listName = siteListPath.substring(listCutoff + 1);
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Document identifier is a list: '" + siteListPath + "'"));
                        }
                        if ((listID = this.proxy.getListID(SharePointRepository.encodePath(site), site, listName)) == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: GUID lookup failed for list '" + siteListPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        encodedSitePath = SharePointRepository.encodePath(site);
                        fieldNames = this.proxy.getFieldList(encodedSitePath, listID);
                        if (fieldNames == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Field list lookup failed for list '" + siteListPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        fields = new String[fieldNames.size()];
                        int j = 0;
                        for (String field : fieldNames.values()) {
                            fields[j++] = field;
                        }
                        if (forcedAcls == null) {
                            accessTokens = new String[]{};
                            denyTokens = new String[]{};
                        } else if (forcedAcls.length != 0) {
                            accessTokens = forcedAcls;
                            denyTokens = new String[]{};
                        } else {
                            accessTokens = this.proxy.getACLs(encodedSitePath, listID, this.activeDirectoryAuthority);
                            denyTokens = new String[]{defaultAuthorityDenyToken};
                        }
                        if (accessTokens == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Access token lookup failed for list '" + siteListPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        fs = new ListItemStream(activities, this.encodedServerLocation, site, siteListPath, spec, documentIdentifier, (String[])accessTokens, (String[])denyTokens, listID, fields);
                        boolean success = this.proxy.getChildren(fs, encodedSitePath, listID, this.dspStsWorks);
                        if (!success) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: No list found for list '" + siteListPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    String decodedListPath = documentIdentifier.substring(0, dListSeparatorIndex);
                    String itemAndAttachment = documentIdentifier.substring(dListSeparatorIndex + 2);
                    String decodedItemPath = decodedListPath + itemAndAttachment;
                    int cutoff = decodedListPath.lastIndexOf("/");
                    sitePath = decodedListPath.substring(0, cutoff);
                    String list = decodedListPath.substring(cutoff + 1);
                    encodedSitePath = SharePointRepository.encodePath(sitePath);
                    int attachmentSeparatorIndex = itemAndAttachment.indexOf("//", 1);
                    if (attachmentSeparatorIndex == -1) {
                        if (!this.checkIncludeListItem(decodedItemPath, spec)) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: List item '" + documentIdentifier + "' is no longer included - removing"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        MetadataInformation metadataInfo = this.getMetadataSpecification(decodedItemPath, spec);
                        Object[] accessTokens2 = activities.retrieveParentData(documentIdentifier, "accessTokens");
                        Object[] denyTokens2 = activities.retrieveParentData(documentIdentifier, "denyTokens");
                        String[] listIDs = activities.retrieveParentData(documentIdentifier, "guids");
                        String[] listFields = activities.retrieveParentData(documentIdentifier, "fields");
                        String[] displayURLs = activities.retrieveParentData(documentIdentifier, "displayURLs");
                        String listID = listIDs.length >= 1 ? listIDs[0] : null;
                        String displayURL = displayURLs.length >= 1 ? displayURLs[0] : null;
                        if (listID == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Can't get version of '" + documentIdentifier + "' because list '" + decodedListPath + "' does not exist - removing"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        String[] sortedMetadataFields = this.getInterestingFieldSetSorted(metadataInfo, listFields);
                        Arrays.sort(accessTokens2);
                        Arrays.sort(denyTokens2);
                        ArrayList<String> metadataDescription = new ArrayList<String>();
                        metadataDescription.add("Modified");
                        metadataDescription.add("Created");
                        metadataDescription.add("ID");
                        metadataDescription.add("GUID");
                        String decodedItemPathWithoutSite = decodedItemPath.substring(cutoff + 1);
                        Map<String, String> values = this.proxy.getFieldValues(metadataDescription.toArray(new String[0]), encodedSitePath, listID, "/Lists/" + decodedItemPathWithoutSite, this.dspStsWorks);
                        String modifiedDate = values.get("Modified");
                        String createdDate = values.get("Created");
                        String id = values.get("ID");
                        String guid = values.get("GUID");
                        if (modifiedDate == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Can't get version of '" + documentIdentifier + "' because it has no modify date"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        Date modifiedDateValue = DateParser.parseISO8601Date((String)modifiedDate);
                        Date createdDateValue = DateParser.parseISO8601Date((String)createdDate);
                        String versionToken = modifiedDate;
                        StringBuilder sb = new StringBuilder();
                        SharePointRepository.packList((StringBuilder)sb, (String[])sortedMetadataFields, (char)'+');
                        SharePointRepository.packList((StringBuilder)sb, (String[])accessTokens2, (char)'+');
                        SharePointRepository.packList((StringBuilder)sb, (String[])denyTokens2, (char)'+');
                        SharePointRepository.packDate(sb, modifiedDateValue);
                        SharePointRepository.packDate(sb, createdDateValue);
                        SharePointRepository.pack((StringBuilder)sb, (String)id, (char)'+');
                        SharePointRepository.pack((StringBuilder)sb, (String)guid, (char)'+');
                        SharePointRepository.pack((StringBuilder)sb, (String)displayURL, (char)'+');
                        sb.append(versionToken);
                        sb.append((CharSequence)pathNameAttributeVersion);
                        sb.append("_").append(this.fileBaseUrl);
                        String versionString2 = sb.toString();
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Complete version string for '" + documentIdentifier + "': " + versionString2));
                        }
                        if (this.attachmentsSupported) {
                            String itemNumber = id;
                            List<NameValue> attachmentNames = this.proxy.getAttachmentNames(sitePath, listID, itemNumber);
                            for (NameValue attachmentName : attachmentNames) {
                                Object[][] dataValues = new String[attachmentDataNames.length][];
                                dataValues[0] = createdDateValue == null ? new String[0] : new String[]{new Long(createdDateValue.getTime()).toString()};
                                dataValues[1] = modifiedDateValue == null ? new String[0] : new String[]{new Long(modifiedDateValue.getTime()).toString()};
                                dataValues[2] = accessTokens2 == null ? new String[0] : accessTokens2;
                                dataValues[3] = denyTokens2 == null ? new String[0] : denyTokens2;
                                dataValues[4] = new String[]{attachmentName.getPrettyName()};
                                dataValues[5] = new String[]{guid};
                                activities.addDocumentReference(documentIdentifier + "//" + attachmentName.getValue(), documentIdentifier, null, attachmentDataNames, dataValues);
                            }
                        }
                        if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString2)) continue;
                        String encodedItemPath = SharePointRepository.encodePath(decodedListPath.substring(0, cutoff) + "/Lists/" + decodedItemPath.substring(cutoff + 1));
                        String itemUrl = this.serverUrl + displayURL;
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Processing list item '" + documentIdentifier + "'; url: '" + itemUrl + "'"));
                        }
                        Map<String, String> metadataValues = null;
                        if (sortedMetadataFields.length > 0 && (metadataValues = this.proxy.getFieldValues(sortedMetadataFields, SharePointRepository.encodePath(sitePath), listID, "/Lists/" + decodedItemPath.substring(cutoff + 1), this.dspStsWorks)) == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Item metadata fetch failure indicated that item is gone: '" + documentIdentifier + "' - removing"));
                            }
                            activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, "NOMETADATA", "List item metadata is missing", null);
                            activities.noDocument(documentIdentifier, versionString2);
                            continue;
                        }
                        if (!activities.checkLengthIndexable(0L)) {
                            activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, "EXCLUDEDLENGTH", "List item excluded due to content length (0)", null);
                            activities.noDocument(documentIdentifier, versionString2);
                            continue;
                        }
                        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                        try {
                            RepositoryDocument data = new RepositoryDocument();
                            data.setBinary((InputStream)is, 0L);
                            if (modifiedDateValue != null) {
                                data.setModifiedDate(modifiedDateValue);
                            }
                            if (createdDateValue != null) {
                                data.setCreatedDate(createdDateValue);
                            }
                            SharePointRepository.setDataACLs(data, (String[])accessTokens2, (String[])denyTokens2);
                            SharePointRepository.setPathAttribute(data, sDesc, documentIdentifier);
                            if (metadataValues != null) {
                                for (String fieldName : metadataValues.keySet()) {
                                    String fieldData = metadataValues.get(fieldName);
                                    data.addField(fieldName, fieldData);
                                }
                            }
                            data.addField("GUID", guid);
                            try {
                                activities.ingestDocumentWithException(documentIdentifier, versionString2, itemUrl, data);
                            }
                            catch (IOException e) {
                                SharePointRepository.handleIOException(e, "reading document");
                            }
                            continue;
                        }
                        finally {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e) {
                                SharePointRepository.handleIOException(e, "closing stream");
                            }
                        }
                    }
                    if (!this.checkIncludeListItemAttachment(decodedItemPath, spec)) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: List item attachment '" + documentIdentifier + "' is no longer included - removing"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    String[] modifiedDateSet = activities.retrieveParentData(documentIdentifier, "modifiedDate");
                    String[] createdDateSet = activities.retrieveParentData(documentIdentifier, "createdDate");
                    accessTokens = activities.retrieveParentData(documentIdentifier, "accessTokens");
                    denyTokens = activities.retrieveParentData(documentIdentifier, "denyTokens");
                    String[] urlSet = activities.retrieveParentData(documentIdentifier, "url");
                    String modifiedDate = modifiedDateSet.length >= 1 ? modifiedDateSet[0] : null;
                    String createdDate = createdDateSet.length >= 1 ? createdDateSet[0] : null;
                    String url = urlSet.length >= 1 ? urlSet[0] : null;
                    if (modifiedDate == null || url == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Can't get version of '" + documentIdentifier + "' because modified date or attachment url not found"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    Date modifiedDateValue = modifiedDate != null ? new Date(new Long(modifiedDate)) : null;
                    Date createdDateValue = createdDate != null ? new Date(new Long(createdDate)) : null;
                    String versionToken = modifiedDate;
                    StringBuilder sb = new StringBuilder();
                    SharePointRepository.pack((StringBuilder)sb, (String)url, (char)'+');
                    Arrays.sort(accessTokens);
                    Arrays.sort(denyTokens);
                    SharePointRepository.packList((StringBuilder)sb, (String[])accessTokens, (char)'+');
                    SharePointRepository.packList((StringBuilder)sb, (String[])denyTokens, (char)'+');
                    SharePointRepository.packDate(sb, modifiedDateValue);
                    SharePointRepository.packDate(sb, createdDateValue);
                    sb.append(versionToken);
                    sb.append((CharSequence)pathNameAttributeVersion);
                    sb.append("_").append(this.fileBaseUrl);
                    String versionString3 = sb.toString();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Complete version string for '" + documentIdentifier + "': " + versionString3));
                    }
                    if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString3)) continue;
                    String[] guids = activities.retrieveParentData(documentIdentifier, "guids");
                    String guid = guids.length >= 1 ? guids[0] : null;
                    if (guid == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Skipping attachment '" + documentIdentifier + "' because no parent guid found"));
                        }
                        activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, "NOGUID", "List item attachment GUID is missing", null);
                        activities.noDocument(documentIdentifier, versionString3);
                        continue;
                    }
                    int lastIndex = url.lastIndexOf("/");
                    guid = guid + ":" + url.substring(lastIndex + 1);
                    String fetchUrl = fileUrl = this.serverUrl + SharePointRepository.encodePath(url);
                    this.fetchAndIndexFile(activities, documentIdentifier, versionString3, fileUrl, fetchUrl, (String[])accessTokens, (String[])denyTokens, createdDateValue, modifiedDateValue, null, guid, sDesc);
                    continue;
                }
                if (dLibSeparatorIndex != -1) {
                    if (dLibSeparatorIndex == documentIdentifier.length() - 2) {
                        String libID;
                        if (!this.checkIncludeLibrary(documentIdentifier.substring(0, documentIdentifier.length() - 2), spec)) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Library specification no longer includes library '" + documentIdentifier + "' - removing"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        versionString = "";
                        String siteLibPath = documentIdentifier.substring(0, documentIdentifier.length() - 2);
                        int libCutoff = siteLibPath.lastIndexOf("/");
                        String site = siteLibPath.substring(0, libCutoff);
                        String libName = siteLibPath.substring(libCutoff + 1);
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Document identifier is a library: '" + siteLibPath + "'"));
                        }
                        if ((libID = this.proxy.getDocLibID(SharePointRepository.encodePath(site), site, libName)) == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: GUID lookup failed for library '" + siteLibPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        encodedSitePath = SharePointRepository.encodePath(site);
                        fieldNames = this.proxy.getFieldList(encodedSitePath, libID);
                        if (fieldNames == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Field list lookup failed for library '" + siteLibPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        fields = new String[fieldNames.size()];
                        int j = 0;
                        for (String field : fieldNames.values()) {
                            fields[j++] = field;
                        }
                        if (forcedAcls == null) {
                            accessTokens = new String[]{};
                            denyTokens = new String[]{};
                        } else if (forcedAcls.length != 0) {
                            accessTokens = forcedAcls;
                            denyTokens = new String[]{};
                        } else {
                            accessTokens = this.proxy.getACLs(encodedSitePath, libID, this.activeDirectoryAuthority);
                            denyTokens = new String[]{defaultAuthorityDenyToken};
                        }
                        if (accessTokens == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: Access token lookup failed for library '" + siteLibPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        fs = new FileStream(activities, this.encodedServerLocation, site, siteLibPath, spec, documentIdentifier, (String[])accessTokens, (String[])denyTokens, libID, fields);
                        boolean success = this.proxy.getChildren(fs, encodedSitePath, libID, this.dspStsWorks);
                        if (!success) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("SharePoint: No list found for library '" + siteLibPath + "' - deleting"));
                            }
                            activities.deleteDocument(documentIdentifier);
                            continue;
                        }
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    String decodedLibPath = documentIdentifier.substring(0, dLibSeparatorIndex);
                    String decodedDocumentPath = decodedLibPath + documentIdentifier.substring(dLibSeparatorIndex + 1);
                    if (!this.checkIncludeFile(decodedDocumentPath, spec)) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Document '" + documentIdentifier + "' is no longer included - removing"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    MetadataInformation metadataInfo = this.getMetadataSpecification(decodedDocumentPath, spec);
                    int lastIndex = decodedLibPath.lastIndexOf("/");
                    sitePath = decodedLibPath.substring(0, lastIndex);
                    String lib = decodedLibPath.substring(lastIndex + 1);
                    Object[] accessTokens3 = activities.retrieveParentData(documentIdentifier, "accessTokens");
                    Object[] denyTokens3 = activities.retrieveParentData(documentIdentifier, "denyTokens");
                    String[] libIDs = activities.retrieveParentData(documentIdentifier, "guids");
                    String[] libFields = activities.retrieveParentData(documentIdentifier, "fields");
                    String libID = libIDs.length >= 1 ? libIDs[0] : null;
                    if (libID == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Can't get version of '" + documentIdentifier + "' because library '" + decodedLibPath + "' does not exist - removing"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    String encodedSitePath2 = SharePointRepository.encodePath(sitePath);
                    String[] sortedMetadataFields = this.getInterestingFieldSetSorted(metadataInfo, libFields);
                    Arrays.sort(accessTokens3);
                    Arrays.sort(denyTokens3);
                    ArrayList<String> metadataDescription = new ArrayList<String>();
                    metadataDescription.add("Last_x0020_Modified");
                    metadataDescription.add("Modified");
                    metadataDescription.add("Created");
                    metadataDescription.add("GUID");
                    int cutoff = decodedLibPath.lastIndexOf("/");
                    String decodedDocumentPathWithoutSite = decodedDocumentPath.substring(cutoff);
                    Map<String, String> values = this.proxy.getFieldValues(metadataDescription.toArray(new String[0]), encodedSitePath2, libID, decodedDocumentPathWithoutSite, this.dspStsWorks);
                    String modifiedDate = values.get("Modified");
                    String createdDate = values.get("Created");
                    String guid = values.get("GUID");
                    String modifyDate = values.get("Last_x0020_Modified");
                    if (modifyDate == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Can't get version of '" + documentIdentifier + "' because it has no modify date"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    Date modifiedDateValue = DateParser.parseISO8601Date((String)modifiedDate);
                    Date createdDateValue = DateParser.parseISO8601Date((String)createdDate);
                    String versionToken = modifyDate;
                    if (this.supportsItemSecurity) {
                        if (forcedAcls == null) {
                            accessTokens3 = new String[]{};
                            denyTokens3 = new String[]{};
                        } else if (forcedAcls.length > 0) {
                            accessTokens3 = forcedAcls;
                            denyTokens3 = new String[]{};
                        } else {
                            accessTokens3 = this.proxy.getDocumentACLs(encodedSitePath2, SharePointRepository.encodePath(decodedDocumentPath), this.activeDirectoryAuthority);
                            denyTokens3 = new String[]{defaultAuthorityDenyToken};
                        }
                    }
                    if (accessTokens3 == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Couldn't get access tokens for item '" + decodedDocumentPath + "'; removing document '" + documentIdentifier + "'"));
                        }
                        activities.deleteDocument(documentIdentifier);
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    SharePointRepository.packList((StringBuilder)sb, (String[])sortedMetadataFields, (char)'+');
                    SharePointRepository.packList((StringBuilder)sb, (String[])accessTokens3, (char)'+');
                    SharePointRepository.packList((StringBuilder)sb, (String[])denyTokens3, (char)'+');
                    SharePointRepository.packDate(sb, modifiedDateValue);
                    SharePointRepository.packDate(sb, createdDateValue);
                    SharePointRepository.pack((StringBuilder)sb, (String)guid, (char)'+');
                    sb.append(versionToken);
                    sb.append((CharSequence)pathNameAttributeVersion);
                    sb.append("_").append(this.fileBaseUrl);
                    String versionString4 = sb.toString();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Complete version string for '" + documentIdentifier + "': " + versionString4));
                    }
                    if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString4)) continue;
                    String encodedDocumentPath = SharePointRepository.encodePath(decodedDocumentPath);
                    String fileUrl = this.fileBaseUrl + encodedDocumentPath;
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Processing file '" + documentIdentifier + "'; url: '" + fileUrl + "'"));
                    }
                    Map<String, String> metadataValues = null;
                    if (sortedMetadataFields.length > 0 && (metadataValues = this.proxy.getFieldValues(sortedMetadataFields, SharePointRepository.encodePath(sitePath), libID, decodedDocumentPath.substring(cutoff), this.dspStsWorks)) == null) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Document metadata fetch failure indicated that document is gone: '" + documentIdentifier + "' - removing"));
                        }
                        activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, "NOMETADATA", "Document metadata is missing", null);
                        activities.noDocument(documentIdentifier, versionString4);
                        continue;
                    }
                    this.fetchAndIndexFile(activities, documentIdentifier, versionString4, fileUrl, this.serverUrl + this.encodedServerLocation + encodedDocumentPath, (String[])accessTokens3, (String[])denyTokens3, createdDateValue, modifiedDateValue, metadataValues, guid, sDesc);
                    continue;
                }
                String sitePath2 = documentIdentifier.substring(0, documentIdentifier.length() - 1);
                if (sitePath2.length() == 0) {
                    sitePath2 = "/";
                }
                if (!this.checkIncludeSite(sitePath2, spec)) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Site specification no longer includes site '" + documentIdentifier + "' - removing"));
                    }
                    activities.deleteDocument(documentIdentifier);
                    continue;
                }
                String versionString5 = "";
                activities.noDocument(documentIdentifier, versionString5);
                String decodedSitePath = documentIdentifier.substring(0, documentIdentifier.length() - 1);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Document identifier is a site: '" + decodedSitePath + "'"));
                }
                if ((subsites = this.proxy.getSites(SharePointRepository.encodePath(decodedSitePath))) != null) {
                    for (NameValue subSiteName : subsites) {
                        String newPath = decodedSitePath + "/" + subSiteName.getValue();
                        String encodedNewPath = SharePointRepository.encodePath(newPath);
                        if (!this.checkIncludeSite(newPath, spec)) continue;
                        activities.addDocumentReference(newPath + "/");
                    }
                } else if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: No permissions to access subsites of '" + decodedSitePath + "' - skipping"));
                }
                if ((libraries = this.proxy.getDocumentLibraries(SharePointRepository.encodePath(decodedSitePath), decodedSitePath)) != null) {
                    for (NameValue library : libraries) {
                        String newPath = decodedSitePath + "/" + library.getValue();
                        if (!this.checkIncludeLibrary(newPath, spec)) continue;
                        activities.addDocumentReference(newPath + "//");
                    }
                } else if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: No permissions to access libraries of '" + decodedSitePath + "' - skipping"));
                }
                if ((lists = this.proxy.getLists(SharePointRepository.encodePath(decodedSitePath), decodedSitePath)) != null) {
                    for (NameValue list : lists) {
                        String newPath = decodedSitePath + "/" + list.getValue();
                        if (!this.checkIncludeList(newPath, spec)) continue;
                        activities.addDocumentReference(newPath + "///");
                    }
                    continue;
                }
                if (!Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)("SharePoint: No permissions to access lists of '" + decodedSitePath + "' - skipping"));
                continue;
            }
            throw new ManifoldCFException("Invalid document identifier discovered: '" + documentIdentifier + "'");
        }
    }

    protected static void packDate(StringBuilder sb, Date dateValue) {
        if (dateValue != null) {
            sb.append("+");
            SharePointRepository.pack((StringBuilder)sb, (String)new Long(dateValue.getTime()).toString(), (char)'+');
        } else {
            sb.append("-");
        }
    }

    protected static int unpackDate(String value, int index, Date theDate) {
        if (value.length() > index && value.charAt(index++) == '+') {
            StringBuilder sb = new StringBuilder();
            index = SharePointRepository.unpack((StringBuilder)sb, (String)value, (int)index, (char)'+');
            if (sb.length() > 0) {
                theDate.setTime(new Long(sb.toString()));
            }
        }
        return index;
    }

    protected String[] getInterestingFieldSetSorted(MetadataInformation metadataInfo, String[] allFields) {
        HashSet<String> metadataFields = new HashSet<String>();
        if (metadataInfo.getAllMetadata()) {
            for (String field : allFields) {
                metadataFields.add(field);
            }
        } else {
            String[] fields;
            for (String field : fields = metadataInfo.getMetadataFields()) {
                metadataFields.add(field);
            }
        }
        Object[] sortedMetadataFields = new String[metadataFields.size()];
        int z = 0;
        for (String field : metadataFields) {
            sortedMetadataFields[z++] = field;
        }
        Arrays.sort(sortedMetadataFields);
        return sortedMetadataFields;
    }

    /*
     * Exception decompiling
     */
    protected void fetchAndIndexFile(IProcessActivity activities, String documentIdentifier, String version, String fileUrl, String fetchUrl, String[] accessTokens, String[] denyTokens, Date createdDate, Date modifiedDate, Map<String, String> metadataValues, String guid, SystemMetadataDescription sDesc) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("SharePoint is down attempting to " + context + ", retrying: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        if (e instanceof ConnectTimeoutException) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("SharePoint is down attempting to " + context + ", retrying: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected static String mapExtensionToMimeType(String fileName) {
        int dotIndex;
        int slashIndex = fileName.lastIndexOf("/");
        if (slashIndex != -1) {
            fileName = fileName.substring(slashIndex + 1);
        }
        if ((dotIndex = fileName.lastIndexOf(".")) == -1) {
            return null;
        }
        return ExtensionMimeMap.mapToMimeType((String)fileName.substring(dotIndex + 1));
    }

    protected static String mapToFileName(String fileName) {
        int slashIndex = fileName.lastIndexOf("/");
        if (slashIndex != -1) {
            fileName = fileName.substring(slashIndex + 1);
        }
        return fileName;
    }

    protected static void setDataACLs(RepositoryDocument data, String[] acls, String[] denyAcls) {
        StringBuilder sb;
        if (acls != null) {
            if (Logging.connectors.isDebugEnabled()) {
                sb = new StringBuilder("SharePoint: Acls: [ ");
                for (String acl : acls) {
                    sb.append(acl).append(" ");
                }
                sb.append("]");
                Logging.connectors.debug((Object)sb.toString());
            }
            data.setSecurityACL("document", acls);
        }
        if (denyAcls != null) {
            if (Logging.connectors.isDebugEnabled()) {
                sb = new StringBuilder("SharePoint: DenyAcls: [ ");
                for (String denyAcl : denyAcls) {
                    sb.append(denyAcl).append(" ");
                }
                sb.append("]");
                Logging.connectors.debug((Object)sb.toString());
            }
            data.setSecurityDenyACL("document", denyAcls);
        }
    }

    protected static void setPathAttribute(RepositoryDocument data, SystemMetadataDescription sDesc, String documentIdentifier) throws ManifoldCFException {
        String pathAttributeName = sDesc.getPathAttributeName();
        if (pathAttributeName != null && pathAttributeName.length() > 0) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Path attribute name is '" + pathAttributeName + "'"));
            }
            String pathString = sDesc.getPathAttributeValue(documentIdentifier);
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Path attribute value is '" + pathString + "'"));
            }
            data.addField(pathAttributeName, pathString);
        } else {
            Logging.connectors.debug((Object)"SharePoint: Path attribute name is null");
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharePointRepository.Server"));
        tabsArray.add(Messages.getString(locale, "SharePointRepository.AuthorityType"));
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js", null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        SharePointRepository.fillInServerTab(velocityContext, out, parameters);
        SharePointRepository.fillInAuthorityTypeTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Server.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_AuthorityType.html", velocityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String authorityType;
        String configOp;
        String keystoreValue;
        String proxyDomain;
        String proxyPassword;
        String proxyUser;
        String proxyPort;
        String proxyHost;
        String password;
        String userName;
        String serverLocation;
        String serverPort;
        String serverName;
        String serverProtocol;
        String serverVersion = variableContext.getParameter("serverVersion");
        if (serverVersion != null) {
            parameters.setParameter("serverVersion", serverVersion);
        }
        if ((serverProtocol = variableContext.getParameter("serverProtocol")) != null) {
            parameters.setParameter("serverProtocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("serverName")) != null) {
            parameters.setParameter("serverName", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverPort")) != null) {
            parameters.setParameter("serverPort", serverPort);
        }
        if ((serverLocation = variableContext.getParameter("serverLocation")) != null) {
            parameters.setParameter("serverLocation", serverLocation);
        }
        if ((userName = variableContext.getParameter("serverUserName")) != null) {
            parameters.setParameter("userName", userName);
        }
        if ((password = variableContext.getParameter("serverPassword")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("proxyHost", proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("proxyPort", proxyPort);
        }
        if ((proxyUser = variableContext.getParameter("proxyuser")) != null) {
            parameters.setParameter("proxyUser", proxyUser);
        }
        if ((proxyPassword = variableContext.getParameter("proxypassword")) != null) {
            parameters.setObfuscatedParameter("proxyPassword", variableContext.mapKeyToPassword(proxyPassword));
        }
        if ((proxyDomain = variableContext.getParameter("proxydomain")) != null) {
            parameters.setParameter("proxyDomain", proxyDomain);
        }
        if ((keystoreValue = variableContext.getParameter("keystoredata")) != null) {
            parameters.setParameter("keystore", keystoreValue);
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            String alias;
            if (configOp.equals("Delete")) {
                alias = variableContext.getParameter("shpkeystorealias");
                keystoreValue = parameters.getParameter("keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("keystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("shpcertificate");
                keystoreValue = parameters.getParameter("keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("keystore", mgr.getString());
            }
        }
        if ((authorityType = variableContext.getParameter("authorityType")) != null) {
            parameters.setParameter("authorityType", authorityType);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        SharePointRepository.fillInServerTab(velocityContext, out, parameters);
        SharePointRepository.fillInAuthorityTypeTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html", velocityContext);
    }

    protected static void fillInAuthorityTypeTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String authorityType = parameters.getParameter("authorityType");
        if (authorityType == null) {
            authorityType = "ActiveDirectory";
        }
        velocityContext.put("AUTHORITYTYPE", authorityType);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String proxyPassword;
        String proxyUser;
        String proxyPort;
        String[] contents;
        String password;
        String userName;
        String serverLocation;
        String serverPort;
        String serverName;
        String serverProtocol;
        String serverVersion = parameters.getParameter("serverVersion");
        if (serverVersion == null) {
            serverVersion = "4.0";
        }
        if ((serverProtocol = parameters.getParameter("serverProtocol")) == null) {
            serverProtocol = "http";
        }
        if ((serverName = parameters.getParameter("serverName")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("serverPort")) == null) {
            serverPort = "";
        }
        if ((serverLocation = parameters.getParameter("serverLocation")) == null) {
            serverLocation = "";
        }
        if ((userName = parameters.getParameter("userName")) == null) {
            userName = "";
        }
        password = (password = parameters.getObfuscatedParameter("password")) == null ? "" : out.mapPasswordToKey(password);
        String keystore = parameters.getParameter("keystore");
        IKeystoreManager localKeystore = keystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)keystore);
        ArrayList certificates = new ArrayList();
        for (String alias : contents = localKeystore.getContents()) {
            String description = localKeystore.getDescription(alias);
            if (description.length() > 128) {
                description = description.substring(0, 125) + "...";
            }
            HashMap<String, String> certificate = new HashMap<String, String>();
            certificate.put("ALIAS", alias);
            certificate.put("DESCRIPTION", description);
            certificates.add(certificate);
        }
        String proxyHost = parameters.getParameter("proxyHost");
        if (proxyHost == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter("proxyPort")) == null) {
            proxyPort = "";
        }
        if ((proxyUser = parameters.getParameter("proxyUser")) == null) {
            proxyUser = "";
        }
        proxyPassword = (proxyPassword = parameters.getParameter("proxyPassword")) == null ? "" : out.mapPasswordToKey(proxyPassword);
        String proxyDomain = parameters.getParameter("proxyDomain");
        if (proxyDomain == null) {
            proxyDomain = "";
        }
        velocityContext.put("SERVERVERSION", serverVersion);
        velocityContext.put("SERVERPROTOCOL", serverProtocol);
        velocityContext.put("SERVERNAME", serverName);
        velocityContext.put("SERVERPORT", serverPort);
        velocityContext.put("SERVERLOCATION", serverLocation);
        velocityContext.put("SERVERUSERNAME", userName);
        velocityContext.put("SERVERPASSWORD", password);
        if (keystore != null) {
            velocityContext.put("KEYSTORE", keystore);
        }
        velocityContext.put("CERTIFICATELIST", certificates);
        velocityContext.put("PROXYHOST", proxyHost);
        velocityContext.put("PROXYPORT", proxyPort);
        velocityContext.put("PROXYUSER", proxyUser);
        velocityContext.put("PROXYPASSWORD", proxyPassword);
        velocityContext.put("PROXYDOMAIN", proxyDomain);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharePointRepository.Paths"));
        tabsArray.add(Messages.getString(locale, "SharePointRepository.Security"));
        tabsArray.add(Messages.getString(locale, "SharePointRepository.Metadata"));
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("SeqNum", Integer.toString(connectionSequenceNumber));
        Messages.outputResourceWithVelocity(out, locale, "editSpecification.js", velocityContext);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        velocityContext.put("SeqNum", Integer.toString(connectionSequenceNumber));
        velocityContext.put("SelectedNum", Integer.toString(actualSequenceNumber));
        SharePointRepository.fillInSecurityTab(velocityContext, out, ds);
        SharePointRepository.fillInPathsTab(velocityContext, out, ds);
        SharePointRepository.fillInMetadataTab(velocityContext, out, ds);
        if (tabName.equals(Messages.getString(locale, "SharePointRepository.Paths"))) {
            this.fillInTransientPathsInfo(velocityContext, connectionSequenceNumber);
        } else if (tabName.equals(Messages.getString(locale, "SharePointRepository.Metadata"))) {
            this.fillInTransientMetadataInfo(velocityContext, connectionSequenceNumber);
        }
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Security.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Paths.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Metadata.html", velocityContext);
    }

    protected static void fillInMetadataTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String pathNameAttribute = "";
        MatchMap matchMap = new MatchMap();
        ArrayList metadataRules = new ArrayList();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("pathnameattribute")) {
                pathNameAttribute = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("pathmap")) {
                String pathMatch = sn.getAttributeValue("match");
                String pathReplace = sn.getAttributeValue("replace");
                matchMap.appendMatchPair(pathMatch, pathReplace);
                continue;
            }
            if (sn.getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                String lib = sn.getAttributeValue("lib");
                String path = site + "/" + lib + "/*";
                String allmetadata = sn.getAttributeValue("allmetadata");
                StringBuilder metadataFieldList = new StringBuilder();
                ArrayList<String> metadataFieldArray = new ArrayList<String>();
                if (allmetadata == null || !allmetadata.equals("true")) {
                    for (int j = 0; j < sn.getChildCount(); ++j) {
                        SpecificationNode node = sn.getChild(j);
                        if (!node.getType().equals("metafield")) continue;
                        if (metadataFieldList.length() > 0) {
                            metadataFieldList.append(", ");
                        }
                        String val = node.getAttributeValue("value");
                        metadataFieldList.append(val);
                        metadataFieldArray.add(val);
                    }
                    allmetadata = "false";
                }
                if (!allmetadata.equals("true") && metadataFieldList.length() <= 0) continue;
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("THEPATH", path);
                item.put("THEACTION", "include");
                item.put("ALLFLAG", allmetadata);
                item.put("FIELDLIST", metadataFieldArray);
                item.put("FIELDS", metadataFieldList.toString());
                metadataRules.add(item);
                continue;
            }
            if (!sn.getType().equals("metadatarule")) continue;
            String path = sn.getAttributeValue("match");
            String action = sn.getAttributeValue("action");
            String allmetadata = sn.getAttributeValue("allmetadata");
            StringBuilder metadataFieldList = new StringBuilder();
            ArrayList<String> metadataFieldArray = new ArrayList<String>();
            if (action.equals("include")) {
                if (allmetadata == null || !allmetadata.equals("true")) {
                    for (int j = 0; j < sn.getChildCount(); ++j) {
                        SpecificationNode node = sn.getChild(j);
                        if (!node.getType().equals("metafield")) continue;
                        String val = node.getAttributeValue("value");
                        if (metadataFieldList.length() > 0) {
                            metadataFieldList.append(", ");
                        }
                        metadataFieldList.append(val);
                        metadataFieldArray.add(val);
                    }
                    allmetadata = "false";
                }
            } else {
                allmetadata = "";
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("THEPATH", path);
            item.put("THEACTION", action);
            item.put("ALLFLAG", allmetadata);
            item.put("FIELDLIST", metadataFieldArray);
            item.put("FIELDS", metadataFieldList.toString());
            metadataRules.add(item);
        }
        ArrayList mapList = new ArrayList();
        for (int i = 0; i < matchMap.getMatchCount(); ++i) {
            String matchString = matchMap.getMatchString(i);
            String replaceString = matchMap.getReplaceString(i);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("MATCH", matchString);
            item.put("REPLACE", replaceString);
            mapList.add(item);
        }
        velocityContext.put("PATHNAMEATTRIBUTE", pathNameAttribute);
        velocityContext.put("MAPLIST", mapList);
        velocityContext.put("METADATARULES", metadataRules);
    }

    protected void fillInTransientMetadataInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String metaPathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "metapath"));
        String metaPathState = (String)this.currentContext.get((Object)(seqPrefix + "metapathstate"));
        String metaPathLibrary = (String)this.currentContext.get((Object)(seqPrefix + "metapathlibrary"));
        if (metaPathState == null) {
            metaPathState = "unknown";
        }
        if (metaPathSoFar == null) {
            metaPathSoFar = "/";
            metaPathState = "site";
        }
        String message = null;
        ArrayList<NameValue> fieldList = null;
        if (metaPathLibrary != null) {
            int index = metaPathLibrary.lastIndexOf("/");
            String site = metaPathLibrary.substring(0, index);
            String libOrList = metaPathLibrary.substring(index + 1);
            Map<String, String> metaFieldList = null;
            try {
                if (metaPathState.equals("library") || metaPathState.equals("file")) {
                    metaFieldList = this.getLibFieldList(site, libOrList);
                } else if (metaPathState.equals("list")) {
                    metaFieldList = this.getListFieldList(site, libOrList);
                }
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                message = e.getMessage();
            }
            catch (ServiceInterruption e) {
                message = "SharePoint unavailable: " + e.getMessage();
            }
            if (metaFieldList != null) {
                Object[] fields = new String[metaFieldList.size()];
                int j = 0;
                Iterator<String> iter = metaFieldList.keySet().iterator();
                while (iter.hasNext()) {
                    fields[j++] = iter.next();
                }
                Arrays.sort(fields);
                fieldList = new ArrayList<NameValue>();
                for (Object field : fields) {
                    fieldList.add(new NameValue((String)field, metaFieldList.get(field)));
                }
            }
        }
        List<NameValue> childSiteList = null;
        List<NameValue> childLibList = null;
        List<NameValue> childListList = null;
        if (message == null && metaPathState.equals("site")) {
            try {
                String queryPath = metaPathSoFar;
                if (queryPath.equals("/")) {
                    queryPath = "";
                }
                if ((childSiteList = this.getSites(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    metaPathState = "unknown";
                    metaPathLibrary = null;
                }
                if ((childLibList = this.getDocLibsBySite(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    metaPathState = "unknown";
                    metaPathLibrary = null;
                }
                if ((childListList = this.getListsBySite(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    metaPathState = "unknown";
                    metaPathLibrary = null;
                }
            }
            catch (ManifoldCFException e) {
                Logging.connectors.warn((Object)e.getMessage(), (Throwable)e);
                message = e.getMessage();
            }
            catch (ServiceInterruption e) {
                message = "SharePoint unavailable: " + e.getMessage();
            }
        }
        if (metaPathSoFar != null) {
            velocityContext.put("METAPATHSOFAR", metaPathSoFar);
        }
        if (metaPathState != null) {
            velocityContext.put("METAPATHSTATE", metaPathState);
        }
        if (metaPathLibrary != null) {
            velocityContext.put("METAPATHLIBRARY", metaPathLibrary);
        }
        if (message != null) {
            velocityContext.put("METAMESSAGE", message);
        }
        if (fieldList != null) {
            velocityContext.put("METAFIELDLIST", fieldList);
        }
        if (childSiteList != null) {
            velocityContext.put("METACHILDSITELIST", childSiteList);
        }
        if (childLibList != null) {
            velocityContext.put("METACHILDLIBLIST", childLibList);
        }
        if (childListList != null) {
            velocityContext.put("METACHILDLISTLIST", childListList);
        }
    }

    protected static void fillInPathsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        ArrayList rules = new ArrayList();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                String lib = sn.getAttributeValue("lib");
                String siteLib = site + "/" + lib + "/";
                for (int j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode node = sn.getChild(j);
                    if (!node.getType().equals("include") && !node.getType().equals("exclude")) continue;
                    String matchPart = node.getAttributeValue("match");
                    String ruleType = node.getAttributeValue("type");
                    String theFlavor = node.getType();
                    String thePath = siteLib + matchPart;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("THEPATH", thePath);
                    item.put("THETYPE", "file");
                    item.put("THEACTION", theFlavor);
                    rules.add(item);
                    if (!ruleType.equals("file") || matchPart.startsWith("*")) continue;
                    thePath = siteLib + "*/" + matchPart;
                    item = new HashMap();
                    item.put("THEPATH", thePath);
                    item.put("THETYPE", "file");
                    item.put("THEACTION", theFlavor);
                    rules.add(item);
                }
                continue;
            }
            if (!sn.getType().equals("pathrule")) continue;
            String match = sn.getAttributeValue("match");
            String type = sn.getAttributeValue("type");
            String action = sn.getAttributeValue("action");
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("THEPATH", match);
            item.put("THETYPE", type);
            item.put("THEACTION", action);
            rules.add(item);
        }
        velocityContext.put("RULES", rules);
    }

    protected void fillInTransientPathsInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
        String pathState = (String)this.currentContext.get((Object)(seqPrefix + "specpathstate"));
        String pathLibrary = (String)this.currentContext.get((Object)(seqPrefix + "specpathlibrary"));
        if (pathState == null) {
            pathState = "unknown";
            pathLibrary = null;
        }
        if (pathSoFar == null) {
            pathSoFar = "/";
            pathState = "site";
            pathLibrary = null;
        }
        List<NameValue> childSiteList = null;
        List<NameValue> childLibList = null;
        List<NameValue> childListList = null;
        String message = null;
        if (pathState.equals("site")) {
            try {
                String queryPath = pathSoFar;
                if (queryPath.equals("/")) {
                    queryPath = "";
                }
                if ((childSiteList = this.getSites(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    pathState = "unknown";
                    pathLibrary = null;
                }
                if ((childLibList = this.getDocLibsBySite(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    pathState = "unknown";
                    pathLibrary = null;
                }
                if ((childListList = this.getListsBySite(queryPath)) == null) {
                    if (queryPath.length() == 0) {
                        throw new ManifoldCFException("Root site is unreachable, or user has no permissions");
                    }
                    pathState = "unknown";
                    pathLibrary = null;
                }
            }
            catch (ManifoldCFException e) {
                Logging.connectors.warn((Object)e.getMessage(), (Throwable)e);
                message = e.getMessage();
            }
            catch (ServiceInterruption e) {
                message = "SharePoint unavailable: " + e.getMessage();
            }
        }
        if (pathSoFar != null) {
            velocityContext.put("PATHSOFAR", pathSoFar);
        }
        if (pathState != null) {
            velocityContext.put("PATHSTATE", pathState);
        }
        if (pathLibrary != null) {
            velocityContext.put("PATHLIBRARY", pathLibrary);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
        if (childSiteList != null) {
            velocityContext.put("CHILDSITELIST", childSiteList);
        }
        if (childLibList != null) {
            velocityContext.put("CHILDLIBLIST", childLibList);
        }
        if (childListList != null) {
            velocityContext.put("CHILDLISTLIST", childListList);
        }
    }

    protected static void fillInSecurityTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String security = "on";
        ArrayList<String> accessTokens = new ArrayList<String>();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("security")) {
                security = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            accessTokens.add(token);
        }
        velocityContext.put("SECURITY", security);
        velocityContext.put("ACCESSTOKENS", accessTokens);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode sn;
        int i;
        String xc;
        String addon;
        String pathop;
        String action;
        String match;
        String op;
        SpecificationNode node;
        String path;
        String pathOpName;
        String pathDescription;
        int pathCount;
        String x;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (variableContext.getParameter(seqPrefix + "specpathcount") != null && variableContext.getParameter(seqPrefix + "metapathcount") != null) {
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i2);
                if (sn2.getType().equals("startpoint")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specpathcount")) != null) {
            String type;
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(i3);
                if (sn3.getType().equals("pathrule")) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            pathCount = Integer.parseInt(x);
            i3 = 0;
            while (i3 < pathCount) {
                pathDescription = "_" + Integer.toString(i3);
                pathOpName = seqPrefix + "specop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i3;
                    continue;
                }
                path = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                type = variableContext.getParameter(seqPrefix + "spectype" + pathDescription);
                String action2 = variableContext.getParameter(seqPrefix + "specflav" + pathDescription);
                node = new SpecificationNode("pathrule");
                node.setAttribute("match", path);
                node.setAttribute("action", action2);
                node.setAttribute("type", type);
                if (x != null && x.equals("Insert Here")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    type = variableContext.getParameter(seqPrefix + "spectype");
                    action2 = variableContext.getParameter(seqPrefix + "specflavor");
                    SpecificationNode sn4 = new SpecificationNode("pathrule");
                    sn4.setAttribute("match", path);
                    sn4.setAttribute("action", action2);
                    sn4.setAttribute("type", type);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)sn4);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i3;
            }
            op = variableContext.getParameter(seqPrefix + "specop");
            if (op != null && op.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "specpath");
                action = variableContext.getParameter(seqPrefix + "specflavor");
                type = variableContext.getParameter(seqPrefix + "spectype");
                SpecificationNode node2 = new SpecificationNode("pathrule");
                node2.setAttribute("match", match);
                node2.setAttribute("action", action);
                node2.setAttribute("type", type);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
            }
            if ((pathop = variableContext.getParameter(seqPrefix + "specpathop")) != null) {
                String addon2;
                if (pathop.equals("Reset")) {
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)"/");
                    this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)"site");
                    this.currentContext.save((Object)(seqPrefix + "specpathlibrary"), null);
                } else if (pathop.equals("AppendSite")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    addon2 = variableContext.getParameter(seqPrefix + "specsite");
                    if (addon2 != null && addon2.length() > 0) {
                        path = path.equals("/") ? path + addon2 : path + "/" + addon2;
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
                    this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)"site");
                    this.currentContext.save((Object)(seqPrefix + "specpathlibrary"), null);
                } else if (pathop.equals("AppendLibrary")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    addon2 = variableContext.getParameter(seqPrefix + "speclibrary");
                    if (addon2 != null && addon2.length() > 0) {
                        path = path.equals("/") ? path + addon2 : path + "/" + addon2;
                        this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)"library");
                        this.currentContext.save((Object)(seqPrefix + "specpathlibrary"), (Object)path);
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
                } else if (pathop.equals("AppendList")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    addon2 = variableContext.getParameter(seqPrefix + "speclist");
                    if (addon2 != null && addon2.length() > 0) {
                        path = path.equals("/") ? path + addon2 : path + "/" + addon2;
                        this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)"list");
                        this.currentContext.save((Object)(seqPrefix + "specpathlibrary"), (Object)path);
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
                } else if (pathop.equals("AppendText")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    String library = variableContext.getParameter(seqPrefix + "specpathlibrary");
                    addon = variableContext.getParameter(seqPrefix + "specmatch");
                    if (addon != null && addon.length() > 0) {
                        path = path.equals("/") ? path + addon : path + "/" + addon;
                        this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)"unknown");
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
                    this.currentContext.save((Object)(seqPrefix + "specpathlibrary"), (Object)library);
                } else if (pathop.equals("Remove")) {
                    path = variableContext.getParameter(seqPrefix + "specpath");
                    int index = path.lastIndexOf("/");
                    if ((path = path.substring(0, index)).length() == 0) {
                        path = "/";
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
                    String pathState = variableContext.getParameter(seqPrefix + "specpathstate");
                    if (pathState.equals("library") || pathState.equals("list")) {
                        pathState = "site";
                    }
                    this.currentContext.save((Object)(seqPrefix + "specpathstate"), (Object)pathState);
                }
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "metapathcount")) != null) {
            String[] metadataFields;
            String allmetadata;
            int i4 = 0;
            while (i4 < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i4);
                if (sn5.getType().equals("metadatarule")) {
                    ds.removeChild(i4);
                    continue;
                }
                ++i4;
            }
            pathCount = Integer.parseInt(x);
            i4 = 0;
            while (i4 < pathCount) {
                pathDescription = "_" + Integer.toString(i4);
                pathOpName = seqPrefix + "metaop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i4;
                    continue;
                }
                path = variableContext.getParameter(seqPrefix + "metapath" + pathDescription);
                String action3 = variableContext.getParameter(seqPrefix + "metaflav" + pathDescription);
                allmetadata = variableContext.getParameter(seqPrefix + "metaall" + pathDescription);
                metadataFields = variableContext.getParameterValues(seqPrefix + "metafields" + pathDescription);
                SpecificationNode node3 = new SpecificationNode("metadatarule");
                node3.setAttribute("match", path);
                node3.setAttribute("action", action3);
                if (action3.equals("include")) {
                    if (allmetadata != null) {
                        node3.setAttribute("allmetadata", allmetadata);
                    }
                    if (metadataFields != null) {
                        int j = 0;
                        while (j < metadataFields.length) {
                            SpecificationNode sn6 = new SpecificationNode("metafield");
                            sn6.setAttribute("value", metadataFields[j]);
                            node3.addChild(j++, (ConfigurationNode)sn6);
                        }
                    }
                }
                if (x != null && x.equals("Insert Here")) {
                    path = variableContext.getParameter(seqPrefix + "metapath");
                    action3 = variableContext.getParameter(seqPrefix + "metaflavor");
                    allmetadata = variableContext.getParameter(seqPrefix + "metaall");
                    metadataFields = variableContext.getParameterValues(seqPrefix + "metafields");
                    SpecificationNode sn7 = new SpecificationNode("metadatarule");
                    sn7.setAttribute("match", path);
                    sn7.setAttribute("action", action3);
                    if (action3.equals("include")) {
                        if (allmetadata != null) {
                            node3.setAttribute("allmetadata", allmetadata);
                        }
                        if (metadataFields != null) {
                            int j = 0;
                            while (j < metadataFields.length) {
                                SpecificationNode node2 = new SpecificationNode("metafield");
                                node2.setAttribute("value", metadataFields[j]);
                                sn7.addChild(j++, (ConfigurationNode)node2);
                            }
                        }
                    }
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)sn7);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
                ++i4;
            }
            op = variableContext.getParameter(seqPrefix + "metaop");
            if (op != null && op.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "metapath");
                action = variableContext.getParameter(seqPrefix + "metaflavor");
                SpecificationNode node4 = new SpecificationNode("metadatarule");
                node4.setAttribute("match", match);
                node4.setAttribute("action", action);
                if (action.equals("include")) {
                    allmetadata = variableContext.getParameter(seqPrefix + "metaall");
                    metadataFields = variableContext.getParameterValues(seqPrefix + "metafields");
                    if (allmetadata != null) {
                        node4.setAttribute("allmetadata", allmetadata);
                    }
                    if (metadataFields != null) {
                        int j = 0;
                        while (j < metadataFields.length) {
                            SpecificationNode sn8 = new SpecificationNode("metafield");
                            sn8.setAttribute("value", metadataFields[j]);
                            node4.addChild(j++, (ConfigurationNode)sn8);
                        }
                    }
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
            }
            if ((pathop = variableContext.getParameter(seqPrefix + "metapathop")) != null) {
                if (pathop.equals("Reset")) {
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)"/");
                    this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"site");
                    this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), null);
                } else if (pathop.equals("AppendSite")) {
                    path = variableContext.getParameter(seqPrefix + "metapath");
                    String addon3 = variableContext.getParameter(seqPrefix + "metasite");
                    if (addon3 != null && addon3.length() > 0) {
                        path = path.equals("/") ? path + addon3 : path + "/" + addon3;
                    }
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)path);
                    this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"site");
                    this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), null);
                } else if (pathop.equals("AppendLibrary")) {
                    path = variableContext.getParameter(seqPrefix + "metapath");
                    String addon4 = variableContext.getParameter(seqPrefix + "metalibrary");
                    if (addon4 != null && addon4.length() > 0) {
                        path = path.equals("/") ? path + addon4 : path + "/" + addon4;
                        this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"library");
                        this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), (Object)path);
                    }
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)path);
                } else if (pathop.equals("AppendList")) {
                    path = variableContext.getParameter(seqPrefix + "metapath");
                    String addon5 = variableContext.getParameter(seqPrefix + "metalist");
                    if (addon5 != null && addon5.length() > 0) {
                        path = path.equals("/") ? path + addon5 : path + "/" + addon5;
                        this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"list");
                        this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), (Object)path);
                        path = path + "/*";
                    }
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)path);
                } else if (pathop.equals("AppendText")) {
                    path = variableContext.getParameter(seqPrefix + "metapath");
                    String library = variableContext.getParameter(seqPrefix + "metapathlibrary");
                    addon = variableContext.getParameter(seqPrefix + "metamatch");
                    if (addon != null && addon.length() > 0) {
                        path = path.equals("/") ? path + addon : path + "/" + addon;
                        if (library != null) {
                            this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"file");
                        } else {
                            this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)"unknown");
                        }
                    }
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)path);
                    this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), (Object)library);
                } else if (pathop.equals("Remove")) {
                    String path2;
                    String pathState = variableContext.getParameter(seqPrefix + "metapathstate");
                    if (pathState.equals("file")) {
                        pathState = "library";
                        path2 = variableContext.getParameter(seqPrefix + "metapathlibrary");
                    } else if (pathState.equals("list") || pathState.equals("library")) {
                        pathState = "site";
                        path2 = variableContext.getParameter(seqPrefix + "metapathlibrary");
                        int index = path2.lastIndexOf("/");
                        if ((path2 = path2.substring(0, index)).length() == 0) {
                            path2 = "/";
                        }
                        this.currentContext.save((Object)(seqPrefix + "metapathlibrary"), null);
                    } else {
                        path2 = variableContext.getParameter(seqPrefix + "metapath");
                        int index = path2.lastIndexOf("/");
                        if ((path2 = path2.substring(0, index)).length() == 0) {
                            path2 = "/";
                        }
                    }
                    this.currentContext.save((Object)(seqPrefix + "metapathstate"), (Object)pathState);
                    this.currentContext.save((Object)(seqPrefix + "metapath"), (Object)path2);
                }
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node5 = new SpecificationNode("security");
            node5.setAttribute("value", xc);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node6 = new SpecificationNode("access");
                node6.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
                ++i;
            }
            String op2 = variableContext.getParameter(seqPrefix + "accessop");
            if (op2 != null && op2.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node7 = new SpecificationNode("access");
                node7.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node7);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn9 = ds.getChild(i);
                if (sn9.getType().equals("pathnameattribute")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (xc.length() > 0) {
                SpecificationNode node8 = new SpecificationNode("pathnameattribute");
                node8.setAttribute("value", xc);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node8);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specmappingcount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn10 = ds.getChild(i);
                if (sn10.getType().equals("pathmap")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int mappingCount = Integer.parseInt(xc);
            i = 0;
            while (i < mappingCount) {
                String pathDescription2 = "_" + Integer.toString(i);
                String pathOpName2 = seqPrefix + "specmappingop" + pathDescription2;
                xc = variableContext.getParameter(pathOpName2);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String match2 = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription2);
                String replace = variableContext.getParameter(seqPrefix + "specreplace" + pathDescription2);
                node = new SpecificationNode("pathmap");
                node.setAttribute("match", match2);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            xc = variableContext.getParameter(seqPrefix + "specmappingop");
            if (xc != null && xc.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "specmatch");
                String replace = variableContext.getParameter(seqPrefix + "specreplace");
                SpecificationNode node9 = new SpecificationNode("pathmap");
                node9.setAttribute("match", match);
                node9.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node9);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("SeqNum", Integer.toString(connectionSequenceNumber));
        SharePointRepository.fillInSecurityTab(velocityContext, out, ds);
        SharePointRepository.fillInPathsTab(velocityContext, out, ds);
        SharePointRepository.fillInMetadataTab(velocityContext, out, ds);
        Messages.outputResourceWithVelocity(out, locale, "viewSpecification.html", velocityContext);
    }

    public Map<String, String> getLibFieldList(String parentSite, String docLibrary) throws ServiceInterruption, ManifoldCFException {
        this.getSession();
        return this.proxy.getFieldList(SharePointRepository.encodePath(parentSite), this.proxy.getDocLibID(SharePointRepository.encodePath(parentSite), parentSite, docLibrary));
    }

    public Map<String, String> getListFieldList(String parentSite, String listName) throws ServiceInterruption, ManifoldCFException {
        this.getSession();
        return this.proxy.getFieldList(SharePointRepository.encodePath(parentSite), this.proxy.getListID(SharePointRepository.encodePath(parentSite), parentSite, listName));
    }

    public List<NameValue> getSites(String parentSite) throws ServiceInterruption, ManifoldCFException {
        this.getSession();
        return this.proxy.getSites(SharePointRepository.encodePath(parentSite));
    }

    public List<NameValue> getDocLibsBySite(String parentSite) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.proxy.getDocumentLibraries(SharePointRepository.encodePath(parentSite), parentSite);
    }

    public List<NameValue> getListsBySite(String parentSite) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.proxy.getLists(SharePointRepository.encodePath(parentSite), parentSite);
    }

    protected boolean checkIncludeLibrary(String libraryPath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include library '" + libraryPath + "'"));
        }
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            SpecificationNode sn;
            if ((sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                String lib = sn.getAttributeValue("lib");
                String pathStart = site + "/" + lib;
                if (!libraryPath.equals(pathStart)) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Library path '" + libraryPath + "' matched old-style startpoint with site '" + site + "' and library '" + lib + "' - including"));
                }
                return true;
            }
            if (!sn.getType().equals("pathrule")) continue;
            String pathMatch = sn.getAttributeValue("match");
            String action = sn.getAttributeValue("action");
            String ruleType = sn.getAttributeValue("type");
            if (SharePointRepository.checkMatch(libraryPath, 0, pathMatch)) {
                if (!ruleType.equals("library")) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Library '" + libraryPath + "' exactly matched rule path '" + pathMatch + "'"));
                }
                if (action.equals("include")) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Including library '" + libraryPath + "'"));
                    }
                    return true;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Excluding library '" + libraryPath + "'"));
                }
                return false;
            }
            if (ruleType.equals("file") && SharePointRepository.checkPartialPathMatch(libraryPath, 0, pathMatch, 1) && action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Library '" + libraryPath + "' partially matched file rule path '" + pathMatch + "' - including"));
                }
                return true;
            }
            if (!ruleType.equals("folder") || !SharePointRepository.checkPartialPathMatch(libraryPath, 0, pathMatch, 1) || !action.equals("include")) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Library '" + libraryPath + "' partially matched folder rule path '" + pathMatch + "' - including"));
            }
            return true;
        }
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Not including library '" + libraryPath + "' because no matching rule"));
        }
        return false;
    }

    protected boolean checkIncludeList(String listPath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include list '" + listPath + "'"));
        }
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = documentSpecification.getChild(i++)).getType().equals("pathrule")) continue;
            String pathMatch = sn.getAttributeValue("match");
            String action = sn.getAttributeValue("action");
            String ruleType = sn.getAttributeValue("type");
            if (!SharePointRepository.checkMatch(listPath, 0, pathMatch) || !ruleType.equals("list")) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: List '" + listPath + "' exactly matched rule path '" + pathMatch + "'"));
            }
            if (action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Including list '" + listPath + "'"));
                }
                return true;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Excluding list '" + listPath + "'"));
            }
            return false;
        }
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Not including list '" + listPath + "' because no matching rule"));
        }
        return false;
    }

    protected boolean checkIncludeSite(String sitePath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include site '" + sitePath + "'"));
        }
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            SpecificationNode sn;
            if ((sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                if (!site.startsWith("/")) {
                    site = "/" + site;
                }
                if (!site.startsWith(sitePath) || sitePath.length() != 1 && site.length() != sitePath.length() && site.charAt(sitePath.length()) != '/') continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site path '" + sitePath + "' matched old-style startpoint with site '" + site + "' - including"));
                }
                return true;
            }
            if (!sn.getType().equals("pathrule")) continue;
            String pathMatch = sn.getAttributeValue("match");
            String action = sn.getAttributeValue("action");
            String ruleType = sn.getAttributeValue("type");
            if (SharePointRepository.checkMatch(sitePath, 0, pathMatch)) {
                if (!ruleType.equals("site")) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' exactly matched rule path '" + pathMatch + "'"));
                }
                if (action.equals("include")) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: Including site '" + sitePath + "'"));
                    }
                    return true;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Excluding site '" + sitePath + "'"));
                }
                return false;
            }
            if (ruleType.equals("library") && SharePointRepository.checkPartialPathMatch(sitePath, 0, pathMatch, 1) && action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' partially matched library rule path '" + pathMatch + "' - including"));
                }
                return true;
            }
            if (ruleType.equals("list") && SharePointRepository.checkPartialPathMatch(sitePath, 0, pathMatch, 1) && action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' partially matched list rule path '" + pathMatch + "' - including"));
                }
                return true;
            }
            if (ruleType.equals("site") && SharePointRepository.checkPartialPathMatch(sitePath, 0, pathMatch, 0) && action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' partially matched site rule path '" + pathMatch + "' - including"));
                }
                return true;
            }
            if (ruleType.equals("file") && SharePointRepository.checkPartialPathMatch(sitePath, 0, pathMatch, 2) && action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' partially matched file rule path '" + pathMatch + "' - including"));
                }
                return true;
            }
            if (!ruleType.equals("folder") || !SharePointRepository.checkPartialPathMatch(sitePath, 0, pathMatch, 2) || !action.equals("include")) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Site '" + sitePath + "' partially matched folder rule path '" + pathMatch + "' - including"));
            }
            return true;
        }
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Not including site '" + sitePath + "' because no matching rule"));
        }
        return false;
    }

    protected MetadataInformation getMetadataSpecification(String filePath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Finding metadata to include for document/item '" + filePath + "'."));
        }
        MetadataInformation rval = new MetadataInformation();
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            String pathMatch;
            SpecificationNode sn;
            if ((sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                String lib = sn.getAttributeValue("lib");
                String pathStart = site + "/" + lib + "/";
                if (!filePath.startsWith(pathStart)) continue;
                String allmetadata = sn.getAttributeValue("allmetadata");
                if (allmetadata != null && allmetadata.equals("true")) {
                    rval.setAllMetadata();
                } else {
                    int j = 0;
                    while (j < sn.getChildCount()) {
                        SpecificationNode node;
                        if (!(node = sn.getChild(j++)).getType().equals("metafield")) continue;
                        rval.addMetadataField(node.getAttributeValue("value"));
                    }
                }
                return rval;
            }
            if (!sn.getType().equals("metadatarule") || !SharePointRepository.checkMatch(filePath, 0, pathMatch = sn.getAttributeValue("match"))) continue;
            String action = sn.getAttributeValue("action");
            if (action.equals("include")) {
                String allMetadata = sn.getAttributeValue("allmetadata");
                if (allMetadata != null && allMetadata.equals("true")) {
                    rval.setAllMetadata();
                } else {
                    int j = 0;
                    while (j < sn.getChildCount()) {
                        SpecificationNode node;
                        if (!(node = sn.getChild(j++)).getType().equals("metafield")) continue;
                        rval.addMetadataField(node.getAttributeValue("value"));
                    }
                }
            }
            return rval;
        }
        return rval;
    }

    protected boolean checkIncludeFile(String filePath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include document '" + filePath + "'"));
        }
        int lastSlash = filePath.lastIndexOf("/");
        String pathPart = filePath.substring(0, lastSlash);
        String filePart = filePath.substring(lastSlash + 1);
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            SpecificationNode sn;
            if ((sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) {
                String site = sn.getAttributeValue("site");
                String lib = sn.getAttributeValue("lib");
                String pathMatch = site + "/" + lib + "/";
                if (!filePath.startsWith(pathMatch)) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: File path '" + filePath + "' matched old-style startpoint with site '" + site + "' and library '" + lib + "'"));
                }
                int restOfPathIndex = pathMatch.length();
                int j = 0;
                while (j < sn.getChildCount()) {
                    int sourceIndex;
                    String sourceMatch;
                    SpecificationNode node;
                    String flavor;
                    if (!(flavor = (node = sn.getChild(j++)).getType()).equals("include") && !flavor.equals("exclude")) continue;
                    String match = node.getAttributeValue("match");
                    String type = node.getAttributeValue("type");
                    if (type.equals("file")) {
                        sourceMatch = filePart;
                        sourceIndex = 0;
                    } else {
                        sourceMatch = pathPart;
                        sourceIndex = restOfPathIndex;
                    }
                    if (!SharePointRepository.checkMatch(sourceMatch, sourceIndex, match)) continue;
                    if (flavor.equals("include")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: File path '" + filePath + "' matched old-style inclusion rule '" + match + "' - including"));
                        }
                        return true;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: File path '" + filePath + "' matched old-style exclusion rule '" + match + "' - excluding"));
                    }
                    return false;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: File path '" + filePath + "' did not match any old-style inclusion/exclusion rules - excluding"));
                }
                return false;
            }
            if (!sn.getType().equals("pathrule")) continue;
            String pathMatch = sn.getAttributeValue("match");
            String action = sn.getAttributeValue("action");
            String ruleType = sn.getAttributeValue("type");
            if (!SharePointRepository.checkMatch(filePath, 0, pathMatch) || !ruleType.equals("file")) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: File '" + filePath + "' exactly matched rule path '" + pathMatch + "'"));
            }
            if (action.equals("include")) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Including file '" + filePath + "'"));
                }
                return true;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Excluding file '" + filePath + "'"));
            }
            return false;
        }
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: File path '" + filePath + "' does not match any rules - excluding"));
        }
        return false;
    }

    protected boolean checkIncludeListItemAttachment(String attachmentPath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include list item attachment '" + attachmentPath + "'"));
        }
        return true;
    }

    protected boolean checkIncludeListItem(String itemPath, Specification documentSpecification) {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: Checking whether to include list item '" + itemPath + "'"));
        }
        return true;
    }

    protected static int matchSubPath(String subPath, String fullPath) {
        if (subPath.length() > fullPath.length()) {
            return -1;
        }
        if (!fullPath.startsWith(subPath)) {
            return -1;
        }
        int rval = subPath.length();
        if (fullPath.length() == rval) {
            return rval;
        }
        char x = fullPath.charAt(rval);
        if (x == '/') {
            ++rval;
        }
        return rval;
    }

    protected static boolean checkPartialPathMatch(String sourceMatch, int sourceIndex, String match, int requiredExtraPathSections) {
        boolean caseSensitive = true;
        if (!sourceMatch.endsWith("/")) {
            sourceMatch = sourceMatch + "/";
        }
        return SharePointRepository.processPartialPathCheck(caseSensitive, sourceMatch, sourceIndex, match, 0, requiredExtraPathSections);
    }

    protected static boolean processPartialPathCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex, int requiredExtraPathSections) {
        while (true) {
            if (sourceMatch.length() == sourceIndex) {
                if (match.length() == matchIndex) {
                    return requiredExtraPathSections == 0;
                }
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return SharePointRepository.processPartialPathCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex, requiredExtraPathSections) || SharePointRepository.processPartialPathCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1, requiredExtraPathSections);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = true;
        return SharePointRepository.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return SharePointRepository.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || SharePointRepository.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    protected static String[] getAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        boolean securityOn = true;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals("access")) {
                String token = sn.getAttributeValue("token");
                map.put(token, token);
                continue;
            }
            if (!sn.getType().equals("security")) continue;
            String value = sn.getAttributeValue("value");
            if (value.equals("on")) {
                securityOn = true;
                continue;
            }
            if (!value.equals("off")) continue;
            securityOn = false;
        }
        if (!securityOn) {
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    public static String pathItemDecode(String pathItem) {
        return URLDecoder.decode((String)pathItem.replaceAll("\\%20", "+"));
    }

    public static String pathItemEncode(String pathItem) {
        String output = URLEncoder.encode((String)pathItem);
        return output.replaceAll("\\+", "%20");
    }

    public static String decodePath(String relPath) {
        StringBuilder sb = new StringBuilder();
        String[] pathEntries = relPath.split("/");
        int k = 0;
        boolean isFirst = true;
        while (k < pathEntries.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(SharePointRepository.pathItemDecode(pathEntries[k++]));
        }
        return sb.toString();
    }

    public static String encodePath(String relPath) {
        StringBuilder sb = new StringBuilder();
        String[] pathEntries = relPath.split("/");
        int k = 0;
        boolean isFirst = true;
        while (k < pathEntries.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(SharePointRepository.pathItemEncode(pathEntries[k++]));
        }
        return sb.toString();
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Logger logger = Logger.getLogger((String)"org.apache.axis.ConfigurationException");
        logger.setLevel(Level.INFO);
        attachmentDataNames = new String[]{"createdDate", "modifiedDate", "accessTokens", "denyTokens", "url", "guids"};
        fileStreamDataNames = new String[]{"accessTokens", "denyTokens", "guids", "fields"};
        listItemStreamDataNames = new String[]{"accessTokens", "denyTokens", "guids", "fields", "displayURLs"};
    }

    protected class SystemMetadataDescription {
        protected final String pathAttributeName;
        protected final MatchMap matchMap = new MatchMap();

        public SystemMetadataDescription(Specification spec) throws ManifoldCFException {
            String pathAttributeName = null;
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode n = spec.getChild(i);
                if (n.getType().equals("pathnameattribute")) {
                    pathAttributeName = n.getAttributeValue("value");
                    continue;
                }
                if (!n.getType().equals("pathmap")) continue;
                String pathMatch = n.getAttributeValue("match");
                String pathReplace = n.getAttributeValue("replace");
                this.matchMap.appendMatchPair(pathMatch, pathReplace);
            }
            this.pathAttributeName = pathAttributeName;
        }

        public String getPathAttributeName() {
            return this.pathAttributeName;
        }

        public String getPathAttributeValue(String documentIdentifier) throws ManifoldCFException {
            String path = this.getPathString(documentIdentifier);
            return this.matchMap.translate(path);
        }

        public String getPathString(String documentIdentifier) throws ManifoldCFException {
            int dslashIndex = documentIdentifier.indexOf("//");
            if (dslashIndex == -1) {
                return documentIdentifier;
            }
            return documentIdentifier.substring(0, dslashIndex) + documentIdentifier.substring(dslashIndex + 1);
        }
    }

    protected static class MetadataInformation {
        protected boolean allMetadata = false;
        protected Set<String> metadataFields = new HashSet<String>();

        public void setAllMetadata() {
            this.allMetadata = true;
        }

        public void addMetadataField(String fieldName) {
            this.metadataFields.add(fieldName);
        }

        public boolean getAllMetadata() {
            return this.allMetadata;
        }

        public String[] getMetadataFields() {
            String[] rval = new String[this.metadataFields.size()];
            int i = 0;
            for (String field : this.metadataFields) {
                rval[i++] = field;
            }
            return rval;
        }
    }

    protected static class ExecuteMethodThread
    extends Thread {
        protected final HttpClient httpClient;
        protected final String url;
        protected final OutputStream os;
        protected Throwable exception = null;
        protected int returnCode = 0;

        public ExecuteMethodThread(HttpClient httpClient, String url, OutputStream os) {
            this.setDaemon(true);
            this.httpClient = httpClient;
            this.url = url;
            this.os = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    HttpGet method = new HttpGet(this.url);
                    try {
                        int amt;
                        HttpEntity entity;
                        HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                        this.returnCode = response.getStatusLine().getStatusCode();
                        if (this.returnCode != 200 || (entity = response.getEntity()) == null) break block7;
                        InputStream is = entity.getContent();
                        byte[] transferBuffer = new byte[65536];
                        while ((amt = is.read(transferBuffer)) != -1) {
                            this.os.write(transferBuffer, 0, amt);
                        }
                    }
                    finally {
                        method.abort();
                    }
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }
        }

        public int finishUp() throws InterruptedException, IOException, HttpException {
            this.join();
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                if (this.exception instanceof HttpException) {
                    throw (HttpException)this.exception;
                }
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                throw new RuntimeException("Unexpected exception type thrown: " + this.exception.getClass().getName());
            }
            return this.returnCode;
        }
    }

    protected class ListItemStream
    implements IFileStream {
        protected final IProcessActivity activities;
        protected final Specification spec;
        protected final String rootPath;
        protected final String sitePath;
        protected final String siteListPath;
        protected final String documentIdentifier;
        protected final String[][] dataValues;

        public ListItemStream(IProcessActivity activities, String rootPath, String sitePath, String siteListPath, Specification spec, String documentIdentifier, String[] accessTokens, String[] denyTokens, String listID, String[] fields) {
            this.activities = activities;
            this.spec = spec;
            this.rootPath = rootPath;
            this.sitePath = sitePath;
            this.siteListPath = siteListPath;
            this.documentIdentifier = documentIdentifier;
            this.dataValues = new String[listItemStreamDataNames.length][];
            this.dataValues[0] = accessTokens;
            this.dataValues[1] = denyTokens;
            this.dataValues[2] = new String[]{listID};
            this.dataValues[3] = fields;
        }

        @Override
        public void addFile(String relPath, String displayURL) throws ManifoldCFException {
            if (!relPath.startsWith("/")) {
                relPath = this.rootPath + this.sitePath + "/" + relPath;
            }
            String fullPath = relPath;
            if (relPath.startsWith(this.rootPath)) {
                if ((relPath = relPath.substring(this.rootPath.length())).startsWith(this.sitePath)) {
                    if ((relPath = relPath.substring(this.sitePath.length())).startsWith("/Lists/")) {
                        relPath = this.sitePath + relPath.substring("/Lists".length());
                        if (SharePointRepository.this.checkIncludeListItem(relPath, this.spec)) {
                            if (relPath.startsWith(this.siteListPath)) {
                                String modifiedPath = relPath.substring(0, this.siteListPath.length()) + "//" + relPath.substring(this.siteListPath.length());
                                this.dataValues[4] = displayURL != null ? new String[]{displayURL} : new String[]{fullPath};
                                this.activities.addDocumentReference(modifiedPath, this.documentIdentifier, null, listItemStreamDataNames, (Object[][])this.dataValues);
                            } else {
                                Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; site path is '" + relPath + "', but expected to see something beginning with '" + this.siteListPath + "'"));
                            }
                        }
                    } else {
                        Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; rel path is '" + relPath + "', but expected to see something beginning with '/Lists/'"));
                    }
                } else {
                    Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; site path is '" + relPath + "', but expected to see something beginning with '" + this.sitePath + "'"));
                }
            } else {
                Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; path is '" + relPath + "', but expected to see something beginning with '" + this.rootPath + "'"));
            }
        }
    }

    protected class FileStream
    implements IFileStream {
        protected final IProcessActivity activities;
        protected final Specification spec;
        protected final String rootPath;
        protected final String sitePath;
        protected final String siteLibPath;
        protected final String documentIdentifier;
        protected final String[][] dataValues;

        public FileStream(IProcessActivity activities, String rootPath, String sitePath, String siteLibPath, Specification spec, String documentIdentifier, String[] accessTokens, String[] denyTokens, String libID, String[] fields) {
            this.activities = activities;
            this.spec = spec;
            this.rootPath = rootPath;
            this.sitePath = sitePath;
            this.siteLibPath = siteLibPath;
            this.documentIdentifier = documentIdentifier;
            this.dataValues = new String[fileStreamDataNames.length][];
            this.dataValues[0] = accessTokens;
            this.dataValues[1] = denyTokens;
            this.dataValues[2] = new String[]{libID};
            this.dataValues[3] = fields;
        }

        @Override
        public void addFile(String relPath, String displayURL) throws ManifoldCFException {
            if (!relPath.startsWith("/")) {
                relPath = this.rootPath + this.sitePath + "/" + relPath;
            }
            if (relPath.startsWith(this.rootPath)) {
                if (SharePointRepository.this.checkIncludeFile(relPath = relPath.substring(this.rootPath.length()), this.spec)) {
                    if (relPath.startsWith(this.siteLibPath)) {
                        String modifiedPath = this.siteLibPath + "/" + relPath.substring(this.siteLibPath.length());
                        this.activities.addDocumentReference(modifiedPath, this.documentIdentifier, null, fileStreamDataNames, (Object[][])this.dataValues);
                    } else {
                        Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; path is '" + relPath + "', but expected to see something beginning with '" + this.siteLibPath + "'"));
                    }
                }
            } else {
                Logging.connectors.warn((Object)("SharePoint: Unexpected relPath structure; path is '" + relPath + "', but expected to see something beginning with '" + this.rootPath + "'"));
            }
        }
    }
}

