/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class CollectionAdminRequest
extends SolrRequest<CollectionAdminResponse> {
    protected CollectionParams.CollectionAction action = null;
    private static String PROPERTY_PREFIX = "property.";

    protected void setAction(CollectionParams.CollectionAction action) {
        this.action = action;
    }

    public CollectionAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/collections");
    }

    public CollectionAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        return params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    protected CollectionAdminResponse createResponse(SolrClient client) {
        return new CollectionAdminResponse();
    }

    protected void addProperties(ModifiableSolrParams params, Properties props) {
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key = (String)prop.getKey();
            String value = (String)prop.getValue();
            params.set(PROPERTY_PREFIX + key, value);
        }
    }

    public static class BalanceShardUnique
    extends CollectionAdminRequest {
        private String collection;
        private String propertyName;
        private Boolean onlyActiveNodes;
        private Boolean shardUnique;

        public BalanceShardUnique() {
            this.action = CollectionParams.CollectionAction.BALANCESHARDUNIQUE;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public Boolean getOnlyActiveNodes() {
            return this.onlyActiveNodes;
        }

        public void setOnlyActiveNodes(Boolean onlyActiveNodes) {
            this.onlyActiveNodes = onlyActiveNodes;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public void setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("property", this.propertyName);
            if (this.onlyActiveNodes != null) {
                params.set("onlyactivenodes", this.onlyActiveNodes);
            }
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }
    }

    public static class DeleteReplicaProp
    extends CollectionShardAdminRequest {
        private String replica;
        private String propertyName;

        public DeleteReplicaProp() {
            this.action = CollectionParams.CollectionAction.DELETEREPLICAPROP;
        }

        public String getReplica() {
            return this.replica;
        }

        public void setReplica(String replica) {
            this.replica = replica;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            return params;
        }
    }

    public static class AddReplicaProp
    extends CollectionShardAdminRequest {
        private String replica;
        private String propertyName;
        private String propertyValue;
        private Boolean shardUnique;

        public AddReplicaProp() {
            this.action = CollectionParams.CollectionAction.ADDREPLICAPROP;
        }

        public String getReplica() {
            return this.replica;
        }

        public void setReplica(String replica) {
            this.replica = replica;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public void setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            params.set("property.value", this.propertyValue);
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }
    }

    public static class List
    extends CollectionAdminRequest {
        public List() {
            this.action = CollectionParams.CollectionAction.LIST;
        }
    }

    public static class ClusterStatus
    extends CollectionAdminRequest {
        protected String shardName = null;
        protected String collection = null;

        public ClusterStatus() {
            this.action = CollectionParams.CollectionAction.CLUSTERSTATUS;
        }

        public void setCollectionName(String collectionName) {
            this.collection = collectionName;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public void setShardName(String shard) {
            this.shardName = shard;
        }

        public String getShardName() {
            return this.shardName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.collection != null) {
                params.set("collection", this.collection);
            }
            if (this.shardName != null) {
                params.set("shard", this.shardName);
            }
            return params;
        }
    }

    public static class OverseerStatus
    extends CollectionAdminRequest {
        public OverseerStatus() {
            this.action = CollectionParams.CollectionAction.OVERSEERSTATUS;
        }
    }

    public static class RemoveRole
    extends CollectionAdminRoleRequest {
        public RemoveRole() {
            this.action = CollectionParams.CollectionAction.REMOVEROLE;
        }
    }

    public static class AddRole
    extends CollectionAdminRoleRequest {
        public AddRole() {
            this.action = CollectionParams.CollectionAction.ADDROLE;
        }
    }

    public static class Migrate
    extends CollectionAdminRequest {
        private String collection;
        private String targetCollection;
        private String splitKey;
        private Integer forwardTimeout;
        private Properties properties;
        private String asyncId;

        public Migrate() {
            this.action = CollectionParams.CollectionAction.MIGRATE;
        }

        public void setCollectionName(String collection) {
            this.collection = collection;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public void setTargetCollection(String targetCollection) {
            this.targetCollection = targetCollection;
        }

        public String getTargetCollection() {
            return this.targetCollection;
        }

        public void setSplitKey(String splitKey) {
            this.splitKey = splitKey;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public void setForwardTimeout(int forwardTimeout) {
            this.forwardTimeout = forwardTimeout;
        }

        public Integer getForwardTimeout() {
            return this.forwardTimeout;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("target.collection", this.targetCollection);
            params.set("split.key", this.splitKey);
            if (this.forwardTimeout != null) {
                params.set("forward.timeout", this.forwardTimeout);
            }
            params.set("async", this.asyncId);
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        public void setAsyncId(String asyncId) {
            this.asyncId = asyncId;
        }

        public String getAsyncId() {
            return this.asyncId;
        }
    }

    public static class ClusterProp
    extends CollectionAdminRequest {
        private String propertyName;
        private String propertyValue;

        public ClusterProp() {
            this.action = CollectionParams.CollectionAction.CLUSTERPROP;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.add("name", this.propertyName);
            params.add("val", this.propertyValue);
            return params;
        }
    }

    public static class DeleteReplica
    extends CollectionShardAdminRequest {
        private String replica;
        private Boolean onlyIfDown;

        public DeleteReplica() {
            this.action = CollectionParams.CollectionAction.DELETEREPLICA;
        }

        public void setReplica(String replica) {
            this.replica = replica;
        }

        public String getReplica() {
            return this.replica;
        }

        public void setOnlyIfDown(boolean onlyIfDown) {
            this.onlyIfDown = onlyIfDown;
        }

        public Boolean getOnlyIfDown() {
            return this.onlyIfDown;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            if (this.onlyIfDown != null) {
                params.set("onlyIfDown", this.onlyIfDown);
            }
            return params;
        }
    }

    public static class AddReplica
    extends CollectionShardAdminRequest {
        private String node;
        private String routeKey;
        private String instanceDir;
        private String dataDir;
        private Properties properties;
        private String asyncId;

        public AddReplica() {
            this.action = CollectionParams.CollectionAction.ADDREPLICA;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public String getInstanceDir() {
            return this.instanceDir;
        }

        public void setInstanceDir(String instanceDir) {
            this.instanceDir = instanceDir;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.shardName == null || this.shardName.isEmpty()) {
                params.remove("shard");
                if (this.routeKey == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either shard or routeKey must be provided");
                }
                params.add("_route_", this.routeKey);
            }
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            if (this.node != null) {
                params.add("node", this.node);
            }
            if (this.instanceDir != null) {
                params.add("instanceDir", this.instanceDir);
            }
            if (this.dataDir != null) {
                params.add("dataDir", this.dataDir);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }

        public void setAsyncId(String asyncId) {
            this.asyncId = asyncId;
        }

        public String getAsyncId() {
            return this.asyncId;
        }
    }

    public static class DeleteAlias
    extends CollectionAdminRequest {
        protected String aliasName;

        public DeleteAlias() {
            this.action = CollectionParams.CollectionAction.DELETEALIAS;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.aliasName);
            return params;
        }
    }

    public static class CreateAlias
    extends CollectionAdminRequest {
        protected String aliasName;
        protected String aliasedCollections;

        public CreateAlias() {
            this.action = CollectionParams.CollectionAction.CREATEALIAS;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public void setAliasedCollections(String alias) {
            this.aliasedCollections = alias;
        }

        public String getAliasedCollections() {
            return this.aliasedCollections;
        }

        @Deprecated
        public void setCollectionName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("name", this.aliasName);
            params.set("collections", this.aliasedCollections);
            return params;
        }
    }

    public static class RequestStatus
    extends CollectionAdminRequest {
        protected String requestId = null;

        public RequestStatus() {
            this.action = CollectionParams.CollectionAction.REQUESTSTATUS;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getRequestId() {
            return this.requestId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("requestid", this.requestId);
            return params;
        }
    }

    public static class DeleteShard
    extends CollectionShardAdminRequest {
        public DeleteShard() {
            this.action = CollectionParams.CollectionAction.DELETESHARD;
        }
    }

    public static class SplitShard
    extends CollectionShardAdminRequest {
        protected String ranges;
        protected String splitKey;
        protected String asyncId;
        private Properties properties;

        public SplitShard() {
            this.action = CollectionParams.CollectionAction.SPLITSHARD;
        }

        public void setRanges(String ranges) {
            this.ranges = ranges;
        }

        public String getRanges() {
            return this.ranges;
        }

        public void setSplitKey(String splitKey) {
            this.splitKey = splitKey;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public void setAsyncId(String asyncId) {
            this.asyncId = asyncId;
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = this.getCommonParams();
            params.set("ranges", this.ranges);
            if (this.splitKey != null) {
                params.set("split.key", this.splitKey);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            params.set("async", this.asyncId);
            return params;
        }
    }

    public static class CreateShard
    extends CollectionShardAdminRequest {
        protected String nodeSet;
        private Properties properties;

        public void setNodeSet(String nodeSet) {
            this.nodeSet = nodeSet;
        }

        public String getNodeSet() {
            return this.nodeSet;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public CreateShard() {
            this.action = CollectionParams.CollectionAction.CREATESHARD;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = this.getCommonParams();
            if (this.nodeSet != null) {
                params.set("createNodeSet", this.nodeSet);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }
    }

    public static class Delete
    extends CollectionSpecificAdminRequest {
        public Delete() {
            this.action = CollectionParams.CollectionAction.DELETE;
        }
    }

    public static class Reload
    extends CollectionSpecificAdminRequest {
        public Reload() {
            this.action = CollectionParams.CollectionAction.RELOAD;
        }
    }

    public static class Create
    extends CollectionSpecificAdminRequest {
        protected String configName = null;
        protected String createNodeSet = null;
        protected String routerName;
        protected String shards;
        protected String routerField;
        protected Integer numShards;
        protected Integer maxShardsPerNode;
        protected Integer replicationFactor;
        private Properties properties;
        protected Boolean autoAddReplicas;
        protected Integer stateFormat;
        protected String asyncId;

        public Create() {
            this.action = CollectionParams.CollectionAction.CREATE;
        }

        public void setConfigName(String config) {
            this.configName = config;
        }

        public void setCreateNodeSet(String nodeSet) {
            this.createNodeSet = nodeSet;
        }

        public void setRouterName(String routerName) {
            this.routerName = routerName;
        }

        public void setShards(String shards) {
            this.shards = shards;
        }

        public void setRouterField(String routerField) {
            this.routerField = routerField;
        }

        public void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        public void setMaxShardsPerNode(Integer numShards) {
            this.maxShardsPerNode = numShards;
        }

        public void setAutoAddReplicas(boolean autoAddReplicas) {
            this.autoAddReplicas = autoAddReplicas;
        }

        public void setReplicationFactor(Integer repl) {
            this.replicationFactor = repl;
        }

        public void setStateFormat(Integer stateFormat) {
            this.stateFormat = stateFormat;
        }

        public void setAsyncId(String asyncId) {
            this.asyncId = asyncId;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCreateNodeSet() {
            return this.createNodeSet;
        }

        public String getRouterName() {
            return this.routerName;
        }

        public String getShards() {
            return this.shards;
        }

        public Integer getNumShards() {
            return this.numShards;
        }

        public Integer getMaxShardsPerNode() {
            return this.maxShardsPerNode;
        }

        public Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public Boolean getAutoAddReplicas() {
            return this.autoAddReplicas;
        }

        public Integer getStateFormat() {
            return this.stateFormat;
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection.configName", this.configName);
            params.set("createNodeSet", this.createNodeSet);
            if (this.numShards != null) {
                params.set("numShards", this.numShards);
            }
            if (this.maxShardsPerNode != null) {
                params.set("maxShardsPerNode", this.maxShardsPerNode);
            }
            params.set("router.name", this.routerName);
            params.set("shards", this.shards);
            if (this.routerField != null) {
                params.set("router.field", this.routerField);
            }
            if (this.replicationFactor != null) {
                params.set("replicationFactor", this.replicationFactor);
            }
            params.set("async", this.asyncId);
            if (this.autoAddReplicas != null) {
                params.set("autoAddReplicas", this.autoAddReplicas);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.stateFormat != null) {
                params.set("stateFormat", this.stateFormat);
            }
            return params;
        }
    }

    protected static class CollectionAdminRoleRequest
    extends CollectionAdminRequest {
        private String node;
        private String role;

        protected CollectionAdminRoleRequest() {
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getRole() {
            return this.role;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("role", this.role);
            params.set("node", this.node);
            return params;
        }
    }

    protected static class CollectionShardAdminRequest
    extends CollectionAdminRequest {
        protected String shardName = null;
        protected String collection = null;

        protected CollectionShardAdminRequest() {
        }

        public void setCollectionName(String collectionName) {
            this.collection = collectionName;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public void setShardName(String shard) {
            this.shardName = shard;
        }

        public String getShardName() {
            return this.shardName;
        }

        public ModifiableSolrParams getCommonParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("shard", this.shardName);
            return params;
        }

        @Override
        public SolrParams getParams() {
            return this.getCommonParams();
        }
    }

    protected static class CollectionSpecificAdminRequest
    extends CollectionAdminRequest {
        protected String collection = null;

        protected CollectionSpecificAdminRequest() {
        }

        public final void setCollectionName(String collectionName) {
            this.collection = collectionName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.collection);
            return params;
        }
    }
}

