/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.PushBackStream;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;

public class ReducerStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    private PushBackStream tupleStream;
    private Comparator<Tuple> comp;
    private Tuple currentGroupHead;

    public ReducerStream(TupleStream tupleStream, Comparator<Tuple> comp) {
        this.tupleStream = new PushBackStream(tupleStream);
        this.comp = comp;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple t;
        ArrayList<Map> maps = new ArrayList<Map>();
        while (true) {
            t = this.tupleStream.read();
            if (t.EOF) {
                if (maps.size() > 0) {
                    this.tupleStream.pushBack(t);
                    Map map1 = (Map)maps.get(0);
                    HashMap map2 = new HashMap();
                    map2.putAll(map1);
                    Tuple groupHead = new Tuple(map2);
                    groupHead.setMaps(maps);
                    return groupHead;
                }
                return t;
            }
            if (this.currentGroupHead == null) {
                this.currentGroupHead = t;
                maps.add(t.getMap());
                continue;
            }
            if (this.comp.compare(this.currentGroupHead, t) != 0) break;
            maps.add(t.getMap());
        }
        Tuple groupHead = this.currentGroupHead.clone();
        this.tupleStream.pushBack(t);
        this.currentGroupHead = null;
        groupHead.setMaps(maps);
        return groupHead;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

