/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.TypeInfo;

public final class JDOFieldDescriptorImpl
extends FieldDescriptorImpl
implements JDOFieldDescriptor {
    private final TypeConvertor _convertor;
    private final String _convertorParam;
    private final String[] _sqlName;
    private final int[] _sqlType;
    private final String _manyTable;
    private final String[] _manyKey;
    private final boolean _dirtyCheck;
    private final boolean _readonly;

    public JDOFieldDescriptorImpl(String fieldName, TypeInfo typeInfo, FieldHandler handler, boolean trans, String[] sqlName, int[] sqlType, String manyTable, String[] manyKey, boolean dirtyCheck, boolean readonly) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Argument 'fieldName' is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'fieldDesc' has no handler");
        }
        this.setFieldName(fieldName);
        this.setFieldType(typeInfo.getFieldType());
        this.setHandler(handler);
        this.setTransient(trans);
        this.setImmutable(typeInfo.isImmutable());
        this.setRequired(typeInfo.isRequired());
        this.setMultivalued(typeInfo.getCollectionHandler() != null);
        this._convertor = typeInfo.getConvertorFrom();
        this._convertorParam = typeInfo.getConvertorParam();
        this._sqlName = sqlName.length == 0 ? null : sqlName;
        this._sqlType = sqlType;
        this._manyTable = manyTable;
        this._manyKey = manyKey.length > 0 ? manyKey : null;
        this._dirtyCheck = dirtyCheck;
        this._readonly = readonly;
    }

    public TypeConvertor getConvertor() {
        return this._convertor;
    }

    public String getConvertorParam() {
        return this._convertorParam;
    }

    public String[] getSQLName() {
        return this._sqlName;
    }

    public int[] getSQLType() {
        return this._sqlType;
    }

    public String getManyTable() {
        return this._manyTable;
    }

    public String[] getManyKey() {
        return this._manyKey;
    }

    public boolean isDirtyCheck() {
        return this._dirtyCheck;
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public String toString() {
        return this.getFieldName() + "(" + this.getFieldType().getName() + ")" + (this._sqlName == null ? "" : " AS " + this._sqlName[0]);
    }
}

