<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: page
title: Developer Resources

    
---

<a name="DeveloperResources-MakingaContribution"></a>
## Making a Contribution

Mahout is always looking for contributions, especially in the areas of
documentation. See our [How to contribute](/developers/how-to-contribute.html) page for details.


<a name="DeveloperResources-SourceCode"></a>
## Source Code

The source files are stored using Git, our page on [version control](/developers/version-control.html) has details on how to access the sourcecode.


<a name="DeveloperResources-Documentation"></a>
## Documentation

Javadoc and Scaladoc documentation is available online by module:

 * [Mahout Math](/docs/{{ site.mahout-version }}/api/docs/mahout-math/index.html)
 * [Mahout Math Scala bindings](/docs/{{ site.mahout-version }}/api/docs/mahout-math-scala/index.html)
 * [Mahout Spark bindings](/docs/{{ site.mahout-version }}/api/docs/mahout-spark/index.html)
 * [Mahout HDFS](/docs/{{ site.mahout-version }}/api/docs/mahout-hdfs/index.html)
 * [Mahout Map-Reduce](/docs/{{ site.mahout-version }}/api/docs/mahout-mr/index.html)
 * [Mahout Integration](/docs/{{ site.mahout-version }}/api/docs/mahout-integration/index.html)

<a name="DeveloperResources-Issues"></a>
## Issues

All bugs, improvements, [pull requests](http://mahout.apache.org/developers/github.html), etc. should be logged in our [issue tracker](/developers/issue-tracker.html).

<a name="DeveloperResources-ContinuousIntegration"></a>
## Continuous Integration

Mahout is continuously built on an hourly basis on the [Apache Jenkins](https://builds.apache.org/job/Mahout-Quality/)  build system.

## Board reports

Every three months Mahout submits a report to the Apache board. All of the drafts that get sent are checked into svn. See here:

<a href="https://svn.apache.org/repos/asf/mahout/pmc/board-reports/">https://svn.apache.org/repos/asf/mahout/pmc/board-reports/</a>