/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.solver;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class EigenDecomposition {
    private final int n;
    private final Vector d;
    private final Vector e;
    private final Matrix v;
    private double cdivr;
    private double cdivi;

    public EigenDecomposition(Matrix x) {
        this(x, EigenDecomposition.isSymmetric(x));
    }

    public EigenDecomposition(Matrix x, boolean isSymmetric) {
        this.n = x.columnSize();
        this.d = new DenseVector(this.n);
        this.e = new DenseVector(this.n);
        this.v = new DenseMatrix(this.n, this.n);
        if (isSymmetric) {
            this.v.assign(x);
            this.tred2();
            this.tql2();
        } else {
            this.hqr2(this.orthes(x));
        }
    }

    public Matrix getV() {
        return this.v.like().assign(this.v);
    }

    public Vector getRealEigenvalues() {
        return this.d;
    }

    public Vector getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        DenseMatrix x = new DenseMatrix(this.n, this.n);
        x.assign(0.0);
        x.viewDiagonal().assign(this.d);
        for (int i = 0; i < this.n; ++i) {
            double v = this.e.getQuick(i);
            if (v > 0.0) {
                x.setQuick(i, i + 1, v);
                continue;
            }
            if (!(v < 0.0)) continue;
            x.setQuick(i, i - 1, v);
        }
        return x;
    }

    private void tred2() {
        int i;
        this.d.assign(this.v.viewColumn(this.n - 1));
        for (i = this.n - 1; i > 0; --i) {
            double scale = this.d.viewPart(0, i).norm(1.0);
            double h = 0.0;
            if (scale == 0.0) {
                this.e.setQuick(i, this.d.getQuick(i - 1));
                for (int j = 0; j < i; ++j) {
                    this.d.setQuick(j, this.v.getQuick(i - 1, j));
                    this.v.setQuick(i, j, 0.0);
                    this.v.setQuick(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (int k = 0; k < i; ++k) {
                    this.d.setQuick(k, this.d.getQuick(k) / scale);
                    h += this.d.getQuick(k) * this.d.getQuick(k);
                }
                double f2 = this.d.getQuick(i - 1);
                double g = Math.sqrt(h);
                if (f2 > 0.0) {
                    g = -g;
                }
                this.e.setQuick(i, scale * g);
                h -= f2 * g;
                this.d.setQuick(i - 1, f2 - g);
                for (j2 = 0; j2 < i; ++j2) {
                    this.e.setQuick(j2, 0.0);
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f2 = this.d.getQuick(j2);
                    this.v.setQuick(j2, i, f2);
                    g = this.e.getQuick(j2) + this.v.getQuick(j2, j2) * f2;
                    for (int k = j2 + 1; k <= i - 1; ++k) {
                        g += this.v.getQuick(k, j2) * this.d.getQuick(k);
                        this.e.setQuick(k, this.e.getQuick(k) + this.v.getQuick(k, j2) * f2);
                    }
                    this.e.setQuick(j2, g);
                }
                f2 = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    this.e.setQuick(j2, this.e.getQuick(j2) / h);
                    f2 += this.e.getQuick(j2) * this.d.getQuick(j2);
                }
                double hh = f2 / (h + h);
                for (j = 0; j < i; ++j) {
                    this.e.setQuick(j, this.e.getQuick(j) - hh * this.d.getQuick(j));
                }
                for (j = 0; j < i; ++j) {
                    f2 = this.d.getQuick(j);
                    g = this.e.getQuick(j);
                    for (int k = j; k <= i - 1; ++k) {
                        this.v.setQuick(k, j, this.v.getQuick(k, j) - (f2 * this.e.getQuick(k) + g * this.d.getQuick(k)));
                    }
                    this.d.setQuick(j, this.v.getQuick(i - 1, j));
                    this.v.setQuick(i, j, 0.0);
                }
            }
            this.d.setQuick(i, h);
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.v.setQuick(this.n - 1, i, this.v.getQuick(i, i));
            this.v.setQuick(i, i, 1.0);
            double h = this.d.getQuick(i + 1);
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d.setQuick(k, this.v.getQuick(k, i + 1) / h);
                }
                for (int j = 0; j <= i; ++j) {
                    int k2;
                    double g = 0.0;
                    for (k2 = 0; k2 <= i; ++k2) {
                        g += this.v.getQuick(k2, i + 1) * this.v.getQuick(k2, j);
                    }
                    for (k2 = 0; k2 <= i; ++k2) {
                        this.v.setQuick(k2, j, this.v.getQuick(k2, j) - g * this.d.getQuick(k2));
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.v.setQuick(k, i + 1, 0.0);
            }
        }
        this.d.assign(this.v.viewRow(this.n - 1));
        this.v.viewRow(this.n - 1).assign(0.0);
        this.v.setQuick(this.n - 1, this.n - 1, 1.0);
        this.e.setQuick(0, 0.0);
    }

    private void tql2() {
        this.e.viewPart(0, this.n - 1).assign(this.e.viewPart(1, this.n - 1));
        this.e.setQuick(this.n - 1, 0.0);
        double f2 = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d.getQuick(l)) + Math.abs(this.e.getQuick(l)));
            for (m = l; m < this.n && !(Math.abs(this.e.getQuick(m)) <= eps * tst1); ++m) {
            }
            if (m > l) {
                do {
                    double c;
                    double g = this.d.getQuick(l);
                    double p = (this.d.getQuick(l + 1) - g) / (2.0 * this.e.getQuick(l));
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d.setQuick(l, this.e.getQuick(l) / (p + r));
                    this.d.setQuick(l + 1, this.e.getQuick(l) * (p + r));
                    double dl1 = this.d.getQuick(l + 1);
                    double h = g - this.d.getQuick(l);
                    for (int i = l + 2; i < this.n; ++i) {
                        this.d.setQuick(i, this.d.getQuick(i) - h);
                    }
                    f2 += h;
                    p = this.d.getQuick(m);
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e.getQuick(l + 1);
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i = m - 1; i >= l; --i) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e.getQuick(i);
                        h = c * p;
                        r = Math.hypot(p, this.e.getQuick(i));
                        this.e.setQuick(i + 1, s * r);
                        s = this.e.getQuick(i) / r;
                        c = p / r;
                        p = c * this.d.getQuick(i) - s * g;
                        this.d.setQuick(i + 1, h + s * (c * g + s * this.d.getQuick(i)));
                        for (int k = 0; k < this.n; ++k) {
                            h = this.v.getQuick(k, i + 1);
                            this.v.setQuick(k, i + 1, s * this.v.getQuick(k, i) + c * h);
                            this.v.setQuick(k, i, c * this.v.getQuick(k, i) - s * h);
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e.getQuick(l) / dl1;
                    this.e.setQuick(l, s * p);
                    this.d.setQuick(l, c * p);
                } while (Math.abs(this.e.getQuick(l)) > eps * tst1);
            }
            this.d.setQuick(l, this.d.getQuick(l) + f2);
            this.e.setQuick(l, 0.0);
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d.getQuick(i);
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d.getQuick(j) > p)) continue;
                k = j;
                p = this.d.getQuick(j);
            }
            if (k == i) continue;
            this.d.setQuick(k, this.d.getQuick(i));
            this.d.setQuick(i, p);
            for (j = 0; j < this.n; ++j) {
                p = this.v.getQuick(j, i);
                this.v.setQuick(j, i, this.v.getQuick(j, k));
                this.v.setQuick(j, k, p);
            }
        }
    }

    private Matrix orthes(Matrix x) {
        int m;
        DenseVector ort = new DenseVector(this.n);
        Matrix hessenBerg = new DenseMatrix(this.n, this.n).assign(x);
        int low = 0;
        int high = this.n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f2;
            Vector hColumn = hessenBerg.viewColumn(m - 1).viewPart(m, high - m + 1);
            double scale = hColumn.norm(1.0);
            if (scale == 0.0) continue;
            ort.viewPart(m, high - m + 1).assign(hColumn, Functions.plusMult(1.0 / scale));
            double h = ort.viewPart(m, high - m + 1).getLengthSquared();
            double g = Math.sqrt(h);
            if (ort.getQuick(m) > 0.0) {
                g = -g;
            }
            h -= ort.getQuick(m) * g;
            ort.setQuick(m, ort.getQuick(m) - g);
            Vector ortPiece = ort.viewPart(m, high - m + 1);
            for (int j = m; j < this.n; ++j) {
                f2 = ortPiece.dot(hessenBerg.viewColumn(j).viewPart(m, high - m + 1)) / h;
                hessenBerg.viewColumn(j).viewPart(m, high - m + 1).assign(ortPiece, Functions.plusMult(-f2));
            }
            for (int i = 0; i <= high; ++i) {
                f2 = ortPiece.dot(hessenBerg.viewRow(i).viewPart(m, high - m + 1)) / h;
                hessenBerg.viewRow(i).viewPart(m, high - m + 1).assign(ortPiece, Functions.plusMult(-f2));
            }
            ort.setQuick(m, scale * ort.getQuick(m));
            hessenBerg.setQuick(m, m - 1, scale * g);
        }
        this.v.assign(0.0);
        this.v.viewDiagonal().assign(1.0);
        for (m = high - 1; m >= low + 1; --m) {
            if (hessenBerg.getQuick(m, m - 1) == 0.0) continue;
            ort.viewPart(m + 1, high - m).assign(hessenBerg.viewColumn(m - 1).viewPart(m + 1, high - m));
            for (int j = m; j <= high; ++j) {
                double g = ort.viewPart(m, high - m + 1).dot(this.v.viewColumn(j).viewPart(m, high - m + 1));
                g = g / ort.getQuick(m) / hessenBerg.getQuick(m, m - 1);
                this.v.viewColumn(j).viewPart(m, high - m + 1).assign(ort.viewPart(m, high - m + 1), Functions.plusMult(g));
            }
        }
        return hessenBerg;
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2(Matrix h) {
        int k;
        double y;
        int i;
        int j;
        double x;
        double w;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = h.aggregate(Functions.PLUS, Functions.ABS);
        int iter = 0;
        block0: while (n >= low) {
            int m;
            int l;
            for (l = n; l > low; --l) {
                s = Math.abs(h.getQuick(l - 1, l - 1)) + Math.abs(h.getQuick(l, l));
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(h.getQuick(l, l - 1)) < eps * s) break;
            }
            if (l == n) {
                h.setQuick(n, n, h.getQuick(n, n) + exshift);
                this.d.setQuick(n, h.getQuick(n, n));
                this.e.setQuick(n, 0.0);
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = h.getQuick(n, n - 1) * h.getQuick(n - 1, n);
                p = (h.getQuick(n - 1, n - 1) - h.getQuick(n, n)) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                h.setQuick(n, n, h.getQuick(n, n) + exshift);
                h.setQuick(n - 1, n - 1, h.getQuick(n - 1, n - 1) + exshift);
                x = h.getQuick(n, n);
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d.setQuick(n - 1, x + z);
                    this.d.setQuick(n, this.d.getQuick(n - 1));
                    if (z != 0.0) {
                        this.d.setQuick(n, x - w / z);
                    }
                    this.e.setQuick(n - 1, 0.0);
                    this.e.setQuick(n, 0.0);
                    x = h.getQuick(n, n - 1);
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = h.getQuick(n - 1, j);
                        h.setQuick(n - 1, j, q * z + p * h.getQuick(n, j));
                        h.setQuick(n, j, q * h.getQuick(n, j) - p * z);
                    }
                    for (i = 0; i <= n; ++i) {
                        z = h.getQuick(i, n - 1);
                        h.setQuick(i, n - 1, q * z + p * h.getQuick(i, n));
                        h.setQuick(i, n, q * h.getQuick(i, n) - p * z);
                    }
                    for (i = low; i <= high; ++i) {
                        z = this.v.getQuick(i, n - 1);
                        this.v.setQuick(i, n - 1, q * z + p * this.v.getQuick(i, n));
                        this.v.setQuick(i, n, q * this.v.getQuick(i, n) - p * z);
                    }
                } else {
                    this.d.setQuick(n - 1, x + p);
                    this.d.setQuick(n, x + p);
                    this.e.setQuick(n - 1, z);
                    this.e.setQuick(n, -z);
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = h.getQuick(n, n);
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = h.getQuick(n - 1, n - 1);
                w = h.getQuick(n, n - 1) * h.getQuick(n - 1, n);
            }
            if (iter == 10) {
                exshift += x;
                for (i = low; i <= n; ++i) {
                    h.setQuick(i, i, x);
                }
                s = Math.abs(h.getQuick(n, n - 1)) + Math.abs(h.getQuick(n - 1, n - 2));
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = low; i <= n; ++i) {
                        h.setQuick(i, i, h.getQuick(i, i) - s);
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = h.getQuick(m, m);
                r = x - z;
                s = y - z;
                p = (r * s - w) / h.getQuick(m + 1, m) + h.getQuick(m, m + 1);
                q = h.getQuick(m + 1, m + 1) - z - r - s;
                r = h.getQuick(m + 2, m + 1);
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                p /= s;
                q /= s;
                r /= s;
                if (m == l) break;
                double hmag = Math.abs(h.getQuick(m - 1, m - 1)) + Math.abs(h.getQuick(m + 1, m + 1));
                double threshold = eps * Math.abs(p) * (Math.abs(z) + hmag);
                if (Math.abs(h.getQuick(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < threshold) break;
            }
            for (int i2 = m + 2; i2 <= n; ++i2) {
                h.setQuick(i2, i2 - 2, 0.0);
                if (i2 <= m + 2) continue;
                h.setQuick(i2, i2 - 3, 0.0);
            }
            for (k = m; k <= n - 1; ++k) {
                int i3;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = h.getQuick(k, k - 1);
                    q = h.getQuick(k + 1, k - 1);
                    r = notlast ? h.getQuick(k + 2, k - 1) : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block0;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    h.setQuick(k, k - 1, -s * x);
                } else if (l != m) {
                    h.setQuick(k, k - 1, -h.getQuick(k, k - 1));
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j2 = k; j2 < nn; ++j2) {
                    p = h.getQuick(k, j2) + q * h.getQuick(k + 1, j2);
                    if (notlast) {
                        h.setQuick(k + 2, j2, h.getQuick(k + 2, j2) - (p += r * h.getQuick(k + 2, j2)) * z);
                    }
                    h.setQuick(k, j2, h.getQuick(k, j2) - p * x);
                    h.setQuick(k + 1, j2, h.getQuick(k + 1, j2) - p * y);
                }
                for (i3 = 0; i3 <= Math.min(n, k + 3); ++i3) {
                    p = x * h.getQuick(i3, k) + y * h.getQuick(i3, k + 1);
                    if (notlast) {
                        h.setQuick(i3, k + 2, h.getQuick(i3, k + 2) - (p += z * h.getQuick(i3, k + 2)) * r);
                    }
                    h.setQuick(i3, k, h.getQuick(i3, k) - p);
                    h.setQuick(i3, k + 1, h.getQuick(i3, k + 1) - p * q);
                }
                for (i3 = low; i3 <= high; ++i3) {
                    p = x * this.v.getQuick(i3, k) + y * this.v.getQuick(i3, k + 1);
                    if (notlast) {
                        this.v.setQuick(i3, k + 2, this.v.getQuick(i3, k + 2) - (p += z * this.v.getQuick(i3, k + 2)) * r);
                    }
                    this.v.setQuick(i3, k, this.v.getQuick(i3, k) - p);
                    this.v.setQuick(i3, k + 1, this.v.getQuick(i3, k + 1) - p * q);
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            int i4;
            int l;
            p = this.d.getQuick(n);
            q = this.e.getQuick(n);
            if (q == 0.0) {
                l = n;
                h.setQuick(n, n, 1.0);
                for (i4 = n - 1; i4 >= 0; --i4) {
                    int j3;
                    w = h.getQuick(i4, i4) - p;
                    r = 0.0;
                    for (j3 = l; j3 <= n; ++j3) {
                        r += h.getQuick(i4, j3) * h.getQuick(j3, n);
                    }
                    if (this.e.getQuick(i4) < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i4;
                    if (this.e.getQuick(i4) == 0.0) {
                        if (w == 0.0) {
                            h.setQuick(i4, n, -r / (eps * norm));
                        } else {
                            h.setQuick(i4, n, -r / w);
                        }
                    } else {
                        x = h.getQuick(i4, i4 + 1);
                        y = h.getQuick(i4 + 1, i4);
                        q = (this.d.getQuick(i4) - p) * (this.d.getQuick(i4) - p) + this.e.getQuick(i4) * this.e.getQuick(i4);
                        t = (x * s - z * r) / q;
                        h.setQuick(i4, n, t);
                        if (Math.abs(x) > Math.abs(z)) {
                            h.setQuick(i4 + 1, n, (-r - w * t) / x);
                        } else {
                            h.setQuick(i4 + 1, n, (-s - y * t) / z);
                        }
                    }
                    t = Math.abs(h.getQuick(i4, n));
                    if (!(eps * t * t > 1.0)) continue;
                    for (j3 = i4; j3 <= n; ++j3) {
                        h.setQuick(j3, n, h.getQuick(j3, n) / t);
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(h.getQuick(n, n - 1)) > Math.abs(h.getQuick(n - 1, n))) {
                h.setQuick(n - 1, n - 1, q / h.getQuick(n, n - 1));
                h.setQuick(n - 1, n, -(h.getQuick(n, n) - p) / h.getQuick(n, n - 1));
            } else {
                this.cdiv(0.0, -h.getQuick(n - 1, n), h.getQuick(n - 1, n - 1) - p, q);
                h.setQuick(n - 1, n - 1, this.cdivr);
                h.setQuick(n - 1, n, this.cdivi);
            }
            h.setQuick(n, n - 1, 0.0);
            h.setQuick(n, n, 1.0);
            for (i4 = n - 2; i4 >= 0; --i4) {
                int j4;
                double ra = 0.0;
                double sa = 0.0;
                for (j4 = l; j4 <= n; ++j4) {
                    ra += h.getQuick(i4, j4) * h.getQuick(j4, n - 1);
                    sa += h.getQuick(i4, j4) * h.getQuick(j4, n);
                }
                w = h.getQuick(i4, i4) - p;
                if (this.e.getQuick(i4) < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i4;
                if (this.e.getQuick(i4) == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    h.setQuick(i4, n - 1, this.cdivr);
                    h.setQuick(i4, n, this.cdivi);
                } else {
                    x = h.getQuick(i4, i4 + 1);
                    y = h.getQuick(i4 + 1, i4);
                    double vr = (this.d.getQuick(i4) - p) * (this.d.getQuick(i4) - p) + this.e.getQuick(i4) * this.e.getQuick(i4) - q * q;
                    double vi = (this.d.getQuick(i4) - p) * 2.0 * q;
                    if (vr == 0.0 && vi == 0.0) {
                        double hmag = Math.abs(x) + Math.abs(y);
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + hmag + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    h.setQuick(i4, n - 1, this.cdivr);
                    h.setQuick(i4, n, this.cdivi);
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        h.setQuick(i4 + 1, n - 1, (-ra - w * h.getQuick(i4, n - 1) + q * h.getQuick(i4, n)) / x);
                        h.setQuick(i4 + 1, n, (-sa - w * h.getQuick(i4, n) - q * h.getQuick(i4, n - 1)) / x);
                    } else {
                        this.cdiv(-r - y * h.getQuick(i4, n - 1), -s - y * h.getQuick(i4, n), z, q);
                        h.setQuick(i4 + 1, n - 1, this.cdivr);
                        h.setQuick(i4 + 1, n, this.cdivi);
                    }
                }
                t = Math.max(Math.abs(h.getQuick(i4, n - 1)), Math.abs(h.getQuick(i4, n)));
                if (!(eps * t * t > 1.0)) continue;
                for (j4 = i4; j4 <= n; ++j4) {
                    h.setQuick(j4, n - 1, h.getQuick(j4, n - 1) / t);
                    h.setQuick(j4, n, h.getQuick(j4, n) / t);
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (i5 >= low && i5 <= high) continue;
            for (j = i5; j < nn; ++j) {
                this.v.setQuick(i5, j, h.getQuick(i5, j));
            }
        }
        for (int j5 = nn - 1; j5 >= low; --j5) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (k = low; k <= Math.min(j5, high); ++k) {
                    z += this.v.getQuick(i, k) * h.getQuick(k, j5);
                }
                this.v.setQuick(i, j5, z);
            }
        }
    }

    private static boolean isSymmetric(Matrix a) {
        int n = a.columnSize();
        boolean isSymmetric = true;
        for (int j = 0; j < n && isSymmetric; ++j) {
            for (int i = 0; i < n && isSymmetric; ++i) {
                isSymmetric = a.getQuick(i, j) == a.getQuick(j, i);
            }
        }
        return isSymmetric;
    }
}

