/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.random.PoissonSampler;
import org.apache.mahout.math.random.Sampler;

public final class IndianBuffet<T>
implements Sampler<List<T>> {
    private final List<Integer> count = Lists.newArrayList();
    private int documents = 0;
    private final double alpha;
    private WordFunction<T> converter = null;
    private final Random gen;

    public IndianBuffet(double alpha, WordFunction<T> converter) {
        this.alpha = alpha;
        this.converter = converter;
        this.gen = RandomUtils.getRandom();
    }

    public static IndianBuffet<Integer> createIntegerDocumentSampler(double alpha) {
        return new IndianBuffet<Integer>(alpha, new IdentityConverter());
    }

    public static IndianBuffet<String> createTextDocumentSampler(double alpha) {
        return new IndianBuffet<String>(alpha, new WordConverter());
    }

    @Override
    public List<T> sample() {
        ArrayList r = Lists.newArrayList();
        if (this.documents == 0) {
            double n = new PoissonSampler(this.alpha).sample();
            int i = 0;
            while ((double)i < n) {
                r.add(this.converter.convert(i));
                this.count.add(1);
                ++i;
            }
            ++this.documents;
        } else {
            ++this.documents;
            int i = 0;
            Iterator<Integer> iterator = this.count.iterator();
            while (iterator.hasNext()) {
                double cnt = iterator.next().intValue();
                if (this.gen.nextDouble() < cnt / (double)this.documents) {
                    r.add(this.converter.convert(i));
                    this.count.set(i, this.count.get(i) + 1);
                }
                ++i;
            }
            int newItems = new PoissonSampler(this.alpha / (double)this.documents).sample().intValue();
            for (int j = 0; j < newItems; ++j) {
                r.add(this.converter.convert(i + j));
                this.count.add(1);
            }
        }
        return r;
    }

    public static class ImpossibleException
    extends RuntimeException {
        public ImpossibleException(Throwable e) {
            super(e);
        }
    }

    public static final class WordConverter
    implements WordFunction<String> {
        private final Splitter onSpace = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().trimResults();
        private final List<String> words;

        public WordConverter() {
            try {
                this.words = (List)Resources.readLines((URL)Resources.getResource((String)"words.txt"), (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<List<String>>(){
                    private final List<String> theWords = Lists.newArrayList();

                    public boolean processLine(String line) {
                        Iterables.addAll(this.theWords, (Iterable)onSpace.split((CharSequence)line));
                        return true;
                    }

                    public List<String> getResult() {
                        return this.theWords;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpossibleException(e);
            }
        }

        @Override
        public String convert(int i) {
            if (i < this.words.size()) {
                return this.words.get(i);
            }
            return "w_" + i;
        }
    }

    public static class StringConverter
    implements WordFunction<String> {
        @Override
        public String convert(int i) {
            return String.valueOf(i);
        }
    }

    public static class IdentityConverter
    implements WordFunction<Integer> {
        @Override
        public Integer convert(int i) {
            return i;
        }
    }

    private static interface WordFunction<T> {
        public T convert(int var1);
    }
}

