/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.apache.log4j.chainsaw.SavableTabSetting;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

class ChainsawTabbedPane
extends JTabbedPane
implements SettingsListener {
    public SavableTabSetting tabSetting;
    public static final String WELCOME_TAB = "Welcome";
    public static final String ZEROCONF = "Zeroconf";

    boolean containsWelcomePanel() {
        return this.indexOfTab(WELCOME_TAB) > -1;
    }

    public void addANewTab(String name, JComponent component, Icon icon) {
        super.insertTab(name, icon, component, null, this.getTabCount());
        super.fireStateChanged();
        if (!"chainsaw-log".equals(name)) {
            EventQueue.invokeLater(() -> this.setSelectedTab(this.getTabCount() - 1));
        }
    }

    public void setSelectedTab(int index) {
        if (this.getTabCount() >= index) {
            this.setSelectedIndex(index);
        }
        this.getSelectedComponent().setVisible(true);
        this.getSelectedComponent().validate();
        super.fireStateChanged();
    }

    public void addANewTab(String name, JComponent component, Icon icon, String tooltip) {
        super.insertTab(name, icon, component, tooltip, this.getTabCount());
        super.fireStateChanged();
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        super.fireStateChanged();
    }

    @Override
    public void saveSettings(SaveSettingsEvent event) {
        File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "tab-settings.xml");
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            FileWriter writer = new FileWriter(file);
            int count = super.getTabCount();
            SavableTabSetting setting = new SavableTabSetting();
            block12: for (int i = 0; i < count; ++i) {
                String title;
                switch (title = super.getTitleAt(i)) {
                    case "Welcome": {
                        setting.setWelcome(true);
                        continue block12;
                    }
                    case "chainsaw-log": {
                        setting.setChainsawLog(true);
                        continue block12;
                    }
                    case "Zeroconf": {
                        setting.setZeroconf(true);
                    }
                }
            }
            stream.toXML((Object)setting, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            file.delete();
            e.printStackTrace();
        }
    }

    @Override
    public void loadSettings(LoadSettingsEvent event) {
        File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "tab-settings.xml");
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            if (file.exists()) {
                FileReader reader = new FileReader(file);
                this.tabSetting = (SavableTabSetting)stream.fromXML((Reader)reader);
                reader.close();
            } else {
                this.tabSetting = new SavableTabSetting();
                this.tabSetting.setWelcome(true);
                this.tabSetting.setChainsawLog(true);
                this.tabSetting.setZeroconf(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
        }
    }
}

