/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl.transports;

import java.util.concurrent.ThreadFactory;
import org.apache.kyuubi.shade.io.netty.channel.Channel;
import org.apache.kyuubi.shade.io.netty.channel.ChannelFactory;
import org.apache.kyuubi.shade.io.netty.channel.EventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.ServerChannel;
import org.apache.kyuubi.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.socket.DatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.kyuubi.shade.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.kyuubi.shade.io.vertx.core.spi.transport.Transport;

public class JDKTransport
implements Transport {
    public static final Transport INSTANCE = new JDKTransport();

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException("The Vertx instance must be created with the preferNativeTransport option set to true to create domain sockets");
        }
        return NioSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel::new;
    }
}

