/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiArrowBasedResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnVector;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnarBatch;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnarBatchRow;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowUtils;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumnDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOperationHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TSessionHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTableSchema;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiArrowQueryResultSet
extends KyuubiArrowBasedResultSet {
    public static final Logger LOG = LoggerFactory.getLogger(KyuubiArrowQueryResultSet.class);
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle;
    private TSessionHandle sessHandle;
    private int maxRows;
    private int fetchSize;
    private int rowsFetched = 0;
    private Iterator<ArrowColumnarBatchRow> fetchedRowsItr;
    private boolean isClosed = false;
    private boolean emptyResultSet = false;
    private boolean isScrollable = false;
    private boolean fetchFirst = false;
    private final TProtocolVersion protocol;

    protected KyuubiArrowQueryResultSet(Builder builder) throws SQLException {
        this.statement = builder.statement;
        this.client = builder.client;
        this.stmtHandle = builder.stmtHandle;
        this.sessHandle = builder.sessHandle;
        this.fetchSize = builder.fetchSize;
        this.columnNames = new ArrayList();
        this.normalizedColumnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnAttributes = new ArrayList();
        if (builder.retrieveSchema) {
            this.retrieveSchema();
        } else {
            this.setSchema(builder.colNames, builder.colTypes, builder.colAttributes);
        }
        this.emptyResultSet = builder.emptyResultSet;
        this.maxRows = builder.emptyResultSet ? 0 : builder.maxRows;
        this.isScrollable = builder.isScrollable;
        this.timestampAsString = builder.timestampAsString;
        this.protocol = builder.getProtocolVersion();
        this.arrowSchema = ArrowUtils.toArrowSchema(this.columnNames, this.convertToStringType(this.columnTypes), this.columnAttributes);
        if (this.allocator == null) {
            this.initArrowSchemaAndAllocator();
        }
    }

    public static JdbcColumnAttributes getColumnAttributes(TPrimitiveTypeEntry primitiveTypeEntry) {
        JdbcColumnAttributes ret = null;
        if (primitiveTypeEntry.isSetTypeQualifiers()) {
            TTypeQualifiers tq = primitiveTypeEntry.getTypeQualifiers();
            switch (primitiveTypeEntry.getType()) {
                case CHAR_TYPE: 
                case VARCHAR_TYPE: {
                    TTypeQualifierValue val = (TTypeQualifierValue)tq.getQualifiers().get("characterMaximumLength");
                    if (val == null) break;
                    ret = new JdbcColumnAttributes(val.getI32Value(), 0);
                    break;
                }
                case DECIMAL_TYPE: {
                    TTypeQualifierValue prec = (TTypeQualifierValue)tq.getQualifiers().get("precision");
                    TTypeQualifierValue scale = (TTypeQualifierValue)tq.getQualifiers().get("scale");
                    ret = new JdbcColumnAttributes(prec == null ? 10 : prec.getI32Value(), scale == null ? 0 : scale.getI32Value());
                    break;
                }
                case TIMESTAMP_TYPE: {
                    TTypeQualifierValue timeZone = (TTypeQualifierValue)tq.getQualifiers().get("session.timeZone");
                    ret = new JdbcColumnAttributes(timeZone == null ? "" : timeZone.getStringValue());
                    break;
                }
            }
        }
        return ret;
    }

    private void retrieveSchema() throws SQLException {
        try {
            TGetResultSetMetadataReq metadataReq = new TGetResultSetMetadataReq(this.stmtHandle);
            TGetResultSetMetadataResp metadataResp = this.client.GetResultSetMetadata(metadataReq);
            Utils.verifySuccess(metadataResp.getStatus());
            TTableSchema schema = metadataResp.getSchema();
            if (schema == null || !schema.isSetColumns()) {
                return;
            }
            this.setSchema(schema);
            List columns = schema.getColumns();
            for (int pos = 0; pos < schema.getColumnsSize(); ++pos) {
                String columnName = ((TColumnDesc)columns.get(pos)).getColumnName();
                this.columnNames.add(columnName);
                this.normalizedColumnNames.add(columnName.toLowerCase());
                TPrimitiveTypeEntry primitiveTypeEntry = ((TTypeEntry)((TColumnDesc)columns.get(pos)).getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
                this.columnTypes.add(primitiveTypeEntry.getType());
                this.columnAttributes.add(KyuubiArrowQueryResultSet.getColumnAttributes(primitiveTypeEntry));
            }
            this.arrowSchema = ArrowUtils.toArrowSchema(this.columnNames, this.convertToStringType(this.columnTypes), this.columnAttributes);
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new KyuubiSQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
    }

    private void setSchema(List<String> colNames, List<TTypeId> colTypes, List<JdbcColumnAttributes> colAttributes) {
        this.columnNames.addAll(colNames);
        this.columnTypes.addAll(colTypes);
        this.columnAttributes.addAll(colAttributes);
        for (String colName : colNames) {
            this.normalizedColumnNames.add(colName.toLowerCase());
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.statement != null && this.statement instanceof KyuubiStatement) {
            KyuubiStatement s = (KyuubiStatement)this.statement;
            s.closeClientOperation();
        } else {
            this.closeOperationHandle(this.stmtHandle);
        }
        this.client = null;
        this.stmtHandle = null;
        this.sessHandle = null;
        this.isClosed = true;
    }

    private void closeOperationHandle(TOperationHandle stmtHandle) throws SQLException {
        try {
            if (stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq(stmtHandle);
                TCloseOperationResp closeResp = this.client.CloseOperation(closeReq);
                Utils.verifySuccessWithInfo(closeResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KyuubiSQLException(e.toString(), "08S01", e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        if (this.emptyResultSet || this.maxRows > 0 && this.rowsFetched >= this.maxRows) {
            return false;
        }
        if (this.statement != null && this.statement instanceof KyuubiStatement) {
            ((KyuubiStatement)this.statement).waitForOperationToComplete();
        }
        try {
            TFetchOrientation orientation = TFetchOrientation.FETCH_NEXT;
            if (this.fetchFirst) {
                orientation = TFetchOrientation.FETCH_FIRST;
                this.fetchedRowsItr = null;
                this.fetchFirst = false;
            }
            if (this.fetchedRowsItr == null || !this.fetchedRowsItr.hasNext()) {
                TFetchResultsReq fetchReq = new TFetchResultsReq(this.stmtHandle, orientation, (long)this.fetchSize);
                TFetchResultsResp fetchResp = this.client.FetchResults(fetchReq);
                Utils.verifySuccessWithInfo(fetchResp.getStatus());
                TRowSet results = fetchResp.getResults();
                if (results == null || results.getColumnsSize() == 0) {
                    return false;
                }
                TColumn arrowColumn = (TColumn)results.getColumns().get(0);
                byte[] batchBytes = ((ByteBuffer)arrowColumn.getBinaryVal().getValues().get(0)).array();
                ArrowRecordBatch recordBatch = this.loadArrowBatch(batchBytes, this.allocator);
                VectorLoader vectorLoader = new VectorLoader(this.root);
                vectorLoader.load(recordBatch);
                recordBatch.close();
                List<ArrowColumnVector> columns = this.root.getFieldVectors().stream().map(vector -> new ArrowColumnVector((ValueVector)vector)).collect(Collectors.toList());
                ArrowColumnarBatch batch = new ArrowColumnarBatch(columns.toArray(new ArrowColumnVector[0]), this.root.getRowCount());
                this.fetchedRowsItr = batch.rowIterator();
            }
            if (!this.fetchedRowsItr.hasNext()) {
                return false;
            }
            this.row = this.fetchedRowsItr.next();
            ++this.rowsFetched;
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new KyuubiSQLException("Error retrieving next row", ex);
        }
        return true;
    }

    private ArrowRecordBatch loadArrowBatch(byte[] batchBytes, BufferAllocator allocator) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(batchBytes);
        return MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel(Channels.newChannel(in)), (BufferAllocator)allocator);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        return super.getMetaData();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        if (this.isScrollable) {
            return 1004;
        }
        return 1003;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        return this.fetchSize;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        if (!this.isScrollable) {
            throw new KyuubiSQLException("Method not supported for TYPE_FORWARD_ONLY resultset");
        }
        this.fetchFirst = true;
        this.rowsFetched = 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Resultset is closed");
        }
        return this.rowsFetched == 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowsFetched;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private List<TTypeId> convertToStringType(List<TTypeId> colTypes) {
        return colTypes.stream().map(type -> {
            if (type == TTypeId.ARRAY_TYPE || type == TTypeId.MAP_TYPE || type == TTypeId.STRUCT_TYPE || type == TTypeId.TIMESTAMP_TYPE && this.timestampAsString) {
                return TTypeId.STRING_TYPE;
            }
            return type;
        }).collect(Collectors.toList());
    }

    public static class Builder {
        private final Connection connection;
        private final Statement statement;
        private TCLIService.Iface client = null;
        private TOperationHandle stmtHandle = null;
        private TSessionHandle sessHandle = null;
        private int maxRows = 0;
        private boolean retrieveSchema = true;
        private List<String> colNames;
        private List<TTypeId> colTypes;
        private List<JdbcColumnAttributes> colAttributes;
        private int fetchSize = 50;
        private boolean emptyResultSet = false;
        private boolean isScrollable = false;
        private ReentrantLock transportLock = null;
        private boolean timestampAsString = true;

        public Builder(Statement statement) throws SQLException {
            this.statement = statement;
            this.connection = statement.getConnection();
        }

        public Builder(Connection connection) {
            this.statement = null;
            this.connection = connection;
        }

        public Builder setClient(TCLIService.Iface client) {
            this.client = client;
            return this;
        }

        public Builder setStmtHandle(TOperationHandle stmtHandle) {
            this.stmtHandle = stmtHandle;
            return this;
        }

        public Builder setSessionHandle(TSessionHandle sessHandle) {
            this.sessHandle = sessHandle;
            return this;
        }

        public Builder setMaxRows(int maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder setSchema(List<String> colNames, List<TTypeId> colTypes) {
            ArrayList<JdbcColumnAttributes> colAttributes = new ArrayList<JdbcColumnAttributes>();
            for (int idx = 0; idx < colTypes.size(); ++idx) {
                colAttributes.add(null);
            }
            return this.setSchema(colNames, colTypes, colAttributes);
        }

        public Builder setSchema(List<String> colNames, List<TTypeId> colTypes, List<JdbcColumnAttributes> colAttributes) {
            this.colNames = new ArrayList<String>();
            this.colNames.addAll(colNames);
            this.colTypes = new ArrayList<TTypeId>();
            this.colTypes.addAll(colTypes);
            this.colAttributes = new ArrayList<JdbcColumnAttributes>();
            this.colAttributes.addAll(colAttributes);
            this.retrieveSchema = false;
            return this;
        }

        public Builder setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder setEmptyResultSet(boolean emptyResultSet) {
            this.emptyResultSet = emptyResultSet;
            return this;
        }

        public Builder setScrollable(boolean setScrollable) {
            this.isScrollable = setScrollable;
            return this;
        }

        public Builder setTimestampAsString(boolean timestampAsString) {
            this.timestampAsString = timestampAsString;
            return this;
        }

        public Builder setTransportLock(ReentrantLock transportLock) {
            this.transportLock = transportLock;
            return this;
        }

        public KyuubiArrowQueryResultSet build() throws SQLException {
            return new KyuubiArrowQueryResultSet(this);
        }

        public TProtocolVersion getProtocolVersion() throws SQLException {
            return ((KyuubiConnection)this.connection).getProtocol();
        }
    }
}

