/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Set;
import javax.security.sasl.AuthenticationException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.ws.rs.core.NewCookie;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.util.CookieSigner;
import org.apache.kyuubi.server.http.util.HttpAuthUtils$;
import org.apache.kyuubi.server.http.util.SessionManager$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory;
import org.apache.kyuubi.shaded.thrift.TProcessor;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.shaded.thrift.server.TServlet;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u00193\u0001uB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011\u00159\u0007\u0001\"\u0001i\u0011%y\u0007\u00011AA\u0002\u0013%\u0001\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"Q\u00111\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B9\t\u0013\u0005\u0015\u0001A1A\u0005\u0002\u0005\u001d\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\b\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0002\"CA\u001c\u0001\u0001\u0007I\u0011BA\u001d\u0011!\ti\u0004\u0001Q!\n\u0005E\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003B1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA\"\u0011-\ty\u0006\u0001a\u0001\u0002\u0004%I!!\u0011\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003O\u0002\u0001\u0019!A!B\u0013\t\u0019\u0005C\u0005\u0002j\u0001\u0001\r\u0011\"\u0003\u0002l!I\u00111\u000f\u0001A\u0002\u0013%\u0011Q\u000f\u0005\t\u0003s\u0002\u0001\u0015)\u0003\u0002n!I\u00111\u0010\u0001A\u0002\u0013%\u0011q\u0006\u0005\n\u0003{\u0002\u0001\u0019!C\u0005\u0003\u007fB\u0001\"a!\u0001A\u0003&\u0011\u0011\u0007\u0005\n\u0003\u000b\u0003\u0001\u0019!C\u0005\u0003_A\u0011\"a\"\u0001\u0001\u0004%I!!#\t\u0011\u00055\u0005\u0001)Q\u0005\u0003cA\u0011\"a$\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0013A\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003/C\u0011\"a)\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003\u0013A\u0011\"a*\u0001\u0005\u0004%I!!+\t\u0011\u0005m\u0006\u0001)A\u0005\u0003WCq!!0\u0001\t\u0003\ny\fC\u0004\u0002B\u0002!\t%a1\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!9!q\u000b\u0001\u0005\n\te\u0003b\u0002B/\u0001\u0011%!q\f\u0005\b\u0005G\u0002A\u0011\u0002B3\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003CqAa\"\u0001\t\u0013\u0011I\tC\u0004\u0003\u0010\u0002!IA!%\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\n\tB\u000b\u001b:jMRDE\u000f\u001e9TKJ4H.\u001a;\u000b\u0005M\"\u0014\u0001\u00025uiBT!!\u000e\u001c\u0002\rM,'O^3s\u0015\t9\u0004(\u0001\u0004lsV,(-\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qt\t\u0005\u0002@\u000b6\t\u0001I\u0003\u00026\u0003*\u0011!iQ\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005\u00113\u0014AB:iC\u0012,G-\u0003\u0002G\u0001\nAAkU3sm2,G\u000f\u0005\u0002I\u00136\ta'\u0003\u0002Km\t9Aj\\4hS:<\u0017!\u00039s_\u000e,7o]8s!\tie*D\u0001B\u0013\ty\u0015I\u0001\u0006U!J|7-Z:t_J\fq\u0002\u001d:pi>\u001cw\u000e\u001c$bGR|'/\u001f\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0006\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003-N\u0013\u0001\u0003\u0016)s_R|7m\u001c7GC\u000e$xN]=\u0002\u0017\u0005,H\u000f\u001b$bGR|'/\u001f\t\u00033zk\u0011A\u0017\u0006\u00037r\u000ba\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002^m\u000591/\u001a:wS\u000e,\u0017BA0[\u0005mY\u00150^;cS\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b7\r^8ss\u0006!1m\u001c8g!\t\u0011W-D\u0001d\u0015\t!g'\u0001\u0004d_:4\u0017nZ\u0005\u0003M\u000e\u0014!bS=vk\nL7i\u001c8g\u0003\u0019a\u0014N\\5u}Q)\u0011n\u001b7n]B\u0011!\u000eA\u0007\u0002e!)1*\u0002a\u0001\u0019\")\u0001+\u0002a\u0001#\")q+\u0002a\u00011\")\u0001-\u0002a\u0001C\u000611/[4oKJ,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iJ\nA!\u001e;jY&\u0011ao\u001d\u0002\r\u0007>|7.[3TS\u001etWM]\u0001\u000bg&<g.\u001a:`I\u0015\fHCA=\u0000!\tQX0D\u0001|\u0015\u0005a\u0018!B:dC2\f\u0017B\u0001@|\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005q!!AA\u0002E\f1\u0001\u001f\u00132\u0003\u001d\u0019\u0018n\u001a8fe\u0002\n1\"Q+U\u0011~\u001bujT&J\u000bV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006LA!a\u0006\u0002\u000e\t11\u000b\u001e:j]\u001e\fA\"Q+U\u0011~\u001bujT&J\u000b\u0002\n1AU!O+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\u0011\t)#!\u0005\u0002\u0011M,7-\u001e:jifLA!!\u000b\u0002$\ta1+Z2ve\u0016\u0014\u0016M\u001c3p[\u0006!!+\u0011(!\u0003MI7oQ8pW&,\u0017)\u001e;i\u000b:\f'\r\\3e+\t\t\t\u0004E\u0002{\u0003gI1!!\u000e|\u0005\u001d\u0011un\u001c7fC:\fq#[:D_>\\\u0017.Z!vi\",e.\u00192mK\u0012|F%Z9\u0015\u0007e\fY\u0004C\u0005\u0002\u00029\t\t\u00111\u0001\u00022\u0005!\u0012n]\"p_.LW-Q;uQ\u0016s\u0017M\u00197fI\u0002\nAbY8pW&,Gi\\7bS:,\"!a\u0011\u0011\t\u0005\u0015\u00131\u000b\b\u0005\u0003\u000f\ny\u0005E\u0002\u0002Jml!!a\u0013\u000b\u0007\u00055C(\u0001\u0004=e>|GOP\u0005\u0004\u0003#Z\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005U#bAA)w\u0006\u00012m\\8lS\u0016$u.\\1j]~#S-\u001d\u000b\u0004s\u0006m\u0003\"CA\u0001#\u0005\u0005\t\u0019AA\"\u00035\u0019wn\\6jK\u0012{W.Y5oA\u0005Q1m\\8lS\u0016\u0004\u0016\r\u001e5\u0002\u001d\r|wn[5f!\u0006$\bn\u0018\u0013fcR\u0019\u00110!\u001a\t\u0013\u0005\u0005A#!AA\u0002\u0005\r\u0013aC2p_.LW\rU1uQ\u0002\nAbY8pW&,W*\u0019=BO\u0016,\"!!\u001c\u0011\u0007i\fy'C\u0002\u0002rm\u00141!\u00138u\u0003A\u0019wn\\6jK6\u000b\u00070Q4f?\u0012*\u0017\u000fF\u0002z\u0003oB\u0011\"!\u0001\u0018\u0003\u0003\u0005\r!!\u001c\u0002\u001b\r|wn[5f\u001b\u0006D\u0018iZ3!\u00039I7oQ8pW&,7+Z2ve\u0016\f!#[:D_>\\\u0017.Z*fGV\u0014Xm\u0018\u0013fcR\u0019\u00110!!\t\u0013\u0005\u0005!$!AA\u0002\u0005E\u0012aD5t\u0007>|7.[3TK\u000e,(/\u001a\u0011\u0002!%\u001c\b\n\u001e;q\u001f:d\u0017pQ8pW&,\u0017\u0001F5t\u0011R$\bo\u00148ms\u000e{wn[5f?\u0012*\u0017\u000fF\u0002z\u0003\u0017C\u0011\"!\u0001\u001e\u0003\u0003\u0005\r!!\r\u0002#%\u001c\b\n\u001e;q\u001f:d\u0017pQ8pW&,\u0007%\u0001\fY?\u001a{%kV!S\t\u0016#uLR(S?\"+\u0015\tR#S\u0003]AvLR(S/\u0006\u0013F)\u0012#`\r>\u0013v\fS#B\t\u0016\u0013\u0006%\u0001\u000bbkRDWM\u001c;jG\u0006$\u0018n\u001c8GS2$XM]\u000b\u0003\u0003/\u0003B!!'\u0002\u001e6\u0011\u00111\u0014\u0006\u00037JJA!a(\u0002\u001c\n!\u0012)\u001e;iK:$\u0018nY1uS>tg)\u001b7uKJ\fQ#Y;uQ\u0016tG/[2bi&|gNR5mi\u0016\u0014\b%A\nY'J3u\fS#B\t\u0016\u0013v\fR#G\u0003VcE+\u0001\u000bY'J3u\fS#B\t\u0016\u0013v\fR#G\u0003VcE\u000bI\u0001\u001f1N\u0013fiX'F)\"{EiU0U\u001f~KuIT(S\u000b~#UIR!V\u0019R+\"!a+\u0011\r\u00055\u0016qWA\u0005\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016!C5n[V$\u0018M\u00197f\u0015\r\t)l_\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA]\u0003_\u00131aU3u\u0003}A6K\u0015$`\u001b\u0016#\u0006j\u0014#T?R{u,S$O\u001fJ+u\fR#G\u0003VcE\u000bI\u0001\u0005S:LG\u000fF\u0001z\u0003\u0019!w\u000eU8tiR)\u00110!2\u0002\\\"9\u0011q\u0019\u0015A\u0002\u0005%\u0017a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0017\f9.\u0004\u0002\u0002N*\u00191'a4\u000b\t\u0005E\u00171[\u0001\bg\u0016\u0014h\u000f\\3u\u0015\t\t).A\u0003kCZ\f\u00070\u0003\u0003\u0002Z\u00065'A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRDq!!8)\u0001\u0004\ty.\u0001\u0005sKN\u0004xN\\:f!\u0011\tY-!9\n\t\u0005\r\u0018Q\u001a\u0002\u0014\u0011R$\boU3sm2,GOU3ta>t7/\u001a\u0015\u0006Q\u0005\u001d\u0018\u0011 \t\u0006u\u0006%\u0018Q^\u0005\u0004\u0003W\\(A\u0002;ie><8\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\u0011\t\u00190!\u0005\u0002\u0005%|\u0017\u0002BA|\u0003c\u00141\"S(Fq\u000e,\u0007\u000f^5p]F:a$a\u0011\u0002|\n-\u0012'C\u0012\u0002~\n\r!\u0011\u0005B\u0003+\u0011\t\t%a@\u0005\u000f\t\u0005AH1\u0001\u0003\f\t\tA+\u0003\u0003\u0003\u0006\t\u001d\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0003\nm\fa\u0001\u001e5s_^\u001c\u0018\u0003\u0002B\u0007\u0005'\u00012A\u001fB\b\u0013\r\u0011\tb\u001f\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011)Ba\u0007\u000f\u0007i\u00149\"C\u0002\u0003\u001am\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001e\t}!!\u0003+ie><\u0018M\u00197f\u0015\r\u0011Ib_\u0019\nG\t\r\"Q\u0005B\u0014\u0005\u0013q1A\u001fB\u0013\u0013\r\u0011Ia_\u0019\u0006Ei\\(\u0011\u0006\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u00055\b&\u0002\u0015\u00030\te\u0002#\u0002>\u0002j\nE\u0002\u0003\u0002B\u001a\u0005ki!!a4\n\t\t]\u0012q\u001a\u0002\u0011'\u0016\u0014h\u000f\\3u\u000bb\u001cW\r\u001d;j_:\ftAHA\"\u0005w\u0011\t%M\u0005$\u0003{\u0014\u0019A!\u0010\u0003\u0006EJ1Ea\t\u0003&\t}\"\u0011B\u0019\u0006Ei\\(\u0011F\u0019\u0004M\tE\u0012aF4fi\u000ec\u0017.\u001a8u\u001d\u0006lWM\u0012:p[\u000e{wn[5f)\u0011\t\u0019Ea\u0012\t\u000f\t%\u0013\u00061\u0001\u0003L\u000591m\\8lS\u0016\u001c\b#\u0002>\u0003N\tE\u0013b\u0001B(w\n)\u0011I\u001d:bsB!\u00111\u001aB*\u0013\u0011\u0011)&!4\u0003\r\r{wn[5f\u0003-!xnQ8pW&,7\u000b\u001e:\u0015\t\u0005%!1\f\u0005\b\u0005\u0013R\u0003\u0019\u0001B&\u000391\u0018\r\\5eCR,7i\\8lS\u0016$B!a\u0011\u0003b!9\u0011qY\u0016A\u0002\u0005%\u0017\u0001D2sK\u0006$XmQ8pW&,G\u0003\u0002B)\u0005OBqA!\u001b-\u0001\u0004\t\u0019%A\u0002tiJDS\u0001\fB7\u0005k\u0002RA_Au\u0005_\u0002B!a<\u0003r%!!1OAy\u0005q)fn];qa>\u0014H/\u001a3F]\u000e|G-\u001b8h\u000bb\u001cW\r\u001d;j_:\ftAHA\"\u0005o\u0012i(M\u0005$\u0003{\u0014\u0019A!\u001f\u0003\u0006EJ1Ea\t\u0003&\tm$\u0011B\u0019\u0006Ei\\(\u0011F\u0019\u0004M\t=\u0014aF4fi\"#H\u000f](oYf\u001cun\\6jK\"+\u0017\rZ3s)\u0011\t\u0019Ea!\t\u000f\t\u0015U\u00061\u0001\u0003R\u000511m\\8lS\u0016\fA\"Y;uQ\u0016tG/[2bi\u0016$b!a\u0011\u0003\f\n5\u0005bBAd]\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003;t\u0003\u0019AAp\u0003E9W\r\u001e#p\u0003N\fV/\u001a:z!\u0006\u0014\u0018-\u001c\u000b\u0005\u0003\u0007\u0012\u0019\nC\u0004\u0003\u0016>\u0002\r!a\u0011\u0002\u0017E,XM]=TiJLgnZ\u0001\rI>D6O\u001d4GS2$XM\u001d\u000b\u0007\u0003c\u0011YJa(\t\u000f\tu\u0005\u00071\u0001\u0002J\u0006Y\u0001\u000e\u001e;q%\u0016\fX/Z:u\u0011\u001d\ti\u000e\ra\u0001\u0003?\u0004")
public class ThriftHttpServlet
extends TServlet
implements Logging {
    private final KyuubiAuthenticationFactory authFactory;
    private final KyuubiConf conf;
    private CookieSigner signer;
    private final String AUTH_COOKIE;
    private final SecureRandom RAN;
    private boolean isCookieAuthEnabled;
    private String cookieDomain;
    private String cookiePath;
    private int cookieMaxAge;
    private boolean isCookieSecure;
    private boolean isHttpOnlyCookie;
    private final String X_FORWARDED_FOR_HEADER;
    private final AuthenticationFilter authenticationFilter;
    private final String XSRF_HEADER_DEFAULT;
    private final scala.collection.immutable.Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private CookieSigner signer() {
        return this.signer;
    }

    private void signer_$eq(CookieSigner x$1) {
        this.signer = x$1;
    }

    public String AUTH_COOKIE() {
        return this.AUTH_COOKIE;
    }

    private SecureRandom RAN() {
        return this.RAN;
    }

    private boolean isCookieAuthEnabled() {
        return this.isCookieAuthEnabled;
    }

    private void isCookieAuthEnabled_$eq(boolean x$1) {
        this.isCookieAuthEnabled = x$1;
    }

    private String cookieDomain() {
        return this.cookieDomain;
    }

    private void cookieDomain_$eq(String x$1) {
        this.cookieDomain = x$1;
    }

    private String cookiePath() {
        return this.cookiePath;
    }

    private void cookiePath_$eq(String x$1) {
        this.cookiePath = x$1;
    }

    private int cookieMaxAge() {
        return this.cookieMaxAge;
    }

    private void cookieMaxAge_$eq(int x$1) {
        this.cookieMaxAge = x$1;
    }

    private boolean isCookieSecure() {
        return this.isCookieSecure;
    }

    private void isCookieSecure_$eq(boolean x$1) {
        this.isCookieSecure = x$1;
    }

    private boolean isHttpOnlyCookie() {
        return this.isHttpOnlyCookie;
    }

    private void isHttpOnlyCookie_$eq(boolean x$1) {
        this.isHttpOnlyCookie = x$1;
    }

    private String X_FORWARDED_FOR_HEADER() {
        return this.X_FORWARDED_FOR_HEADER;
    }

    private AuthenticationFilter authenticationFilter() {
        return this.authenticationFilter;
    }

    private String XSRF_HEADER_DEFAULT() {
        return this.XSRF_HEADER_DEFAULT;
    }

    private scala.collection.immutable.Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT() {
        return this.XSRF_METHODS_TO_IGNORE_DEFAULT;
    }

    public void init() {
        this.isCookieAuthEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_AUTH_ENABLED())));
        if (this.isCookieAuthEnabled()) {
            String secret = Long.toString(this.RAN().nextLong());
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Using the random number as the secret for cookie generation ").append(secret).toString());
            this.signer_$eq(new CookieSigner(secret.getBytes()));
            this.cookieMaxAge_$eq(BoxesRunTime.unboxToInt((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_MAX_AGE())));
            this.cookieDomain_$eq((String)((Option)this.conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_DOMAIN())).orNull(Predef$.MODULE$.$conforms()));
            this.cookiePath_$eq((String)((Option)this.conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_PATH())).orNull(Predef$.MODULE$.$conforms()));
            this.isCookieSecure_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_USE_SSL())));
            this.isHttpOnlyCookie_$eq(BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COOKIE_IS_HTTPONLY())));
        }
        this.authenticationFilter().initAuthHandlers();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block18: {
            block17: {
                ObjectRef clientUserName = ObjectRef.create(null);
                boolean requireNewCookie = false;
                try {
                    try {
                        boolean continueProcessing;
                        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_XSRF_FILTER_ENABLED())) && !(continueProcessing = this.doXsrfFilter(request, response))) {
                            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Request did not have valid XSRF header, rejecting.");
                            break block17;
                        }
                        if (this.isCookieAuthEnabled()) {
                            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Cookie Auth Enabled");
                            clientUserName.elem = this.validateCookie(request);
                            boolean bl = requireNewCookie = (String)clientUserName.elem == null;
                            if (requireNewCookie) {
                                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Could not validate cookie sent, will try to generate a new cookie");
                            } else {
                                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Got userName From Cookie: ").append((String)clientUserName$1.elem).toString());
                            }
                        }
                        if ((String)clientUserName.elem == null) {
                            clientUserName.elem = this.authenticate(request, response);
                        }
                        Predef$.MODULE$.require((String)clientUserName.elem != null, (Function0 & Serializable & scala.Serializable)() -> "No valid authorization provided");
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("Client username: ").append((String)clientUserName$1.elem).toString());
                        SessionManager$.MODULE$.setUserName((String)clientUserName.elem);
                        String doAsQueryParam = this.getDoAsQueryParam(request.getQueryString());
                        if (doAsQueryParam != null) {
                            SessionManager$.MODULE$.setProxyUserName(doAsQueryParam);
                        }
                        String clientIpAddress = request.getRemoteAddr();
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Client IP Address: ").append(clientIpAddress).toString());
                        SessionManager$.MODULE$.setIpAddress(clientIpAddress);
                        Option$.MODULE$.apply((Object)request.getHeader((String)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_PROXY_HTTP_CLIENT_IP_HEADER()))).foreach((Function1 & Serializable & scala.Serializable)ipAddress -> {
                            ThriftHttpServlet.$anonfun$doPost$8(this, ipAddress);
                            return BoxedUnit.UNIT;
                        });
                        String forwarded_for = request.getHeader(this.X_FORWARDED_FOR_HEADER());
                        if (forwarded_for != null) {
                            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append(this.X_FORWARDED_FOR_HEADER()).append(":").append(forwarded_for).toString());
                            List forwardedAddresses = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])forwarded_for.split(","))).toList();
                            SessionManager$.MODULE$.setForwardedAddresses((List<String>)forwardedAddresses);
                        } else {
                            SessionManager$.MODULE$.setForwardedAddresses((List<String>)List$.MODULE$.empty());
                        }
                        if (requireNewCookie && !this.authFactory.saslDisabled()) {
                            String cookieToken = HttpAuthUtils$.MODULE$.createCookieToken((String)clientUserName.elem);
                            Cookie hs2Cookie = this.createCookie(this.signer().signCookie(cookieToken));
                            if (this.isHttpOnlyCookie()) {
                                response.setHeader("SET-COOKIE", this.getHttpOnlyCookieHeader(hs2Cookie));
                            } else {
                                response.addCookie(hs2Cookie);
                            }
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Cookie added for clientUserName ").append((String)clientUserName$1.elem).toString());
                        }
                        super.doPost(request, response);
                        break block18;
                    }
                    catch (AuthenticationException e) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error: ", e);
                        response.setStatus(401);
                        response.getWriter().println(new java.lang.StringBuilder(22).append("Authentication Error: ").append(e.getMessage()).toString());
                        break block18;
                    }
                    catch (Throwable e) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error: ", e);
                        throw e;
                    }
                }
                finally {
                    SessionManager$.MODULE$.clearUserName();
                    SessionManager$.MODULE$.clearIpAddress();
                    SessionManager$.MODULE$.clearProxyHttpHeaderIpAddress();
                    SessionManager$.MODULE$.clearProxyUserName();
                    SessionManager$.MODULE$.clearForwardedAddresses();
                }
            }
            return;
        }
    }

    private String getClientNameFromCookie(Cookie[] cookies) {
        String string;
        Object object = new Object();
        try {
            ObjectRef currName = ObjectRef.create(null);
            ObjectRef currValue = ObjectRef.create(null);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).foreach((Function1 & Serializable & scala.Serializable)currCookie -> {
                ThriftHttpServlet.$anonfun$getClientNameFromCookie$1(this, currName, currValue, object, currCookie);
                return BoxedUnit.UNIT;
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    private String toCookieStr(Cookie[] cookies) {
        StringBuilder cookieStr = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).foreach((Function1 & Serializable & scala.Serializable)c -> cookieStr.append(c.getName()).append('=').append(c.getValue()).append(" ;\n"));
        return cookieStr.toString();
    }

    private String validateCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("No valid cookies associated with the request ").append(request).toString());
            return null;
        }
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Received cookies: ").append(this.toCookieStr(cookies)).toString());
        return this.getClientNameFromCookie(cookies);
    }

    private Cookie createCookie(String str) throws UnsupportedEncodingException {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("Cookie name = ").append(this.AUTH_COOKIE()).append(" value = ").append(str).toString());
        Cookie cookie = new Cookie(this.AUTH_COOKIE(), str);
        cookie.setMaxAge(this.cookieMaxAge());
        if (this.cookieDomain() != null) {
            cookie.setDomain(this.cookieDomain());
        }
        if (this.cookiePath() != null) {
            cookie.setPath(this.cookiePath());
        }
        cookie.setSecure(this.isCookieSecure());
        return cookie;
    }

    private String getHttpOnlyCookieHeader(Cookie cookie) {
        NewCookie newCookie = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)newCookie), "; HttpOnly");
    }

    private String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String authorization = request.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        return (String)this.authenticationFilter().getMatchedHandler(authorization).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.authenticate(request, response)).orNull(Predef$.MODULE$.$conforms());
    }

    private String getDoAsQueryParam(String queryString) {
        String string;
        Object object = new Object();
        try {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("URL query string:").append(queryString).toString());
            if (queryString == null) {
                return null;
            }
            Hashtable params = HttpUtils.parseQueryString((String)queryString);
            Set keySet = params.keySet();
            keySet.forEach(key -> {
                if (key.equalsIgnoreCase("doAs")) {
                    throw new NonLocalReturnControl(object, (Object)((String[])params.get(key))[0]);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    private boolean doXsrfFilter(HttpServletRequest httpRequest, HttpServletResponse response) {
        if (this.XSRF_METHODS_TO_IGNORE_DEFAULT().contains((Object)httpRequest.getMethod()) || httpRequest.getHeader(this.XSRF_HEADER_DEFAULT()) != null) {
            return true;
        }
        response.sendError(400, "Missing Required Header for Vulnerability Protection");
        response.getWriter().println(new java.lang.StringBuilder(51).append("XSRF filter denial, requests must contain header : ").append(this.XSRF_HEADER_DEFAULT()).toString());
        return false;
    }

    public static final /* synthetic */ void $anonfun$doPost$8(ThriftHttpServlet $this, String ipAddress) {
        $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Proxy Http Header Client IP Address: ").append(ipAddress).toString());
        SessionManager$.MODULE$.setProxyHttpHeaderIpAddress(ipAddress);
    }

    public static final /* synthetic */ void $anonfun$getClientNameFromCookie$1(ThriftHttpServlet $this, ObjectRef currName$1, ObjectRef currValue$1, Object nonLocalReturnKey1$1, Cookie currCookie) {
        currName$1.elem = currCookie.getName();
        String string = (String)currName$1.elem;
        String string2 = $this.AUTH_COOKIE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            currValue$1.elem = currCookie.getValue();
            try {
                currValue$1.elem = $this.signer().verifyAndExtract((String)currValue$1.elem);
            }
            catch (IllegalArgumentException e) {
                $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("Invalid cookie").append(e.getMessage()).toString());
                currValue$1.elem = null;
            }
            if ((String)currValue$1.elem != null) {
                String userName = HttpAuthUtils$.MODULE$.getUserNameFromCookieToken((String)currValue$1.elem);
                if (userName == null) {
                    $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Invalid cookie token ").append((String)currValue$1.elem).toString());
                    return;
                }
                $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Validated the cookie for user ").append(userName).toString());
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)userName);
            }
            return;
        }
    }

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, KyuubiAuthenticationFactory authFactory, KyuubiConf conf) {
        this.authFactory = authFactory;
        this.conf = conf;
        super(processor, protocolFactory);
        Logging.$init$((Logging)this);
        this.AUTH_COOKIE = "hive.server2.auth";
        this.RAN = new SecureRandom();
        this.isCookieAuthEnabled = false;
        this.cookieMaxAge = 0;
        this.isCookieSecure = false;
        this.isHttpOnlyCookie = false;
        this.X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
        this.authenticationFilter = new AuthenticationFilter(conf);
        this.XSRF_HEADER_DEFAULT = "X-XSRF-HEADER";
        this.XSRF_METHODS_TO_IGNORE_DEFAULT = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "OPTIONS", "HEAD", "TRACE"}));
    }
}

