/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.shareddata.Counter;
import java.util.concurrent.atomic.AtomicLong;

public class AsynchronousCounter
implements Counter {
    private final VertxInternal vertx;
    private final AtomicLong counter;

    public AsynchronousCounter(VertxInternal vertx) {
        this.vertx = vertx;
        this.counter = new AtomicLong();
    }

    public AsynchronousCounter(VertxInternal vertx, AtomicLong counter) {
        this.vertx = vertx;
        this.counter = counter;
    }

    @Override
    public Future<Long> get() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.get());
        return promise.future();
    }

    @Override
    public Future<Long> incrementAndGet() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.incrementAndGet());
        return promise.future();
    }

    @Override
    public Future<Long> getAndIncrement() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.getAndIncrement());
        return promise.future();
    }

    @Override
    public Future<Long> decrementAndGet() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.decrementAndGet());
        return promise.future();
    }

    @Override
    public Future<Long> addAndGet(long value) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.addAndGet(value));
        return promise.future();
    }

    @Override
    public Future<Long> getAndAdd(long value) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Long> promise = context.promise();
        promise.complete(this.counter.getAndAdd(value));
        return promise.future();
    }

    @Override
    public Future<Boolean> compareAndSet(long expected, long value) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Boolean> promise = context.promise();
        promise.complete(this.counter.compareAndSet(expected, value));
        return promise.future();
    }
}

