/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPIngressRuleValueFluent<A extends HTTPIngressRuleValueFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HTTPIngressPathBuilder> paths = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPIngressRuleValueFluent() {
    }

    public HTTPIngressRuleValueFluent(HTTPIngressRuleValue instance) {
        HTTPIngressRuleValue hTTPIngressRuleValue = instance = instance != null ? instance : new HTTPIngressRuleValue();
        if (instance != null) {
            this.withPaths(instance.getPaths());
            this.withPaths(instance.getPaths());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPaths(int index, HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get((Object)"paths").add(index, builder);
            this.paths.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPaths(int index, HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get((Object)"paths").set(index, builder);
            this.paths.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPaths(HTTPIngressPath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPaths(Collection<HTTPIngressPath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get((Object)"paths").add(builder);
            this.paths.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPaths(HTTPIngressPath ... items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get((Object)"paths").remove((Object)builder);
            this.paths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPaths(Collection<HTTPIngressPath> items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get((Object)"paths").remove((Object)builder);
            this.paths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPaths(Predicate<HTTPIngressPathBuilder> predicate) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPIngressPathBuilder> each = this.paths.iterator();
        List visitables = this._visitables.get((Object)"paths");
        while (each.hasNext()) {
            HTTPIngressPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPIngressPath> buildPaths() {
        return this.paths != null ? HTTPIngressRuleValueFluent.build(this.paths) : null;
    }

    public HTTPIngressPath buildPath(int index) {
        return this.paths.get(index).build();
    }

    public HTTPIngressPath buildFirstPath() {
        return this.paths.get(0).build();
    }

    public HTTPIngressPath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    public HTTPIngressPath buildMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        for (HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        for (HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPaths(List<HTTPIngressPath> paths) {
        if (this.paths != null) {
            this._visitables.get((Object)"paths").clear();
        }
        if (paths != null) {
            this.paths = new ArrayList();
            for (HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)((Object)this);
    }

    public A withPaths(HTTPIngressPath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove((Object)"paths");
        }
        if (paths != null) {
            for (HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    public PathsNested<A> addNewPath() {
        return new PathsNested(-1, null);
    }

    public PathsNested<A> addNewPathLike(HTTPIngressPath item) {
        return new PathsNested(-1, item);
    }

    public PathsNested<A> setNewPathLike(int index, HTTPIngressPath item) {
        return new PathsNested(index, item);
    }

    public PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    public PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public PathsNested<A> editMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.test(this.paths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressRuleValueFluent that = (HTTPIngressRuleValueFluent)((Object)o);
        if (!Objects.equals(this.paths, that.paths)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PathsNested<N>
    extends HTTPIngressPathFluent<PathsNested<N>>
    implements Nested<N> {
        HTTPIngressPathBuilder builder;
        int index;

        PathsNested(int index, HTTPIngressPath item) {
            this.index = index;
            this.builder = new HTTPIngressPathBuilder(this, item);
        }

        public N and() {
            return (N)HTTPIngressRuleValueFluent.this.setToPaths(this.index, this.builder.build());
        }

        public N endPath() {
            return this.and();
        }
    }
}

