/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;

public final class ObservableDelay<T>
extends AbstractObservableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public ObservableDelay(ObservableSource<T> source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        Observer<? super T> s = this.delayError ? t : new SerializedObserver<T>(t);
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelayObserver<T>(s, this.delay, this.unit, w, this.delayError));
    }

    static final class DelayObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Disposable s;

        DelayObserver(Observer<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w, boolean delayError) {
            this.actual = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(final T t) {
            this.w.schedule(new Runnable(){

                @Override
                public void run() {
                    DelayObserver.this.actual.onNext(t);
                }
            }, this.delay, this.unit);
        }

        @Override
        public void onError(final Throwable t) {
            this.w.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DelayObserver.this.actual.onError(t);
                    }
                    finally {
                        DelayObserver.this.w.dispose();
                    }
                }
            }, this.delayError ? this.delay : 0L, this.unit);
        }

        @Override
        public void onComplete() {
            this.w.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DelayObserver.this.actual.onComplete();
                    }
                    finally {
                        DelayObserver.this.w.dispose();
                    }
                }
            }, this.delay, this.unit);
        }

        @Override
        public void dispose() {
            this.w.dispose();
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }
    }
}

