/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.kyuubi.Utils$;
import org.apache.spark.SparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class KyuubiSparkUtil$ {
    public static KyuubiSparkUtil$ MODULE$;
    private String diagnostics;
    private Tuple2<Object, Object> sparkMajorMinorVersion;
    private volatile byte bitmap$0;

    static {
        new KyuubiSparkUtil$();
    }

    public final String SPARK_SCHEDULER_POOL_KEY() {
        return "spark.scheduler.pool";
    }

    public final String SPARK_SQL_EXECUTION_ID_KEY() {
        return "spark.sql.execution.id";
    }

    public SparkContext globalSparkContext() {
        return SparkSession$.MODULE$.active().sparkContext();
    }

    public String engineId() {
        return this.globalSparkContext().applicationId();
    }

    private String diagnostics$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                SparkContext sc = this.globalSparkContext();
                String webUrl = (String)sc.getConf().getOption("spark.org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter.param.PROXY_URI_BASES").orElse((Function0 & java.io.Serializable & Serializable)() -> sc.uiWebUrl()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
                this.diagnostics = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n       |           Spark application name: ").append(sc.appName()).append("\n       |                 application ID: ").append(this.engineId()).append("\n       |                 application web UI: ").append(webUrl).append("\n       |                 master: ").append(sc.master()).append("\n       |                 deploy mode: ").append(sc.deployMode()).append("\n       |                 version: ").append(sc.version()).append("\n       |           Start time: ").append(LocalDateTime.ofInstant(Instant.ofEpochMilli(sc.startTime()), ZoneId.systemDefault())).append("\n       |           User: ").append(sc.sparkUser()).toString())).stripMargin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.diagnostics;
    }

    public String diagnostics() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.diagnostics$lzycompute() : this.diagnostics;
    }

    public boolean hiveClassesArePresent() {
        boolean bl;
        try {
            Class.forName("org.apache.spark.sql.hive.HiveSessionStateBuilder");
            Class.forName("org.apache.hadoop.hive.conf.HiveConf");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    private Tuple2<Object, Object> sparkMajorMinorVersion$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String runtimeSparkVer = package$.MODULE$.SPARK_VERSION();
                this.sparkMajorMinorVersion = Utils$.MODULE$.majorMinorVersion(runtimeSparkVer);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkMajorMinorVersion;
    }

    public Tuple2<Object, Object> sparkMajorMinorVersion() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkMajorMinorVersion$lzycompute() : this.sparkMajorMinorVersion;
    }

    private KyuubiSparkUtil$() {
        MODULE$ = this;
    }
}

