/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client.masks;

import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client.masks.Masker;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketFrame;

public class RandomMasker
implements Masker {
    private final Random random;

    public RandomMasker() {
        this(new SecureRandom());
    }

    public RandomMasker(Random random) {
        Objects.requireNonNull(random);
        this.random = random;
    }

    @Override
    public void setMask(WebSocketFrame frame) {
        byte[] mask = new byte[4];
        this.random.nextBytes(mask);
        frame.setMask(mask);
    }
}

