/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine;
import org.apache.kyuubi.engine.spark.events.EngineEvent;
import org.apache.kyuubi.engine.spark.events.EngineEvent$;
import org.apache.kyuubi.engine.spark.events.EngineEventsStore;
import org.apache.kyuubi.engine.spark.events.EventLoggingService;
import org.apache.kyuubi.engine.spark.events.EventLoggingService$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.util.SignalRegister$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.ui.EngineTab;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SparkSQLEngine$
implements Logging,
scala.Serializable {
    public static SparkSQLEngine$ MODULE$;
    private final KyuubiConf kyuubiConf;
    private Option<SparkSQLEngine> currentEngine;
    private final String user;
    private final CountDownLatch org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new SparkSQLEngine$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public Option<SparkSQLEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<SparkSQLEngine> x$1) {
        this.currentEngine = x$1;
    }

    private String user() {
        return this.user;
    }

    public CountDownLatch org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch() {
        return this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch;
    }

    public SparkSession createSpark() {
        SparkConf sparkConf = new SparkConf();
        sparkConf.setIfMissing("spark.sql.execution.topKSortFallbackThreshold", "10000");
        sparkConf.setIfMissing("spark.sql.legacy.castComplexTypesToString.enabled", "true");
        sparkConf.setIfMissing("spark.master", "local");
        sparkConf.setIfMissing("spark.ui.port", "0");
        String appName = new StringBuilder(14).append("kyuubi_").append(this.user()).append("_spark_").append(Instant.now()).toString();
        sparkConf.setIfMissing("spark.app.name", appName);
        String defaultCat = KyuubiSparkUtil$.MODULE$.hiveClassesArePresent() ? "hive" : "in-memory";
        sparkConf.setIfMissing("spark.sql.catalogImplementation", defaultCat);
        this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), BoxesRunTime.boxToInteger((int)0));
        this.kyuubiConf().setIfMissing(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY(), RetryPolicies$.MODULE$.N_TIME().toString());
        String sparkToKyuubiPrefix = "spark.kyuubi.";
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(sparkToKyuubiPrefix))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            KyuubiConf kyuubiConf = MODULE$.kyuubiConf().set(new StringBuilder(7).append("kyuubi.").append(k).toString(), v);
            return kyuubiConf;
        });
        if (this.logger().isDebugEnabled()) {
            this.kyuubiConf().getAll().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SparkSQLEngine$.$anonfun$createSpark$2(x0$2);
                return BoxedUnit.UNIT;
            });
        }
        SparkSession session = SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate();
        ((IterableLike)((TraversableLike)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_INITIALIZE_SQL())).$plus$plus((GenTraversableOnce)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_INITIALIZE_SQL()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)sqlStr -> BoxesRunTime.boxToBoolean((boolean)SparkSQLEngine$.$anonfun$createSpark$4(session, appName, sqlStr)));
        return session;
    }

    public void startEngine(SparkSession spark) {
        EngineEventsStore store = new EngineEventsStore(this.kyuubiConf());
        this.currentEngine_$eq((Option<SparkSQLEngine>)new Some((Object)new SparkSQLEngine(spark, store)));
        this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
            SparkSQLEngine$.$anonfun$startEngine$1(spark, engine);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        block9: {
            SignalRegister$.MODULE$.registerLogger(this.logger());
            SparkSession spark = null;
            try {
                try {
                    spark = this.createSpark();
                    try {
                        this.startEngine(spark);
                        this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch().await();
                    }
                    catch (KyuubiException e) {
                        Option<SparkSQLEngine> option = this.currentEngine();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            SparkSQLEngine engine = (SparkSQLEngine)some.value();
                            engine.stop();
                            EngineEvent qual$1 = EngineEvent$.MODULE$.apply(engine);
                            String x$1 = e.getMessage();
                            String x$2 = qual$1.copy$default$1();
                            Option<String> x$3 = qual$1.copy$default$2();
                            String x$4 = qual$1.copy$default$3();
                            String x$5 = qual$1.copy$default$4();
                            String x$6 = qual$1.copy$default$5();
                            String x$7 = qual$1.copy$default$6();
                            String x$8 = qual$1.copy$default$7();
                            String x$9 = qual$1.copy$default$8();
                            String x$10 = qual$1.copy$default$9();
                            long x$11 = qual$1.copy$default$10();
                            long x$12 = qual$1.copy$default$11();
                            int x$13 = qual$1.copy$default$12();
                            Map<String, String> x$14 = qual$1.copy$default$14();
                            EngineEvent event = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14);
                            EventLoggingService$.MODULE$.onEvent(event);
                            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> event, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Current SparkSQLEngine is not created.");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable t) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Failed to instantiate SparkSession: ").append(t.getMessage()).toString(), t);
                }
            }
            finally {
                if (spark != null) {
                    spark.stop();
                }
            }
        }
    }

    public SparkSQLEngine apply(SparkSession spark, EngineEventsStore store) {
        return new SparkSQLEngine(spark, store);
    }

    public Option<Tuple2<SparkSession, EngineEventsStore>> unapply(SparkSQLEngine x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.spark(), (Object)x$0.store()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$createSpark$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("KyuubiConf: ").append(k).append(" = ").append(v).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$createSpark$4(SparkSession session$1, String appName$1, String sqlStr) {
        session$1.sparkContext().setJobGroup(appName$1, sqlStr, true);
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Execute session initializing sql: ").append(sqlStr).toString());
        return session$1.sql(sqlStr).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngine$1(SparkSession spark$1, SparkSQLEngine engine) {
        EventLoggingService eventLogging = new EventLoggingService(spark$1.sparkContext());
        try {
            eventLogging.initialize(MODULE$.kyuubiConf());
            eventLogging.start();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to initialize EventLoggingService: ").append(e.getMessage()).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            engine.initialize(MODULE$.kyuubiConf());
            EventLoggingService$.MODULE$.onEvent(EngineEvent$.MODULE$.apply(engine));
        }
        catch (Throwable t) {
            throw new KyuubiException(new StringBuilder(37).append("Failed to initialize SparkSQLEngine: ").append(t.getMessage()).toString(), t);
        }
        try {
            engine.start();
            new EngineTab(engine);
            EngineEvent event = EngineEvent$.MODULE$.apply(engine);
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> event);
            EventLoggingService$.MODULE$.onEvent(event);
        }
        catch (Throwable t) {
            throw new KyuubiException(new StringBuilder(32).append("Failed to start SparkSQLEngine: ").append(t.getMessage()).toString(), t);
        }
        Utils$.MODULE$.addShutdownHook(() -> engine.stop(), Utils$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 2);
        Utils$.MODULE$.addShutdownHook(() -> eventLogging.stop(), Utils$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 1);
    }

    private SparkSQLEngine$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
        this.currentEngine = None$.MODULE$;
        this.user = Utils$.MODULE$.currentUser();
        this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch = new CountDownLatch(1);
    }
}

