/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.jdbc.connection.JdbcConnectionProvider;
import org.apache.kyuubi.util.reflect.DynClasses;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Qa\u0002\u0005\u0002\u0002UAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013EQ\u0005\u0003\u00046\u0001\u0001\u0006IA\n\u0005\u0006m\u0001!\ta\u000e\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0002\u001b\u0003\n\u001cHO]1di\u000e{gN\\3di&|g\u000e\u0015:pm&$WM\u001d\u0006\u0003\u0013)\t!bY8o]\u0016\u001cG/[8o\u0015\tYA\"\u0001\u0003kI\n\u001c'BA\u0007\u000f\u0003\u0019)gnZ5oK*\u0011q\u0002E\u0001\u0007Wf,XOY5\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"\u0001\b\n\u0005}q!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003!\t\u0011\u0002\u001d:pm&$WM]:\u0016\u0003\u0019\u00022aJ\u00183\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,)\u00051AH]8pizJ\u0011!G\u0005\u0003]a\tq\u0001]1dW\u0006<W-\u0003\u00021c\t\u00191+Z9\u000b\u00059B\u0002CA\u00124\u0013\t!\u0004B\u0001\fKI\n\u001c7i\u001c8oK\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003)\u0001(o\u001c<jI\u0016\u00148\u000fI\u0001\u000fO\u0016$HI]5wKJ\u001cE.Y:t)\tA\u0004\t\u0005\u0002:{9\u0011!h\u000f\t\u0003SaI!\u0001\u0010\r\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yaAQ!\u0011\u0003A\u0002\t\u000b!b[=vk\nL7i\u001c8g!\t\u0019e)D\u0001E\u0015\t)e\"\u0001\u0004d_:4\u0017nZ\u0005\u0003\u000f\u0012\u0013!bS=vk\nL7i\u001c8g\u0003\u0019\u0019'/Z1uKR\u0011!J\u0015\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b1a]9m\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!\u0015'\u0003\u0015\r{gN\\3di&|g\u000eC\u0003B\u000b\u0001\u0007!)A\u0007m_\u0006$\u0007K]8wS\u0012,'o\u001d\u000b\u0002M\u0001")
public abstract class AbstractConnectionProvider
implements Logging {
    private final Seq<JdbcConnectionProvider> providers;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Seq<JdbcConnectionProvider> providers() {
        return this.providers;
    }

    public String getDriverClass(KyuubiConf kyuubiConf) {
        Class driverClass = (Class)Option$.MODULE$.apply((Object)DynClasses.builder().impl((String)((Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_DRIVER_CLASS())).get()).orNull().build()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String url = (String)((Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_URL())).get();
            return DriverManager.getDriver(url).getClass();
        });
        return driverClass.getCanonicalName();
    }

    public Connection create(KyuubiConf kyuubiConf) {
        JdbcConnectionProvider jdbcConnectionProvider;
        Seq filteredProviders = (Seq)this.providers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(this.getDriverClass(kyuubiConf))));
        if (filteredProviders.isEmpty()) {
            throw new IllegalArgumentException("Empty list of JDBC connection providers for the specified driver and options");
        }
        Option connectionProviderName = (Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROVIDER());
        Option option = connectionProviderName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String providerName = (String)some.value();
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractConnectionProvider.$anonfun$create$2(providerName, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(129).append("Could not find a JDBC connection provider with name '").append(providerName).append("' ").append("that can handle the specified driver and options. ").append("Available providers are ").append(this.providers().mkString("[", ", ", "]")).toString());
            });
        } else if (None$.MODULE$.equals(option)) {
            if (filteredProviders.size() != 1) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(141).append("JDBC connection initiated but more than one connection provider was found. Use ").append(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROVIDER().key()).append(" option to select a specific provider. ").append("Found active providers ").append(filteredProviders.mkString("[", ", ", "]")).toString());
            }
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.head();
        } else {
            throw new MatchError((Object)option);
        }
        JdbcConnectionProvider selectedProvider = jdbcConnectionProvider;
        return selectedProvider.getConnection(kyuubiConf);
    }

    public Seq<JdbcConnectionProvider> loadProviders() {
        return ReflectUtils$.MODULE$.loadFromServiceLoader(ReflectUtils$.MODULE$.loadFromServiceLoader$default$1(), ClassTag$.MODULE$.apply(JdbcConnectionProvider.class)).map((Function1 & Serializable & scala.Serializable)provider -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Loaded provider: ").append(provider).toString());
            return provider;
        }).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$create$2(String providerName$1, JdbcConnectionProvider x$2) {
        String string = x$2.name();
        String string2 = providerName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public AbstractConnectionProvider() {
        Logging.$init$((Logging)this);
        this.providers = this.loadProviders();
    }
}

