/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.net.ConnectException;
import java.nio.file.Path;
import java.util.Base64;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.client.KyuubiSyncThriftClient$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoType;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.command.RunnableCommand;
import org.apache.kyuubi.util.SignUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001\u0002\u001c8\u0001\u0001C\u0011\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012+\t\u0013]\u0003!\u0011!Q\u0001\na+\u0007\"\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u0002-h\u0011%A\u0007A!A!\u0002\u0013A\u0016\u000eC\u0005k\u0001\t\u0005\t\u0015!\u0003l]\"Iq\u000e\u0001B\u0001B\u0003%\u0001o\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"A1\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0011\u00020!A\u0011q\n\u0001!\u0002\u0013\t\t\u0004\u0003\u0006\u0002R\u0001\u0011\r\u0011\"\u0001:\u0003'Bq!!\u0016\u0001A\u0003%1\u000e\u0003\u0006\u0002X\u0001A)\u0019!C\u0005\u00033B!\"a\u0017\u0001\u0011\u000b\u0007I\u0011AA/\u0011)\tI\u0007\u0001b\u0001\n\u0003I\u00141\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002n!Q\u00111\u0010\u0001\t\u0006\u0004%I!!\u0017\t\u0013\u0005u\u0004A1A\u0005\n\u0005}\u0004\u0002CAG\u0001\u0001\u0006I!!!\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bCAR\u0001\u0001\u0007\t\u0019!C\u0005\u0003KC1\"a-\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026\"Y\u00111\u0018\u0001A\u0002\u0003\u0005\u000b\u0015BAT\u0011\u001d\ti\u000b\u0001C\u0001\u0003KC1\"!2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\"Y\u0011q\u001a\u0001A\u0002\u0003\u0007I\u0011BAi\u0011-\t)\u000e\u0001a\u0001\u0002\u0003\u0006K!!3\t\u0013\u0005e\u0007\u00011A\u0005\n\u0005m\u0007\"CAy\u0001\u0001\u0007I\u0011BAz\u0011!\t9\u0010\u0001Q!\n\u0005u\u0007bBA~\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011!\u0011\t\u0002\u0001C\u0001s\tM\u0001B\u0003B\u0014\u0001E\u0005I\u0011A\u001d\u0003*!9!q\b\u0001\u0005R\t\u0005\u0003\"\u0003B&\u0001\u0001\u0007I\u0011\u0002B'\u0011%\u0011y\u0005\u0001a\u0001\n\u0013\u0011\t\u0006C\u0004\u0003V\u0001\u0001\u000b\u0015\u0002?\t\u000f\te\u0003\u0001\"\u0003\u0002\u001c\"9!1\f\u0001\u0005\n\tu\u0003b\u0002B0\u0001\u0011\u0005\u00131\u0014\u0005\b\u0005C\u0002A\u0011\tB2\u0011\u001d\u0011)\b\u0001C!\u0005oBqAa$\u0001\t\u0003\u0011\t\nC\u0007\u0003\u0014\u0002\u0001\n1!A\u0001\n\u0013\tI&\u001a\u0005\u000f\u0005+\u0003\u0001\u0013aA\u0001\u0002\u0013%\u00111\u0014BL\u00115\u0011I\n\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002BNg\"i!1\u0015\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002Z\u001dDQB!*\u0001!\u0003\r\t\u0011!C\u0005\u0005O#\u0006B\u0004BU\u0001A\u0005\u0019\u0011!A\u0005\n\t-&Q\u0017\u0002\u0012\u0017f,XOY5TKN\u001c\u0018n\u001c8J[Bd'B\u0001\u001d:\u0003\u001d\u0019Xm]:j_:T!AO\u001e\u0002\r-LX/\u001e2j\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u000ek\u0011aN\u0005\u0003\t^\u0012QbS=vk\nL7+Z:tS>t\u0017\u0001\u00039s_R|7m\u001c7\u0011\u0005\u001d\u0013V\"\u0001%\u000b\u0005%S\u0015A\u0002;ie&4GO\u0003\u0002L\u0019\u0006\u0019!\u000f]2\u000b\u00055s\u0015aB:feZL7-\u001a\u0006\u0003\u001fB\u000bA\u0001[5wK*\u0011\u0011+O\u0001\u0007g\"\fG-\u001a3\n\u0005MC%\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0013\t)U+\u0003\u0002Wo\ty\u0011IY:ue\u0006\u001cGoU3tg&|g.\u0001\u0003vg\u0016\u0014\bCA-c\u001d\tQ\u0006\r\u0005\u0002\\=6\tAL\u0003\u0002^\u007f\u00051AH]8pizR\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011MX\u0005\u0003/V\u000b\u0001\u0002]1tg^|'\u000fZ\u0005\u0003MV\u000b\u0011\"\u001b9BI\u0012\u0014Xm]:\n\u0005!,\u0016\u0001B2p]\u001a\u0004B!\u00177Y1&\u0011Q\u000e\u001a\u0002\u0004\u001b\u0006\u0004\u0018B\u00016V\u00039\u0019Xm]:j_:l\u0015M\\1hKJ\u0004\"AQ9\n\u0005I<$\u0001F&zkV\u0014\u0017nU3tg&|g.T1oC\u001e,'/\u0003\u0002p+\u0006Y1/Z:tS>t7i\u001c8g!\t1\u00180D\u0001x\u0015\tA\u0018(\u0001\u0004d_:4\u0017nZ\u0005\u0003u^\u0014!bS=vk\nL7i\u001c8g\u0003-!w.Q:F]\u0006\u0014G.\u001a3\u0011\u0005utX\"\u00010\n\u0005}t&a\u0002\"p_2,\u0017M\\\u0001\u0007a\u0006\u00148/\u001a:\u0011\t\u0005\u0015\u0011\u0011C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u000511/\u001a:wKJTA!!\u0001\u0002\u000e)\u0019\u0011qB\u001d\u0002\u0007M\fH.\u0003\u0003\u0002\u0014\u0005\u001d!\u0001D&zkV\u0014\u0017\u000eU1sg\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u000b\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121\u0006\t\u0003\u0005\u0002AQ!\u0012\u0006A\u0002\u0019CQa\u0016\u0006A\u0002aCQA\u001a\u0006A\u0002aCQ\u0001\u001b\u0006A\u0002aCQA\u001b\u0006A\u0002-DQa\u001c\u0006A\u0002ADQ\u0001\u001e\u0006A\u0002UDQa\u001f\u0006A\u0002qDq!!\u0001\u000b\u0001\u0004\t\u0019!A\u0006tKN\u001c\u0018n\u001c8UsB,WCAA\u0019!\u0011\t\u0019$!\u0013\u000f\t\u0005U\u0012Q\t\b\u0005\u0003o\t\u0019E\u0004\u0003\u0002:\u0005\u0005c\u0002BA\u001e\u0003\u007fq1aWA\u001f\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0019\u0011qI\u001c\u0002\u0017M+7o]5p]RK\b/Z\u0005\u0005\u0003\u0017\niEA\u0006TKN\u001c\u0018n\u001c8UsB,'bAA$o\u0005a1/Z:tS>tG+\u001f9fA\u0005iq\u000e\u001d;j[&TX\rZ\"p]\u001a,\u0012a[\u0001\u000f_B$\u0018.\\5{K\u0012\u001cuN\u001c4!\u0003E)gnZ5oK\u000e\u0013X\rZ3oi&\fGn]\u000b\u00021\u00061QM\\4j]\u0016,\"!a\u0018\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR1!a\u0017:\u0013\u0011\t9'a\u0019\u0003\u0013\u0015sw-\u001b8f%\u00164\u0017A\u00047bk:\u001c\u0007.\u00128hS:,w\n]\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gJ\u0014!C8qKJ\fG/[8o\u0013\u0011\t9(!\u001d\u0003\u0013=\u0003XM]1uS>t\u0017a\u00047bk:\u001c\u0007.\u00128hS:,w\n\u001d\u0011\u0002+M,7o]5p]V\u001bXM]*jO:\u0014\u0015m]37i\u0005a1/Z:tS>tWI^3oiV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001d\u0002\r\u00154XM\u001c;t\u0013\u0011\tY)!\"\u0003%-KX/\u001e2j'\u0016\u001c8/[8o\u000bZ,g\u000e^\u0001\u000eg\u0016\u001c8/[8o\u000bZ,g\u000e\u001e\u0011\u0002\u001f\u001d,GoU3tg&|g.\u0012<f]R,\"!a%\u0011\u000bu\f)*!!\n\u0007\u0005]eL\u0001\u0004PaRLwN\\\u0001\u001bG\",7m[*fgNLwN\\!dG\u0016\u001c8\u000fU1uQV\u0013\u0016j\u001d\u000b\u0003\u0003;\u00032!`AP\u0013\r\t\tK\u0018\u0002\u0005+:LG/A\u0004`G2LWM\u001c;\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\u0007\u00055\u0016(\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003c\u000bYK\u0001\fLsV,(-[*z]\u000e$\u0006N]5gi\u000ec\u0017.\u001a8u\u0003-y6\r\\5f]R|F%Z9\u0015\t\u0005u\u0015q\u0017\u0005\n\u0003sK\u0012\u0011!a\u0001\u0003O\u000b1\u0001\u001f\u00132\u0003!y6\r\\5f]R\u0004\u0003f\u0001\u000e\u0002@B\u0019Q0!1\n\u0007\u0005\rgL\u0001\u0005w_2\fG/\u001b7f\u0003QyVM\\4j]\u0016\u001cVm]:j_:D\u0015M\u001c3mKV\u0011\u0011\u0011\u001a\t\u0004\u0005\u0006-\u0017bAAgo\ti1+Z:tS>t\u0007*\u00198eY\u0016\f\u0001dX3oO&tWmU3tg&|g\u000eS1oI2,w\fJ3r)\u0011\ti*a5\t\u0013\u0005eV$!AA\u0002\u0005%\u0017!F0f]\u001eLg.Z*fgNLwN\u001c%b]\u0012dW\r\t\u0015\u0004=\u0005}\u0016\u0001E8qK:\u001cVm]:j_:,%O]8s+\t\ti\u000eE\u0003~\u0003+\u000by\u000e\u0005\u0003\u0002b\u0006-h\u0002BAr\u0003Ot1aWAs\u0013\u0005y\u0016bAAu=\u00069\u0001/Y2lC\u001e,\u0017\u0002BAw\u0003_\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005%h,\u0001\u000bpa\u0016t7+Z:tS>tWI\u001d:pe~#S-\u001d\u000b\u0005\u0003;\u000b)\u0010C\u0005\u0002:\u0002\n\t\u00111\u0001\u0002^\u0006\tr\u000e]3o'\u0016\u001c8/[8o\u000bJ\u0014xN\u001d\u0011)\u0007\u0005\ny,\u0001\u0003pa\u0016t\u0017!D4fi\u0016sw-\u001b8f\u001d>$W-\u0006\u0002\u0003\u0002A)Q0!&\u0003\u0004A!!Q\u0001B\u0007\u001b\t\u00119A\u0003\u0003\u0002.\n%!b\u0001B\u0006s\u0005\u0011\u0001.Y\u0005\u0005\u0005\u001f\u00119AA\bTKJ4\u0018nY3O_\u0012,\u0017J\u001c4p\u0003Ey\u0007/\u001a8F]\u001eLg.Z*fgNLwN\u001c\u000b\u0005\u0003;\u0013)\u0002C\u0005\u0003\u0018\u0011\u0002\n\u00111\u0001\u0003\u001a\u0005qQ\r\u001f;sC\u0016sw-\u001b8f\u0019><\u0007#B?\u0002\u0016\nm\u0001\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\t\t\u0005\u0012\u0011O\u0001\u0004Y><\u0017\u0002\u0002B\u0013\u0005?\u0011Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\f1d\u001c9f]\u0016sw-\u001b8f'\u0016\u001c8/[8oI\u0011,g-Y;mi\u0012\nTC\u0001B\u0016U\u0011\u0011IB!\f,\u0005\t=\u0002\u0003\u0002B\u0019\u0005wi!Aa\r\u000b\t\tU\"qG\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000f_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005{\u0011\u0019DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAB];o\u001fB,'/\u0019;j_:$BAa\u0011\u0003JA!\u0011q\u000eB#\u0013\u0011\u00119%!\u001d\u0003\u001f=\u0003XM]1uS>t\u0007*\u00198eY\u0016Dq!a\u001d'\u0001\u0004\ti'\u0001\bf]\u001eLg.\u001a'bk:\u001c\u0007.\u001a3\u0016\u0003q\f!#\u001a8hS:,G*Y;oG\",Gm\u0018\u0013fcR!\u0011Q\u0014B*\u0011!\tI\fKA\u0001\u0002\u0004a\u0018aD3oO&tW\rT1v]\u000eDW\r\u001a\u0011)\u0007%\ny,A\u000bxC&$hi\u001c:F]\u001eLg.\u001a'bk:\u001c\u0007.\u001a3\u0002-I,g.Z<F]\u001eLg.Z\"sK\u0012,g\u000e^5bYN$\u0012\u0001W\u0001\u0006G2|7/Z\u0001\bO\u0016$\u0018J\u001c4p)\u0011\u0011)Ga\u001b\u0011\u0007\u001d\u00139'C\u0002\u0003j!\u0013Q\u0002V$fi&sgm\u001c,bYV,\u0007b\u0002B7[\u0001\u0007!qN\u0001\tS:4w\u000eV=qKB\u0019qI!\u001d\n\u0007\tM\u0004J\u0001\u0007U\u000f\u0016$\u0018J\u001c4p)f\u0004X-\u0001\tfq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiRQ!1\tB=\u0005{\u0012\tI!\"\t\r\tmd\u00061\u0001Y\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0003\u0004\u0003\u00009\u0002\ra[\u0001\fG>tgm\u0014<fe2\f\u0017\u0010\u0003\u0004\u0003\u0004:\u0002\r\u0001`\u0001\teVt\u0017i]=oG\"9!q\u0011\u0018A\u0002\t%\u0015\u0001D9vKJLH+[7f_V$\bcA?\u0003\f&\u0019!Q\u00120\u0003\t1{gnZ\u0001\u001bG\",7m[#oO&tWmQ8o]\u0016\u001cG/[8o\u00032Lg/\u001a\u000b\u0002y\u0006Q1/\u001e9fe\u0012*8/\u001a:\u0002\u0015M,\b/\u001a:%_B,g.C\u0002\u0002|V\u000bAc];qKJ$3/Z:tS>tW*\u00198bO\u0016\u0014XC\u0001BO!\r\u0011%qT\u0005\u0004\u0005C;$AD*fgNLwN\\'b]\u0006<WM]\u0001\u000fgV\u0004XM\u001d\u0013qCN\u001cxo\u001c:e\u00039\u0019X\u000f]3sIA\u0014x\u000e^8d_2,\u0012AR\u0001\u0017gV\u0004XM\u001d\u0013fq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiRQ!1\tBW\u0005_\u0013\tLa-\t\r\tmT\u00071\u0001Y\u0011\u0019\u0011y(\u000ea\u0001W\"1!1Q\u001bA\u0002qDqAa\"6\u0001\u0004\u0011I)C\u0002\u0003vU\u0003")
public class KyuubiSessionImpl
extends KyuubiSession {
    private String engineCredentials;
    private EngineRef engine;
    private String sessionUserSignBase64;
    private final KyuubiConf sessionConf;
    private final boolean doAsEnabled;
    private final KyuubiParser parser;
    private final Enumeration.Value sessionType;
    private final scala.collection.immutable.Map<String, String> optimizedConf;
    private final Operation launchEngineOp;
    private final KyuubiSessionEvent sessionEvent;
    private volatile KyuubiSyncThriftClient _client;
    private volatile SessionHandle _engineSessionHandle;
    private volatile Option<Throwable> openSessionError;
    private volatile boolean engineLaunched;
    private volatile byte bitmap$0;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ void super$open() {
        super.open();
    }

    private /* synthetic */ SessionManager super$sessionManager() {
        return super.sessionManager();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    private /* synthetic */ OperationHandle super$executeStatement(String statement, scala.collection.immutable.Map confOverlay, boolean runAsync, long queryTimeout) {
        return super.executeStatement(statement, confOverlay, runAsync, queryTimeout);
    }

    @Override
    public Enumeration.Value sessionType() {
        return this.sessionType;
    }

    public scala.collection.immutable.Map<String, String> optimizedConf() {
        return this.optimizedConf;
    }

    private String engineCredentials$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineCredentials = this.renewEngineCredentials();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineCredentials;
    }

    private String engineCredentials() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineCredentials$lzycompute();
        }
        return this.engineCredentials;
    }

    private EngineRef engine$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engine = new EngineRef(this.sessionConf, super.user(), this.doAsEnabled, ((KyuubiSessionManager)super.sessionManager()).groupProvider(), this.handle().identifier().toString(), ((KyuubiSessionManager)super.sessionManager()).applicationManager(), ((KyuubiSessionManager)super.sessionManager()).engineStartupProcessSemaphore());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engine;
    }

    public EngineRef engine() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engine$lzycompute();
        }
        return this.engine;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    private String sessionUserSignBase64$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionUserSignBase64 = SignUtils$.MODULE$.signWithPrivateKey(super.user(), ((KyuubiSessionManager)super.sessionManager()).signingPrivateKey(), SignUtils$.MODULE$.signWithPrivateKey$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionUserSignBase64;
    }

    private String sessionUserSignBase64() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionUserSignBase64$lzycompute();
        }
        return this.sessionUserSignBase64;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public Option<KyuubiSessionEvent> getSessionEvent() {
        return Option$.MODULE$.apply((Object)this.sessionEvent());
    }

    @Override
    public void checkSessionAccessPathURIs() {
        KyuubiApplicationManager$.MODULE$.checkApplicationAccessPaths((String)this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()), (scala.collection.immutable.Map<String, String>)this.sessionConf.getAll(), ((KyuubiSessionManager)super.sessionManager()).getConf());
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    private Option<Throwable> openSessionError() {
        return this.openSessionError;
    }

    private void openSessionError_$eq(Option<Throwable> x$1) {
        this.openSessionError = x$1;
    }

    public void open() {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.traceMetricsOnOpen();
            this.checkSessionAccessPathURIs();
            this.super$open();
            ((KyuubiSessionManager)this.super$sessionManager()).tempFileService().addPathToExpiration((Path)this.operationalLogRootDir().get());
            this.runOperation(this.launchEngineOp());
        });
    }

    public Option<ServiceNodeInfo> getEngineNode() {
        return (Option)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> this.engine().getServiceNode((DiscoveryClient)discoveryClient, this._client().hostPort()));
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DiscoveryClientProvider$.MODULE$.withDiscoveryClient($this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$2(this, extraEngineLog, discoveryClient);
            return BoxedUnit.UNIT;
        }));
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block2: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block2;
            try {
                this.waitForEngineLaunched();
            }
            catch (Throwable t) {
                operation.close();
                throw t;
            }
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private boolean engineLaunched() {
        return this.engineLaunched;
    }

    private void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private void waitForEngineLaunched() {
        if (!this.engineLaunched()) {
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String renewEngineCredentials() {
        String string;
        try {
            string = ((KyuubiSessionManager)super.sessionManager()).credentialsManager().renewCredentials(this.engine().appUser());
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to renew engine credentials for ").append(this.handle()).toString(), e);
            string = "";
        }
        return string;
    }

    public void close() {
        super.close();
        ((KyuubiSessionManager)super.sessionManager()).credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            if (this._client() != null) {
                this._client().closeSession();
            }
        }
        finally {
            this.openSessionError().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                KyuubiSessionImpl.$anonfun$close$1(this, x$6);
                return BoxedUnit.UNIT;
            });
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
            this.traceMetricsOnClose();
        }
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        String string = (String)this.sessionConf.get(KyuubiConf$.MODULE$.SERVER_INFO_PROVIDER());
        if ("SERVER".equals(string)) {
            return super.getInfo(infoType);
        }
        if ("ENGINE".equals(string)) {
            return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
                this.waitForEngineLaunched();
                return this.client().getInfo(infoType).getInfoValue();
            });
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unknown server info provider ").append(string).toString());
    }

    public OperationHandle executeStatement(String statement, scala.collection.immutable.Map<String, String> confOverlay, boolean runAsync, long queryTimeout) {
        return (OperationHandle)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiTreeNode kyuubiNode = $this.parser.parsePlan(statement);
            KyuubiTreeNode kyuubiTreeNode = kyuubiNode;
            if (kyuubiTreeNode instanceof RunnableCommand) {
                RunnableCommand runnableCommand = (RunnableCommand)kyuubiTreeNode;
                Operation operation = ((KyuubiSessionManager)this.super$sessionManager()).operationManager().newExecuteOnServerOperation(this, runAsync, runnableCommand);
                return this.runOperation(operation);
            }
            return this.super$executeStatement(statement, confOverlay, runAsync, queryTimeout);
        });
    }

    public boolean checkEngineConnectionAlive() {
        if (this.client() == null) {
            return true;
        }
        if (this.client().engineConnectionClosed()) {
            return false;
        }
        return !this.client().remoteEngineBroken();
    }

    private final void deregisterEngine$1(DiscoveryClient discoveryClient$1, String host$1, int port$1) {
        try {
            this.engine().deregister(discoveryClient$1, (Tuple2<String, Object>)new Tuple2((Object)host$1, (Object)BoxesRunTime.boxToInteger((int)port$1)));
        }
        catch (Throwable e) {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error on de-registering engine [").append(this.engine().engineSpace()).append(" ").append(host$1).append(":").append(port$1).append("]").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$10(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineId_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$11(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineName_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$12(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineUrl_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$2(KyuubiSessionImpl $this, Option extraEngineLog$1, DiscoveryClient discoveryClient) {
        scala.collection.immutable.Map openEngineSessionConf = $this.optimizedConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.handle"), (Object)$this.handle().identifier().toString())})));
        if (new StringOps(Predef$.MODULE$.augmentString($this.engineCredentials())).nonEmpty()) {
            $this.sessionConf.set("kyuubi.engine.credentials", $this.engineCredentials());
            openEngineSessionConf = openEngineSessionConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.engine.credentials"), (Object)$this.engineCredentials())})));
        }
        if (BoxesRunTime.unboxToBoolean((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()))) {
            openEngineSessionConf = openEngineSessionConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()), (Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()).toString())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.sign.publickey"), (Object)Base64.getEncoder().encodeToString(((KyuubiSessionManager)$this.super$sessionManager()).signingPublicKey().getEncoded()))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.user.sign"), (Object)$this.sessionUserSignBase64()));
        }
        int maxAttempts = BoxesRunTime.unboxToInt((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_MAX_ATTEMPTS()));
        long retryWait = BoxesRunTime.unboxToLong((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_RETRY_WAIT()));
        Enumeration.Value openOnFailure = KyuubiConf.EngineOpenOnFailure$.MODULE$.withName((String)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_ON_FAILURE()));
        IntRef attempt = IntRef.create((int)0);
        boolean shouldRetry = true;
        while (attempt.elem <= maxAttempts && shouldRetry) {
            Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(discoveryClient, (Option<OperationLog>)extraEngineLog$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            try {
                try {
                    String passwd = BoxesRunTime.unboxToBoolean((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? InternalSecurityAccessor$.MODULE$.get().issueToken() : (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$4(x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
                    $this._client_$eq(KyuubiSyncThriftClient$.MODULE$.createClient($this.super$user(), passwd, host2, port2, $this.sessionConf));
                    $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (scala.collection.immutable.Map<String, String>)openEngineSessionConf));
                    $this.logSessionInfo(new StringBuilder(33).append("Connected to engine [").append(host2).append(":").append(port2).append("]/[").append($this.client().engineId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("]").append(" with ").append($this._engineSessionHandle()).append("]").toString());
                    shouldRetry = false;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof TTransportException) {
                        TTransportException tTransportException = (TTransportException)throwable2;
                        if (attempt.elem < maxAttempts && tTransportException.getCause() instanceof ConnectException && tTransportException.getCause().getMessage().contains("Connection refused")) {
                            $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to open [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("] after").append(" ").append(attempt$1.elem).append("/").append(maxAttempts).append(" times, retrying").toString(), tTransportException.getCause());
                            Thread.sleep(retryWait);
                            Enumeration.Value value = openOnFailure;
                            Enumeration.Value value2 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                $this.deregisterEngine$1(discoveryClient, host2, port2);
                            }
                            shouldRetry = true;
                            continue;
                        }
                    }
                    if (throwable2 != null) {
                        boolean bl;
                        Throwable throwable3 = throwable2;
                        $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Opening engine [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").append(" for ").append($this.super$user()).append(" session failed").toString(), throwable3);
                        $this.openSessionError_$eq((Option<Throwable>)new Some((Object)throwable3));
                        Enumeration.Value value = openOnFailure;
                        Enumeration.Value value4 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_IMMEDIATELY();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value6 = KyuubiConf.EngineOpenOnFailure$.MODULE$.DEREGISTER_AFTER_RETRY();
                            Enumeration.Value value7 = value;
                            bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
                        }
                        if (bl) {
                            $this.deregisterEngine$1(discoveryClient, host2, port2);
                        }
                        throw throwable3;
                    }
                    throw throwable;
                }
            }
            finally {
                ++attempt.elem;
                if (!shouldRetry || $this._client() == null) continue;
                try {
                    $this._client().closeSession();
                }
                catch (Throwable e2) {
                    $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error on closing broken client of engine ").append("[").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").toString(), e2);
                }
            }
        }
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this._client().engineId().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$10($this, e);
            return BoxedUnit.UNIT;
        });
        $this._client().engineName().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$11($this, e);
            return BoxedUnit.UNIT;
        });
        $this._client().engineUrl().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$12($this, e);
            return BoxedUnit.UNIT;
        });
        EventBus$.MODULE$.post((KyuubiEvent)$this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(28).append("Failed to launch engine for ").append($this.handle()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$close$1(KyuubiSessionImpl $this, Throwable x$6) {
        if ($this.engine() != null) {
            $this.engine().close();
            return;
        }
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf, boolean doAsEnabled, KyuubiParser parser) {
        scala.collection.immutable.Map map;
        this.sessionConf = sessionConf;
        this.doAsEnabled = doAsEnabled;
        this.parser = parser;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.sessionType = SessionType$.MODULE$.INTERACTIVE();
        scala.collection.mutable.Map confOverlay = (scala.collection.mutable.Map)((TraversableOnce)((KyuubiSessionManager)super.sessionManager()).sessionConfAdvisor().map((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$1.getConfOverlay(this.super$user(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.normalizedConf()).asJava())).asScala(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus((GenTraversableOnce)x$3));
        if (confOverlay != null) {
            map = this.normalizedConf().$plus$plus((GenTraversableOnce)confOverlay);
        } else {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("the server plugin return null value for user: ").append(this.super$user()).append(", ignore it").toString());
            map = this.normalizedConf();
        }
        this.optimizedConf = map;
        this.optimizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = package$.MODULE$.USE_CATALOG();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string4 = package$.MODULE$.USE_DATABASE();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.sessionConf.set(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        this.launchEngineOp = ((KyuubiSessionManager)super.sessionManager()).operationManager().newLaunchEngineOperation(this, BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC())));
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        this.openSessionError = None$.MODULE$;
        this.engineLaunched = false;
    }
}

