/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.registry.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.registry.ServiceRegistry;
import org.apache.knox.gateway.services.registry.impl.RegEntry;
import org.apache.knox.gateway.services.registry.impl.Registry;
import org.apache.knox.gateway.services.security.CryptoService;

public class DefaultServiceRegistryService
implements ServiceRegistry,
Service {
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    protected char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private CryptoService crypto;
    private Registry registry = new Registry();
    private String registryFileName;

    public void setCryptoService(CryptoService crypto) {
        this.crypto = crypto;
    }

    public String getRegistrationCode(String clusterName) {
        String code = this.generateRegCode(16);
        byte[] signature = this.crypto.sign("SHA256withRSA", code);
        String encodedSig = Base64.encodeBase64URLSafeString((byte[])signature);
        return code + "::" + encodedSig;
    }

    private String generateRegCode(int length) {
        StringBuilder sb = new StringBuilder();
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            sb.append(this.chars[r.nextInt(this.chars.length)]);
        }
        return sb.toString();
    }

    public void removeClusterServices(String clusterName) {
        this.registry.remove(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerService(String regCode, String clusterName, String serviceName, List<String> urls) {
        boolean rc = false;
        if (regCode == null) {
            throw new IllegalArgumentException("Registration Code must not be null.");
        }
        String[] parts = regCode.split("::");
        boolean verified = this.crypto.verify("SHA256withRSA", parts[0], Base64.decodeBase64((String)parts[1]));
        if (verified) {
            HashMap<String, RegEntry> clusterServices = (HashMap<String, RegEntry>)this.registry.get(clusterName);
            if (clusterServices == null) {
                DefaultServiceRegistryService defaultServiceRegistryService = this;
                synchronized (defaultServiceRegistryService) {
                    clusterServices = new HashMap<String, RegEntry>();
                    this.registry.put(clusterName, clusterServices);
                }
            }
            RegEntry regEntry = new RegEntry();
            regEntry.setClusterName(clusterName);
            regEntry.setServiceName(serviceName);
            regEntry.setUrls(urls);
            clusterServices.put(serviceName, regEntry);
            String json = this.renderAsJsonString(this.registry);
            try {
                FileUtils.write((File)new File(this.registryFileName), (CharSequence)json, (Charset)StandardCharsets.UTF_8);
                rc = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rc;
    }

    private String renderAsJsonString(Map<String, Map<String, RegEntry>> registry) {
        String json = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writeValueAsString(registry);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String lookupServiceURL(String clusterName, String serviceName) {
        List<String> urls = this.lookupServiceURLs(clusterName, serviceName);
        if (urls != null && !urls.isEmpty()) {
            return urls.get(0);
        }
        return null;
    }

    public List<String> lookupServiceURLs(String clusterName, String serviceName) {
        RegEntry entry;
        Map clusterServices = (Map)this.registry.get(clusterName);
        if (clusterServices != null && (entry = (RegEntry)clusterServices.get(serviceName)) != null) {
            return entry.getUrls();
        }
        return null;
    }

    private Map<String, Map<String, RegEntry>> getMapFromJsonString(String json) {
        Registry map = null;
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Registry> typeRef = new TypeReference<Registry>(){};
        try {
            map = (Registry)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            LOG.failedToGetMapFromJsonString(json, e);
        }
        return map;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        String securityDir = config.getGatewaySecurityDir();
        String filename = "registry";
        this.setupRegistryFile(securityDir, filename);
    }

    protected void setupRegistryFile(String securityDir, String filename) throws ServiceLifecycleException {
        File registryFile = new File(securityDir, filename);
        if (registryFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)registryFile, (Charset)StandardCharsets.UTF_8);
                Registry reg = (Registry)this.getMapFromJsonString(json);
                if (reg != null) {
                    this.registry = reg;
                }
            }
            catch (Exception e) {
                throw new ServiceLifecycleException("Unable to load the persisted registry.", e);
            }
        }
        this.registryFileName = registryFile.getAbsolutePath();
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }
}

