/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AbstractAliasService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;
import org.apache.knox.gateway.services.token.RemoteTokenStateChangeListener;
import org.apache.knox.gateway.util.PasswordUtils;

public class ZookeeperRemoteAliasService
extends AbstractAliasService {
    public static final String TYPE = "zookeeper";
    public static final String PATH_KNOX = "/knox";
    public static final String PATH_KNOX_SECURITY = "/knox/security";
    public static final String PATH_KNOX_ALIAS_STORE_TOPOLOGY = "/knox/security/topology";
    public static final String PATH_SEPARATOR = "/";
    private static final String BASE_SUB_NODE = "/knox/security/topology/";
    private static final String GATEWAY_SUB_NODE = "/knox/security/topology/__gateway";
    public static final String OPTION_NAME_SHOULD_CREATE_TOKENS_SUB_NODE = "zkShouldCreateTokenSubnodes";
    public static final String OPTION_NAME_SHOULD_USE_LOCAL_ALIAS = "zkShouldUseLocalAlias";
    public static final String TOKENS_SUB_NODE_NAME = "tokens";
    public static final String TOKENS_SUB_NODE_PATH = "/tokens";
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final RemoteConfigurationRegistryClient.EntryACL AUTHENTICATED_USERS_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "";
        }

        public String getType() {
            return "auth";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private static final RemoteConfigurationRegistryClient.EntryACL KERBEROS_KNOX_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "knox";
        }

        public String getType() {
            return "sasl";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private final AliasService localAliasService;
    private final MasterService ms;
    private final RemoteConfigurationRegistryClientService remoteConfigurationRegistryClientService;
    private final Collection<RemoteTokenStateChangeListener> remoteTokenStateChangeListeners = new HashSet<RemoteTokenStateChangeListener>();
    private RemoteConfigurationRegistryClient remoteClient;
    private ConfigurableEncryptor encryptor;
    private GatewayConfig config;
    private boolean shouldCreateTokensSubNode;
    private boolean shouldUseLocalAliasService;

    ZookeeperRemoteAliasService(AliasService localAliasService, MasterService ms, RemoteConfigurationRegistryClientService remoteConfigurationRegistryClientService) {
        this.localAliasService = localAliasService;
        this.ms = ms;
        this.remoteConfigurationRegistryClientService = remoteConfigurationRegistryClientService;
    }

    public void registerRemoteTokenStateChangeListener(RemoteTokenStateChangeListener changeListener) {
        this.remoteTokenStateChangeListeners.add(changeListener);
    }

    private String buildAliasEntryName(String clusterName, String alias) {
        StringBuilder aliasEntryNameBuilder = new StringBuilder(ZookeeperRemoteAliasService.buildClusterEntryName(clusterName));
        String lowercaseAlias = alias.toLowerCase(Locale.ROOT);
        if (this.shouldCreateTokensSubNode) {
            aliasEntryNameBuilder.append(TOKENS_SUB_NODE_PATH);
            ZookeeperRemoteAliasService.ensureEntry(aliasEntryNameBuilder.toString(), this.remoteClient);
            String newSubnodeName = lowercaseAlias.length() < 2 ? lowercaseAlias : lowercaseAlias.substring(0, 2);
            aliasEntryNameBuilder.append(PATH_SEPARATOR).append(newSubnodeName);
            ZookeeperRemoteAliasService.ensureEntry(aliasEntryNameBuilder.toString(), this.remoteClient);
        }
        return aliasEntryNameBuilder.append(PATH_SEPARATOR).append(lowercaseAlias).toString();
    }

    private static String buildClusterEntryName(String clusterName) {
        return BASE_SUB_NODE + clusterName;
    }

    private static void ensureEntry(String path, RemoteConfigurationRegistryClient remoteClient) {
        if (!remoteClient.entryExists(path)) {
            remoteClient.createEntry(path);
        } else {
            List entryACLs = remoteClient.getACL(path);
            for (RemoteConfigurationRegistryClient.EntryACL entryACL : entryACLs) {
                if (!"world".equals(entryACL.getType()) || !"anyone".equals(entryACL.getId())) continue;
                LOG.suspectWritableRemoteConfigurationEntry(path);
                if (!remoteClient.isAuthenticationConfigured()) continue;
                LOG.correctingSuspectWritableRemoteConfigurationEntry(path);
                if ("Kerberos".equalsIgnoreCase(remoteClient.authenticationType()) && !remoteClient.isBackwardsCompatible()) {
                    remoteClient.setACL(path, Collections.singletonList(KERBEROS_KNOX_ALL));
                    continue;
                }
                remoteClient.setACL(path, Collections.singletonList(AUTHENTICATED_USERS_ALL));
            }
        }
    }

    private static void checkPathsExist(RemoteConfigurationRegistryClient remoteClient) {
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(GATEWAY_SUB_NODE, remoteClient);
    }

    public List<String> getAliasesForCluster(String clusterName) throws AliasServiceException {
        List localAliases;
        List list = localAliases = this.shouldUseLocalAliasService ? this.localAliasService.getAliasesForCluster(clusterName) : null;
        if (localAliases == null || localAliases.isEmpty()) {
            if (this.remoteClient != null) {
                List remoteAliases = null;
                String entryName = ZookeeperRemoteAliasService.buildClusterEntryName(clusterName);
                if (this.remoteClient.entryExists(entryName)) {
                    remoteAliases = this.remoteClient.listChildEntries(entryName);
                }
                return remoteAliases == null ? new ArrayList() : remoteAliases;
            }
            return new ArrayList<String>();
        }
        return localAliases;
    }

    public void addAliasForCluster(String clusterName, String alias, String value) throws AliasServiceException {
        if (this.remoteClient != null) {
            String aliasEntryPath = this.buildAliasEntryName(clusterName, alias);
            ZookeeperRemoteAliasService.checkPathsExist(this.remoteClient);
            ZookeeperRemoteAliasService.ensureEntry(ZookeeperRemoteAliasService.buildClusterEntryName(clusterName), this.remoteClient);
            try {
                if (this.remoteClient.entryExists(aliasEntryPath)) {
                    this.remoteClient.setEntryData(aliasEntryPath, this.encrypt(value));
                } else {
                    this.remoteClient.createEntry(aliasEntryPath, this.encrypt(value));
                }
            }
            catch (Exception e) {
                throw new AliasServiceException(e);
            }
            if (this.remoteClient.getEntryData(aliasEntryPath) == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Failed to store alias %s for cluster %s in remote registry", alias, clusterName));
            }
        }
    }

    public void addAliasesForCluster(String clusterName, Map<String, String> credentials) throws AliasServiceException {
        for (Map.Entry<String, String> credential : credentials.entrySet()) {
            this.addAliasForCluster(clusterName, credential.getKey(), credential.getValue());
        }
    }

    public void removeAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        String aliasEntryPath;
        if (this.remoteClient != null && this.remoteClient.entryExists(aliasEntryPath = this.buildAliasEntryName(clusterName, alias))) {
            this.remoteClient.deleteEntry(aliasEntryPath);
            if (this.remoteClient.entryExists(aliasEntryPath)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Failed to delete alias %s for cluster %s in remote registry", alias, clusterName));
            }
        }
    }

    public void removeAliasesForCluster(String clusterName, Set<String> aliases) throws AliasServiceException {
        for (String alias : aliases) {
            this.removeAliasForCluster(clusterName, alias);
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias, boolean generate) throws AliasServiceException {
        char[] password;
        char[] cArray = password = this.shouldUseLocalAliasService ? this.localAliasService.getPasswordFromAliasForCluster(clusterName, alias, generate) : null;
        if (password == null && this.remoteClient != null) {
            ZookeeperRemoteAliasService.checkPathsExist(this.remoteClient);
            String encrypted = null;
            if (this.remoteClient.entryExists(this.buildAliasEntryName(clusterName, alias))) {
                encrypted = this.remoteClient.getEntryData(this.buildAliasEntryName(clusterName, alias));
            }
            if (encrypted == null) {
                if (generate) {
                    this.generateAliasForCluster(clusterName, alias);
                    password = this.getPasswordFromAliasForCluster(clusterName, alias);
                }
            } else {
                try {
                    password = this.decrypt(encrypted).toCharArray();
                }
                catch (Exception e) {
                    throw new AliasServiceException(e);
                }
            }
        }
        return password;
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        String passwordString = PasswordUtils.generatePassword((int)16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeyPassphraseAlias());
    }

    public char[] getGatewayIdentityKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeystorePasswordAlias());
    }

    public char[] getSigningKeyPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeyPassphraseAlias());
    }

    public char[] getSigningKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeystorePasswordAlias());
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) throws AliasServiceException {
        throw new AliasServiceException((Exception)new UnsupportedOperationException());
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        String clientName = config.getRemoteConfigurationMonitorClientName();
        if (clientName != null && this.remoteConfigurationRegistryClientService != null) {
            this.remoteClient = this.remoteConfigurationRegistryClientService.get(clientName);
            this.ensureEntries(this.remoteClient);
            List aliases = this.remoteClient.listChildEntries(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            if (aliases == null) {
                throw new IllegalStateException("Unable to access remote path: /knox/security/topology");
            }
            this.shouldUseLocalAliasService = Boolean.parseBoolean(options.getOrDefault(OPTION_NAME_SHOULD_USE_LOCAL_ALIAS, "true"));
            try {
                this.remoteClient.addChildEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to add listener for path /knox/security/topology", e);
            }
            this.encryptor = new ConfigurableEncryptor(new String(this.ms.getMasterSecret()));
            this.encryptor.init(config);
            this.shouldCreateTokensSubNode = Boolean.parseBoolean(options.getOrDefault(OPTION_NAME_SHOULD_CREATE_TOKENS_SUB_NODE, "false"));
        } else {
            LOG.missingClientConfigurationForRemoteMonitoring();
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
        if (this.remoteClient != null) {
            try {
                this.remoteClient.removeEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            }
            catch (Exception e) {
                LOG.errorRemovingRemoteListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, e.toString());
            }
        }
    }

    String encrypt(String clear) throws Exception {
        EncryptionResult result = this.encryptor.encrypt(clear);
        return Base64.encodeBase64String((byte[])(Base64.encodeBase64String((byte[])result.salt) + "::" + Base64.encodeBase64String((byte[])result.iv) + "::" + Base64.encodeBase64String((byte[])result.cipher)).getBytes(StandardCharsets.UTF_8));
    }

    String decrypt(String encoded) throws Exception {
        String line = new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8);
        String[] parts = line.split("::");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Data should have 3 parts split by ::");
        }
        return new String(this.encryptor.decrypt(Base64.decodeBase64((String)parts[0]), Base64.decodeBase64((String)parts[1]), Base64.decodeBase64((String)parts[2])), StandardCharsets.UTF_8);
    }

    private void ensureEntries(RemoteConfigurationRegistryClient remoteClient) {
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        ZookeeperRemoteAliasService.ensureEntry(GATEWAY_SUB_NODE, remoteClient);
    }

    private class RemoteAliasEntryListener
    implements RemoteConfigurationRegistryClient.EntryListener {
        final String cluster;
        final String alias;
        final AliasService localAliasService;

        RemoteAliasEntryListener(String cluster, String alias, AliasService localAliasService) {
            this.cluster = cluster;
            this.alias = alias;
            this.localAliasService = localAliasService;
        }

        public void entryChanged(RemoteConfigurationRegistryClient client, String path, byte[] data) {
            if (!ZookeeperRemoteAliasService.TOKENS_SUB_NODE_NAME.equals(this.alias) && this.isAliasPath(path)) {
                String decryptedData = null;
                try {
                    decryptedData = ZookeeperRemoteAliasService.this.decrypt(new String(data, StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while trying to decrypt data for alias " + this.alias, e);
                }
                if (path.contains(ZookeeperRemoteAliasService.TOKENS_SUB_NODE_PATH)) {
                    for (RemoteTokenStateChangeListener changeListener : ZookeeperRemoteAliasService.this.remoteTokenStateChangeListeners) {
                        changeListener.onChanged(this.alias, decryptedData);
                    }
                }
                if (ZookeeperRemoteAliasService.this.shouldUseLocalAliasService) {
                    try {
                        LOG.addAliasLocally(this.cluster, this.alias);
                        this.localAliasService.addAliasForCluster(this.cluster, this.alias, decryptedData);
                    }
                    catch (Exception e) {
                        LOG.errorAddingAliasLocally(this.cluster, this.alias, e.toString());
                    }
                }
            }
        }

        private boolean isAliasPath(String path) {
            String subPath = StringUtils.substringAfter((String)path, (String)ZookeeperRemoteAliasService.BASE_SUB_NODE);
            String[] subPathParts = StringUtils.split((String)subPath, (char)'/');
            if (subPath.contains(ZookeeperRemoteAliasService.TOKENS_SUB_NODE_NAME)) {
                return subPathParts.length == 4;
            }
            return subPathParts.length == 2;
        }
    }

    private class RemoteAliasChildListener
    implements RemoteConfigurationRegistryClient.ChildEntryListener {
        final ZookeeperRemoteAliasService remoteAliasService;

        RemoteAliasChildListener(ZookeeperRemoteAliasService remoteAliasService) {
            this.remoteAliasService = remoteAliasService;
        }

        public void childEvent(RemoteConfigurationRegistryClient client, RemoteConfigurationRegistryClient.ChildEntryListener.Type type, String path) {
            String subPath = StringUtils.substringAfter((String)path, (String)ZookeeperRemoteAliasService.BASE_SUB_NODE);
            String[] subPathParts = StringUtils.split((String)subPath, (char)'/');
            String cluster = subPathParts.length > 1 ? subPathParts[0] : "";
            boolean tokenSubNode = subPath.contains(ZookeeperRemoteAliasService.TOKENS_SUB_NODE_NAME);
            String alias = "";
            alias = tokenSubNode ? (subPathParts.length == 4 ? subPathParts[3] : "") : (subPathParts.length == 2 ? subPathParts[1] : "");
            switch (type) {
                case REMOVED: {
                    try {
                        client.removeEntryListener(path);
                        if (alias.isEmpty()) break;
                        for (RemoteTokenStateChangeListener changeListener : ZookeeperRemoteAliasService.this.remoteTokenStateChangeListeners) {
                            changeListener.onRemoved(alias);
                        }
                        if (!ZookeeperRemoteAliasService.this.shouldUseLocalAliasService) break;
                        LOG.removeAliasLocally(cluster, alias);
                        ZookeeperRemoteAliasService.this.localAliasService.removeAliasForCluster(cluster, alias);
                    }
                    catch (Exception e) {
                        LOG.errorRemovingAliasLocally(cluster, alias, e.toString());
                    }
                    break;
                }
                case ADDED: {
                    if (!alias.isEmpty()) {
                        try {
                            client.addEntryListener(path, (RemoteConfigurationRegistryClient.EntryListener)new RemoteAliasEntryListener(cluster, alias, ZookeeperRemoteAliasService.this.localAliasService));
                        }
                        catch (Exception e) {
                            LOG.errorAddingRemoteAliasEntryListener(cluster, alias, e.toString());
                        }
                        break;
                    }
                    if (ZookeeperRemoteAliasService.BASE_SUB_NODE.equals(path)) break;
                    LOG.addRemoteListener(path);
                    try {
                        client.addChildEntryListener(path, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this.remoteAliasService));
                        break;
                    }
                    catch (Exception e) {
                        LOG.errorAddingRemoteListener(path, e.toString());
                    }
                }
            }
        }
    }
}

