/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.mavibot.btree.exception.BadTransactionStateException;

class WriteTransaction {
    protected ReentrantLock writeLock = new ReentrantLock();

    WriteTransaction() {
    }

    void start() {
        this.writeLock.lock();
    }

    void commit() {
        if (!this.writeLock.isLocked()) {
            throw new BadTransactionStateException("Cannot commit a write transaction when it's not started");
        }
        this.writeLock.unlock();
    }

    void rollback() {
        if (!this.writeLock.isLocked()) {
            throw new BadTransactionStateException("Cannot commit a write transaction when it's not started");
        }
        this.writeLock.unlock();
    }

    boolean isStarted() {
        return this.writeLock.isLocked();
    }
}

