/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class InputBuffer
extends FilterInputStream {
    private Buffer buffer;

    public InputBuffer() {
        this(new Buffer());
    }

    private InputBuffer(Buffer buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public void reset(byte[] input, int length) {
        this.buffer.reset(input, 0, length);
    }

    public void reset(byte[] input, int start, int length) {
        this.buffer.reset(input, start, length);
    }

    public int getPosition() {
        return this.buffer.getPosition();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    private static class Buffer
    extends ByteArrayInputStream {
        public Buffer() {
            super(new byte[0]);
        }

        public void reset(byte[] input, int start, int length) {
            this.buf = input;
            this.count = start + length;
            this.mark = start;
            this.pos = start;
        }

        public int getPosition() {
            return this.pos;
        }

        public int getLength() {
            return this.count;
        }
    }
}

