/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.pac4j.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.pac4j.Pac4jMessages;
import org.apache.knox.gateway.pac4j.config.ClientConfigurationDecorator;
import org.apache.knox.gateway.pac4j.config.Pac4jClientConfigurationDecorator;
import org.apache.knox.gateway.pac4j.session.KnoxSessionStore;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.MasterService;
import org.pac4j.config.client.PropertiesConfigFactory;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.IndirectBasicAuthClient;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;
import org.pac4j.jee.filter.CallbackFilter;
import org.pac4j.jee.filter.SecurityFilter;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.saml.client.SAML2Client;

public class Pac4jDispatcherFilter
implements Filter {
    private static final String ALIAS_PREFIX = "${ALIAS=";
    private static Pac4jMessages log = (Pac4jMessages)MessagesFactory.get(Pac4jMessages.class);
    private static final ClientConfigurationDecorator PAC4J_CLIENT_CONFIGURATION_DECORATOR = new Pac4jClientConfigurationDecorator();
    public static final String TEST_BASIC_AUTH = "testBasicAuth";
    public static final String PAC4J_CALLBACK_URL = "pac4j.callbackUrl";
    public static final String PAC4J_CALLBACK_PARAMETER = "pac4jCallback";
    public static final String PAC4J_OICD_TYPE_AZURE = "azure";
    public static final String URL_PATH_SEPARATOR = "/";
    private static final String PAC4J_COOKIE_DOMAIN_SUFFIX_PARAM = "pac4j.cookie.domain.suffix";
    private static final String PAC4J_CONFIG = "pac4j.config";
    private static final String PAC4J_SESSION_STORE = "pac4j.session.store";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_GROUPS = "pac4j.session.store.exclude.groups";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_ROLES = "pac4j.session.store.exclude.roles";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_PERMISSIONS = "pac4j.session.store.exclude.permissions";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_GROUPS_DEFAULT = "true";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_ROLES_DEFAULT = "true";
    public static final String PAC4J_SESSION_STORE_EXCLUDE_PERMISSIONS_DEFAULT = "true";
    private static final String PAC4J_CLIENT_NAME_PARAM = "clientName";
    private static final String PAC4J_OIDC_TYPE = "oidc.type";
    private CallbackFilter callbackFilter;
    private SecurityFilter securityFilter;
    private MasterService masterService;
    private KeystoreService keystoreService;
    private AliasService aliasService;
    private Map<String, String> sessionStoreConfigs = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String clientName;
        Config config;
        ServletContext context = filterConfig.getServletContext();
        CryptoService cryptoService = null;
        String clusterName = null;
        if (context != null) {
            GatewayServices services = (GatewayServices)context.getAttribute("org.apache.knox.gateway.gateway.services");
            clusterName = (String)context.getAttribute("org.apache.knox.gateway.gateway.cluster");
            if (services != null) {
                this.keystoreService = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE);
                cryptoService = (CryptoService)services.getService(ServiceType.CRYPTO_SERVICE);
                this.aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
                this.masterService = (MasterService)services.getService(ServiceType.MASTER_SERVICE);
            }
        }
        if (cryptoService == null || this.aliasService == null || clusterName == null) {
            log.cryptoServiceAndAliasServiceAndClusterNameRequired();
            throw new ServletException("The crypto service, alias service and cluster name are required.");
        }
        try {
            this.aliasService.getPasswordFromAliasForCluster(clusterName, "pac4j.password", true);
        }
        catch (AliasServiceException e) {
            log.unableToGenerateAPasswordForEncryption((Exception)((Object)e));
            throw new ServletException("Unable to generate a password for encryption.");
        }
        String pac4jCallbackUrl = filterConfig.getInitParameter(PAC4J_CALLBACK_URL);
        if (pac4jCallbackUrl == null) {
            log.ssoAuthenticationProviderUrlRequired();
            throw new ServletException("Required pac4j callback URL is missing.");
        }
        String clientNameParameter = filterConfig.getInitParameter(PAC4J_CLIENT_NAME_PARAM);
        if (clientNameParameter == null) {
            log.clientNameParameterRequired();
            throw new ServletException("Required pac4j clientName parameter is missing.");
        }
        String oidcType = filterConfig.getInitParameter(PAC4J_OIDC_TYPE);
        pac4jCallbackUrl = AzureAdClient.class.getSimpleName().equals(clientNameParameter) || !StringUtils.isBlank((CharSequence)oidcType) && PAC4J_OICD_TYPE_AZURE.equals(oidcType) ? pac4jCallbackUrl + URL_PATH_SEPARATOR + PAC4J_CALLBACK_PARAMETER : CommonHelper.addParameter((String)pac4jCallbackUrl, (String)PAC4J_CALLBACK_PARAMETER, (String)"true");
        if (TEST_BASIC_AUTH.equalsIgnoreCase(clientNameParameter)) {
            IndirectBasicAuthClient indirectBasicAuthClient = new IndirectBasicAuthClient((Authenticator)new SimpleTestUsernamePasswordAuthenticator());
            indirectBasicAuthClient.setRealmName("Knox TEST");
            config = new Config(pac4jCallbackUrl, (Client)indirectBasicAuthClient);
            clientName = "IndirectBasicAuthClient";
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            Enumeration names = filterConfig.getInitParameterNames();
            this.addDefaultConfig(clientNameParameter, properties);
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                properties.put(key, this.resolveAlias(clusterName, key, filterConfig.getInitParameter(key)));
            }
            PropertiesConfigFactory propertiesConfigFactory = new PropertiesConfigFactory(pac4jCallbackUrl, properties);
            config = propertiesConfigFactory.build(new Object[0]);
            List clients = config.getClients().getClients();
            if (clients == null || clients.isEmpty()) {
                log.atLeastOnePac4jClientMustBeDefined();
                throw new ServletException("At least one pac4j client must be defined.");
            }
            clientName = CommonHelper.isBlank((String)clientNameParameter) ? ((Client)clients.get(0)).getName() : clientNameParameter;
            this.setSessionStoreConfig(filterConfig, PAC4J_SESSION_STORE_EXCLUDE_GROUPS, "true");
            this.setSessionStoreConfig(filterConfig, PAC4J_SESSION_STORE_EXCLUDE_ROLES, "true");
            this.setSessionStoreConfig(filterConfig, PAC4J_SESSION_STORE_EXCLUDE_PERMISSIONS, "true");
            PAC4J_CLIENT_CONFIGURATION_DECORATOR.decorateClients(clients, properties);
        }
        this.callbackFilter = new CallbackFilter();
        this.callbackFilter.init(filterConfig);
        this.callbackFilter.setConfigOnly(config);
        this.securityFilter = new SecurityFilter();
        this.securityFilter.setClients(clientName);
        this.securityFilter.setConfigOnly(config);
        String domainSuffix = filterConfig.getInitParameter(PAC4J_COOKIE_DOMAIN_SUFFIX_PARAM);
        String sessionStoreVar = filterConfig.getInitParameter(PAC4J_SESSION_STORE);
        Object sessionStore = !StringUtils.isBlank((CharSequence)sessionStoreVar) && JEESessionStore.class.getName().contains(sessionStoreVar) ? new JEESessionStore() : new KnoxSessionStore(cryptoService, clusterName, domainSuffix, this.sessionStoreConfigs);
        config.setSessionStore((SessionStore)sessionStore);
    }

    private void setSessionStoreConfig(FilterConfig filterConfig, String configName, String configDefault) {
        String configValue = filterConfig.getInitParameter(configName);
        this.sessionStoreConfigs.put(configName, configValue == null ? configDefault : configValue);
    }

    private String resolveAlias(String clusterName, String key, String value) throws ServletException {
        if (value.startsWith(ALIAS_PREFIX) && value.endsWith("}")) {
            String alias = value.substring(ALIAS_PREFIX.length(), value.length() - 1);
            try {
                return new String(this.aliasService.getPasswordFromAliasForCluster(clusterName, alias));
            }
            catch (AliasServiceException e) {
                throw new ServletException("Unable to retrieve alias for config: " + key, (Throwable)e);
            }
        }
        return value;
    }

    private void addDefaultConfig(String clientNameParameter, Map<String, String> properties) {
        if (clientNameParameter.contains(SAML2Client.class.getSimpleName())) {
            properties.put("saml.keystorePath", this.keystoreService.getKeystorePath());
            char[] giksp = null;
            try {
                giksp = this.aliasService.getGatewayIdentityKeystorePassword();
            }
            catch (AliasServiceException e) {
                log.noKeystorePasswordProvisioned((Exception)((Object)e));
            }
            if (giksp == null) {
                giksp = this.masterService.getMasterSecret();
            }
            properties.put("saml.keystorePassword", new String(giksp));
            char[] gip = null;
            try {
                gip = this.aliasService.getGatewayIdentityPassphrase();
            }
            catch (AliasServiceException ase) {
                log.noPrivateKeyPasshraseProvisioned((Exception)((Object)ase));
            }
            if (gip == null) {
                gip = this.masterService.getMasterSecret();
            }
            properties.put("saml.privateKeyPassword", new String(gip));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        request.setAttribute(PAC4J_CONFIG, (Object)this.securityFilter.getSharedConfig());
        if (request.getParameter(PAC4J_CALLBACK_PARAMETER) != null || request.getContextPath() != null && request.getRequestURI().contains(PAC4J_CALLBACK_PARAMETER)) {
            this.callbackFilter.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            this.securityFilter.doFilter(servletRequest, servletResponse, filterChain);
        }
    }

    public void destroy() {
    }
}

