/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.subject.PrincipalMap;
import org.apache.shiro.util.CollectionUtils;

public class SimplePrincipalMap
implements PrincipalMap {
    private Map<String, Map<String, Object>> realmPrincipals;
    private Map<String, Object> combinedPrincipals;

    public SimplePrincipalMap() {
        this(null);
    }

    public SimplePrincipalMap(Map<String, Map<String, Object>> backingMap) {
        if (!CollectionUtils.isEmpty(backingMap)) {
            this.realmPrincipals = backingMap;
            for (Map<String, Object> principals : this.realmPrincipals.values()) {
                if (CollectionUtils.isEmpty(principals)) continue;
                this.ensureCombinedPrincipals().putAll(principals);
            }
        }
    }

    @Override
    public int size() {
        return CollectionUtils.size(this.combinedPrincipals);
    }

    protected Map<String, Object> ensureCombinedPrincipals() {
        if (this.combinedPrincipals == null) {
            this.combinedPrincipals = new HashMap<String, Object>();
        }
        return this.combinedPrincipals;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    @Override
    public Object get(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    @Override
    public Object put(String s, Object o) {
        return this.ensureCombinedPrincipals().put(s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.combinedPrincipals != null ? this.combinedPrincipals.remove(o) : null;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        if (!CollectionUtils.isEmpty(map)) {
            this.ensureCombinedPrincipals().putAll(map);
        }
    }

    @Override
    public Set<String> keySet() {
        return CollectionUtils.isEmpty(this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableSet(this.combinedPrincipals.keySet());
    }

    @Override
    public Collection<Object> values() {
        return CollectionUtils.isEmpty(this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableCollection(this.combinedPrincipals.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return CollectionUtils.isEmpty(this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableSet(this.combinedPrincipals.entrySet());
    }

    @Override
    public void clear() {
        this.realmPrincipals = null;
        this.combinedPrincipals = null;
    }

    @Override
    public Object getPrimaryPrincipal() {
        return !CollectionUtils.isEmpty(this.combinedPrincipals) ? this.combinedPrincipals.values().iterator().next() : null;
    }

    @Override
    public <T> T oneByType(Class<T> type) {
        if (CollectionUtils.isEmpty(this.combinedPrincipals)) {
            return null;
        }
        for (Object value : this.combinedPrincipals.values()) {
            if (!type.isInstance(value)) continue;
            return type.cast(value);
        }
        return null;
    }

    @Override
    public <T> Collection<T> byType(Class<T> type) {
        if (CollectionUtils.isEmpty(this.combinedPrincipals)) {
            return Collections.emptySet();
        }
        List instances = null;
        for (Object value : this.combinedPrincipals.values()) {
            if (!type.isInstance(value)) continue;
            if (instances == null) {
                instances = new ArrayList();
            }
            instances.add(type.cast(value));
        }
        return instances != null ? instances : Collections.emptyList();
    }

    @Override
    public List asList() {
        if (CollectionUtils.isEmpty(this.combinedPrincipals)) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(this.combinedPrincipals.size());
        list.addAll(this.combinedPrincipals.values());
        return list;
    }

    @Override
    public Set asSet() {
        if (CollectionUtils.isEmpty(this.combinedPrincipals)) {
            return Collections.emptySet();
        }
        HashSet<Object> set = new HashSet<Object>(this.combinedPrincipals.size());
        set.addAll(this.combinedPrincipals.values());
        return set;
    }

    @Override
    public Collection fromRealm(String realmName) {
        if (CollectionUtils.isEmpty(this.realmPrincipals)) {
            return Collections.emptySet();
        }
        Map<String, Object> principals = this.realmPrincipals.get(realmName);
        if (CollectionUtils.isEmpty(principals)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(principals.values());
    }

    @Override
    public Set<String> getRealmNames() {
        if (CollectionUtils.isEmpty(this.realmPrincipals)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.realmPrincipals.keySet());
    }

    @Override
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.combinedPrincipals);
    }

    public Iterator iterator() {
        return this.asList().iterator();
    }

    @Override
    public Map<String, Object> getRealmPrincipals(String name) {
        if (this.realmPrincipals == null) {
            return null;
        }
        Map<String, Object> principals = this.realmPrincipals.get(name);
        if (principals == null) {
            return null;
        }
        return Collections.unmodifiableMap(principals);
    }

    @Override
    public Map<String, Object> setRealmPrincipals(String realmName, Map<String, Object> principals) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            if (!CollectionUtils.isEmpty(principals)) {
                this.realmPrincipals = new HashMap<String, Map<String, Object>>();
                return this.realmPrincipals.put(realmName, new HashMap<String, Object>(principals));
            }
            return null;
        }
        Map<String, Object> existingPrincipals = this.realmPrincipals.remove(realmName);
        if (!CollectionUtils.isEmpty(principals)) {
            this.realmPrincipals.put(realmName, new HashMap<String, Object>(principals));
        }
        return existingPrincipals;
    }

    @Override
    public Object setRealmPrincipal(String realmName, String principalName, Object principal) {
        Map<String, Object> principals;
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (principal == null) {
            return this.removeRealmPrincipal(realmName, principalName);
        }
        if (this.realmPrincipals == null) {
            this.realmPrincipals = new HashMap<String, Map<String, Object>>();
        }
        if ((principals = this.realmPrincipals.get(realmName)) == null) {
            principals = new HashMap<String, Object>();
            this.realmPrincipals.put(realmName, principals);
        }
        return principals.put(principalName, principal);
    }

    @Override
    public Object getRealmPrincipal(String realmName, String principalName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            return null;
        }
        Map<String, Object> principals = this.realmPrincipals.get(realmName);
        if (principals != null) {
            return principals.get(principalName);
        }
        return null;
    }

    @Override
    public Object removeRealmPrincipal(String realmName, String principalName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            return null;
        }
        Map<String, Object> principals = this.realmPrincipals.get(realmName);
        if (principals != null) {
            return principals.remove(principalName);
        }
        return null;
    }
}

