/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHostRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents an Impala Query.")
public class ApiImpalaQuery {
    @SerializedName(value="queryId")
    private String queryId = null;
    @SerializedName(value="statement")
    private String statement = null;
    @SerializedName(value="queryType")
    private String queryType = null;
    @SerializedName(value="queryState")
    private String queryState = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="rowsProduced")
    private BigDecimal rowsProduced = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="user")
    private String user = null;
    @SerializedName(value="coordinator")
    private ApiHostRef coordinator = null;
    @SerializedName(value="detailsAvailable")
    private Boolean detailsAvailable = null;
    @SerializedName(value="database")
    private String database = null;
    @SerializedName(value="durationMillis")
    private BigDecimal durationMillis = null;

    public ApiImpalaQuery queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    @ApiModelProperty(value="The query id.")
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public ApiImpalaQuery statement(String statement) {
        this.statement = statement;
        return this;
    }

    @ApiModelProperty(value="The SQL statement for the query.")
    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public ApiImpalaQuery queryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(value="The query type. The possible values are: DML, DDL, QUERY and UNKNOWN. See the Impala documentation for more details.")
    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public ApiImpalaQuery queryState(String queryState) {
        this.queryState = queryState;
        return this;
    }

    @ApiModelProperty(value="The query state. The possible values are: CREATED, INITIALIZED, COMPILED, RUNNING, FINISHED, EXCEPTION, and UNKNOWN. See the Impala documentation for more details.")
    public String getQueryState() {
        return this.queryState;
    }

    public void setQueryState(String queryState) {
        this.queryState = queryState;
    }

    public ApiImpalaQuery startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The time the query was issued.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiImpalaQuery endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The time the query finished. If the query hasn't finished then this will return null.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiImpalaQuery rowsProduced(BigDecimal rowsProduced) {
        this.rowsProduced = rowsProduced;
        return this;
    }

    @ApiModelProperty(value="The number of rows produced by the query. If the query hasn't completed this will return null.")
    public BigDecimal getRowsProduced() {
        return this.rowsProduced;
    }

    public void setRowsProduced(BigDecimal rowsProduced) {
        this.rowsProduced = rowsProduced;
    }

    public ApiImpalaQuery attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ApiImpalaQuery putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="A map of additional query attributes which is generated by Cloudera Manager.")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ApiImpalaQuery user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The user who issued this query.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ApiImpalaQuery coordinator(ApiHostRef coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    @ApiModelProperty(value="The host of the Impala Daemon coordinating the query")
    public ApiHostRef getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(ApiHostRef coordinator) {
        this.coordinator = coordinator;
    }

    public ApiImpalaQuery detailsAvailable(Boolean detailsAvailable) {
        this.detailsAvailable = detailsAvailable;
        return this;
    }

    @ApiModelProperty(value="Whether we have a detailed runtime profile available for the query. This profile is available at the endpoint /queries/{QUERY_ID}.")
    public Boolean getDetailsAvailable() {
        return this.detailsAvailable;
    }

    public void setDetailsAvailable(Boolean detailsAvailable) {
        this.detailsAvailable = detailsAvailable;
    }

    public ApiImpalaQuery database(String database) {
        this.database = database;
        return this;
    }

    @ApiModelProperty(value="The database on which this query was issued.")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public ApiImpalaQuery durationMillis(BigDecimal durationMillis) {
        this.durationMillis = durationMillis;
        return this;
    }

    @ApiModelProperty(value="The duration of the query in milliseconds. If the query hasn't completed then this will return null.")
    public BigDecimal getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(BigDecimal durationMillis) {
        this.durationMillis = durationMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiImpalaQuery apiImpalaQuery = (ApiImpalaQuery)o;
        return Objects.equals(this.queryId, apiImpalaQuery.queryId) && Objects.equals(this.statement, apiImpalaQuery.statement) && Objects.equals(this.queryType, apiImpalaQuery.queryType) && Objects.equals(this.queryState, apiImpalaQuery.queryState) && Objects.equals(this.startTime, apiImpalaQuery.startTime) && Objects.equals(this.endTime, apiImpalaQuery.endTime) && Objects.equals(this.rowsProduced, apiImpalaQuery.rowsProduced) && Objects.equals(this.attributes, apiImpalaQuery.attributes) && Objects.equals(this.user, apiImpalaQuery.user) && Objects.equals(this.coordinator, apiImpalaQuery.coordinator) && Objects.equals(this.detailsAvailable, apiImpalaQuery.detailsAvailable) && Objects.equals(this.database, apiImpalaQuery.database) && Objects.equals(this.durationMillis, apiImpalaQuery.durationMillis);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.statement, this.queryType, this.queryState, this.startTime, this.endTime, this.rowsProduced, this.attributes, this.user, this.coordinator, this.detailsAvailable, this.database, this.durationMillis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiImpalaQuery {\n");
        sb.append("    queryId: ").append(this.toIndentedString(this.queryId)).append("\n");
        sb.append("    statement: ").append(this.toIndentedString(this.statement)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString(this.queryType)).append("\n");
        sb.append("    queryState: ").append(this.toIndentedString(this.queryState)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    rowsProduced: ").append(this.toIndentedString(this.rowsProduced)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    coordinator: ").append(this.toIndentedString(this.coordinator)).append("\n");
        sb.append("    detailsAvailable: ").append(this.toIndentedString(this.detailsAvailable)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    durationMillis: ").append(this.toIndentedString(this.durationMillis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

