/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCmPeerType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about a Cloudera Manager peer instance. <p> The requirement and usage of <i>username</i> and <i>password</i> properties are dependent on the <i>clouderaManagerCreatedUser</i> flag. <p> When creating peers, if 'clouderaManagerCreatedUser' is true, the username/password should be the credentials of a user with administrator privileges on the remote Cloudera Manager. These credentials are not stored, they are used to connect to the peer and create a user in that peer. The newly created user is stored and used for communication with that peer. If 'clouderaManagerCreatedUser' is false, which is not applicable to REPLICATION peer type, the username/password to the remote Cloudera Manager are directly stored and used for all communications with that peer. <p> When updating peers, if 'clouderaManagerCreatedUser' is true and username/password are set, a new remote user will be created. If 'clouderaManagerCreatedUser' is false and username/password are set, the stored username/password will be updated.")
public class ApiCmPeer {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private ApiCmPeerType type = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="clouderaManagerCreatedUser")
    private Boolean clouderaManagerCreatedUser = null;

    public ApiCmPeer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the remote CM instance. Immutable during update.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCmPeer type(ApiCmPeerType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the remote CM instance. Immutable during update.  Available since API v11.")
    public ApiCmPeerType getType() {
        return this.type;
    }

    public void setType(ApiCmPeerType type) {
        this.type = type;
    }

    public ApiCmPeer url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="The URL of the remote CM instance. Mutable during update.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ApiCmPeer username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="When creating peers, if 'clouderaManagerCreatedUser' is true, this should be the remote admin username for creating a user in remote Cloudera Manager. The created remote user will then be stored in the local Cloudera Manager DB and used in later communication. If 'clouderaManagerCreatedUser' is false, which is not applicable to REPLICATION peer type, Cloudera Manager will store this username in the local DB directly and use it together with 'password' for communication.  Mutable during update. When set during update, if 'clouderaManagerCreatedUser' is true, a new user in remote Cloudera Manager is created, the newly created remote user will be stored in the local DB. An attempt to delete the previously created remote user will be made; If 'clouderaManagerCreatedUser' is false, the username/password in the local DB will be updated.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ApiCmPeer password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="When creating peers, if 'clouderaManagerCreatedUser' is true, this should be the remote admin password for creating a user in remote Cloudera Manager. The created remote user will then be stored in the local Cloudera Manager DB and used in later communication. If 'clouderaManagerCreatedUser' is false, which is not applicable to REPLICATION peer type, Cloudera Manager will store this password in the local DB directly and use it together with 'username' for communication.  Mutable during update. When set during update, if 'clouderaManagerCreatedUser' is true, a new user in remote Cloudera Manager is created, the newly created remote user will be stored in the local DB. An attempt to delete the previously created remote user will be made; If 'clouderaManagerCreatedUser' is false, the username/password in the local DB will be updated.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiCmPeer clouderaManagerCreatedUser(Boolean clouderaManagerCreatedUser) {
        this.clouderaManagerCreatedUser = clouderaManagerCreatedUser;
        return this;
    }

    @ApiModelProperty(value="If true, Cloudera Manager creates a remote user using the given username/password and stores the created user in local DB for use in later communication. Cloudera Manager will also try to delete the created remote user when deleting such peers.  If false, Cloudera Manager will store the provided username/password in the local DB and use them in later communication. 'false' value on this field is not applicable to REPLICATION peer type.  Available since API v11.  Immutable during update. Should not be set when updating peers.")
    public Boolean getClouderaManagerCreatedUser() {
        return this.clouderaManagerCreatedUser;
    }

    public void setClouderaManagerCreatedUser(Boolean clouderaManagerCreatedUser) {
        this.clouderaManagerCreatedUser = clouderaManagerCreatedUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCmPeer apiCmPeer = (ApiCmPeer)o;
        return Objects.equals(this.name, apiCmPeer.name) && Objects.equals((Object)this.type, (Object)apiCmPeer.type) && Objects.equals(this.url, apiCmPeer.url) && Objects.equals(this.username, apiCmPeer.username) && Objects.equals(this.password, apiCmPeer.password) && Objects.equals(this.clouderaManagerCreatedUser, apiCmPeer.clouderaManagerCreatedUser);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.url, this.username, this.password, this.clouderaManagerCreatedUser});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCmPeer {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    clouderaManagerCreatedUser: ").append(this.toIndentedString(this.clouderaManagerCreatedUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

