/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterTemplateConfig;
import com.cloudera.api.swagger.model.ApiClusterTemplateRole;
import com.cloudera.api.swagger.model.ApiClusterTemplateRoleConfigGroup;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Service information")
public class ApiClusterTemplateService {
    @SerializedName(value="refName")
    private String refName = null;
    @SerializedName(value="serviceType")
    private String serviceType = null;
    @SerializedName(value="serviceConfigs")
    private List<ApiClusterTemplateConfig> serviceConfigs = null;
    @SerializedName(value="roleConfigGroups")
    private List<ApiClusterTemplateRoleConfigGroup> roleConfigGroups = null;
    @SerializedName(value="roles")
    private List<ApiClusterTemplateRole> roles = null;
    @SerializedName(value="displayName")
    private String displayName = null;

    public ApiClusterTemplateService refName(String refName) {
        this.refName = refName;
        return this;
    }

    @ApiModelProperty(value="Reference name of the service. This could be referred by some configuration.")
    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public ApiClusterTemplateService serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(value="Service type")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public ApiClusterTemplateService serviceConfigs(List<ApiClusterTemplateConfig> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
        return this;
    }

    public ApiClusterTemplateService addServiceConfigsItem(ApiClusterTemplateConfig serviceConfigsItem) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<ApiClusterTemplateConfig>();
        }
        this.serviceConfigs.add(serviceConfigsItem);
        return this;
    }

    @ApiModelProperty(value="Service level configuration")
    public List<ApiClusterTemplateConfig> getServiceConfigs() {
        return this.serviceConfigs;
    }

    public void setServiceConfigs(List<ApiClusterTemplateConfig> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
    }

    public ApiClusterTemplateService roleConfigGroups(List<ApiClusterTemplateRoleConfigGroup> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
        return this;
    }

    public ApiClusterTemplateService addRoleConfigGroupsItem(ApiClusterTemplateRoleConfigGroup roleConfigGroupsItem) {
        if (this.roleConfigGroups == null) {
            this.roleConfigGroups = new ArrayList<ApiClusterTemplateRoleConfigGroup>();
        }
        this.roleConfigGroups.add(roleConfigGroupsItem);
        return this;
    }

    @ApiModelProperty(value="All role config groups for that service")
    public List<ApiClusterTemplateRoleConfigGroup> getRoleConfigGroups() {
        return this.roleConfigGroups;
    }

    public void setRoleConfigGroups(List<ApiClusterTemplateRoleConfigGroup> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
    }

    public ApiClusterTemplateService roles(List<ApiClusterTemplateRole> roles) {
        this.roles = roles;
        return this;
    }

    public ApiClusterTemplateService addRolesItem(ApiClusterTemplateRole rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<ApiClusterTemplateRole>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="List of roles for this service that are referred by some configuration.")
    public List<ApiClusterTemplateRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ApiClusterTemplateRole> roles) {
        this.roles = roles;
    }

    public ApiClusterTemplateService displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="Service display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplateService apiClusterTemplateService = (ApiClusterTemplateService)o;
        return Objects.equals(this.refName, apiClusterTemplateService.refName) && Objects.equals(this.serviceType, apiClusterTemplateService.serviceType) && Objects.equals(this.serviceConfigs, apiClusterTemplateService.serviceConfigs) && Objects.equals(this.roleConfigGroups, apiClusterTemplateService.roleConfigGroups) && Objects.equals(this.roles, apiClusterTemplateService.roles) && Objects.equals(this.displayName, apiClusterTemplateService.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.serviceType, this.serviceConfigs, this.roleConfigGroups, this.roles, this.displayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplateService {\n");
        sb.append("    refName: ").append(this.toIndentedString(this.refName)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    serviceConfigs: ").append(this.toIndentedString(this.serviceConfigs)).append("\n");
        sb.append("    roleConfigGroups: ").append(this.toIndentedString(this.roleConfigGroups)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

