/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This API class represents a request to retrieve Auto-TLS certificates for a given host. The request contains the host requesting the certificate, a valid token generated by the certmanager utility, and optionally a certificate signing request.  Currently, the certificate signing request argument is not supported.")
public class ApiCertificateRequest {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="csr")
    private String csr = null;
    @SerializedName(value="token")
    private String token = null;

    public ApiCertificateRequest hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(value="Get the hostname of the host requesting certificates")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ApiCertificateRequest csr(String csr) {
        this.csr = csr;
        return this;
    }

    @ApiModelProperty(value="Get the certificate signing request in PEM format")
    public String getCsr() {
        return this.csr;
    }

    public void setCsr(String csr) {
        this.csr = csr;
    }

    public ApiCertificateRequest token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="Get the certificate request token")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCertificateRequest apiCertificateRequest = (ApiCertificateRequest)o;
        return Objects.equals(this.hostname, apiCertificateRequest.hostname) && Objects.equals(this.csr, apiCertificateRequest.csr) && Objects.equals(this.token, apiCertificateRequest.token);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.csr, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCertificateRequest {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    csr: ").append(this.toIndentedString(this.csr)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

