/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;
import org.apache.knox.gateway.provider.federation.jwt.filter.JWTFederationFilter;

@Messages(logger="org.apache.knox.gateway.provider.federation.jwt")
public interface JWTMessages {
    @Message(level=MessageLevel.WARN, text="Failed to validate the audience attribute for token {0} ({1})")
    public void failedToValidateAudience(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Failed to verify the token signature of {0} ({1})")
    public void failedToVerifyTokenSignature(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Access token {0} ({1}) has expired; a new one must be acquired.")
    public void tokenHasExpired(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Access token {0} has expired; a new one must be acquired.")
    public void tokenHasExpired(String var1);

    @Message(level=MessageLevel.ERROR, text="Received wrong passcode token for {0}")
    public void wrongPasscodeToken(String var1);

    @Message(level=MessageLevel.INFO, text="The NotBefore check failed.")
    public void notBeforeCheckFailed();

    @Message(level=MessageLevel.WARN, text="Expected Bearer token is missing.")
    public void missingBearerToken();

    @Message(level=MessageLevel.INFO, text="Unable to verify token: {0}")
    public void unableToVerifyToken(@StackTrace(level=MessageLevel.ERROR) Exception var1);

    @Message(level=MessageLevel.WARN, text="Unable to verify token expiration: {0}")
    public void unableToVerifyExpiration(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Unable to issue token: {0}")
    public void unableToIssueToken(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Sending redirect to: {0}")
    public void sendRedirectToLoginURL(String var1);

    @Message(level=MessageLevel.WARN, text="Configuration for authentication provider URL is missing - will derive default URL.")
    public void missingAuthenticationProviderUrlConfiguration();

    @Message(level=MessageLevel.DEBUG, text="Audience claim has been validated.")
    public void jwtAudienceValidated();

    @Message(level=MessageLevel.INFO, text="Request {0} matches unauthenticated path list {1}, letting it through")
    public void unauthenticatedPathBypass(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Error while checking whether path {0} should be allowed unauthenticated access : {1}")
    public void unauthenticatedPathError(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Unable to derive authentication provider URL: {0}")
    public void failedToDeriveAuthenticationProviderUrl(@StackTrace(level=MessageLevel.ERROR) Exception var1);

    @Message(level=MessageLevel.ERROR, text="The configuration value ({0}) for maximum token verification cache is invalid; Using the default value.")
    public void invalidVerificationCacheMaxConfiguration(String var1);

    @Message(level=MessageLevel.ERROR, text="Missing token passcode.")
    public void missingTokenPasscode();

    @Message(level=MessageLevel.INFO, text="Initialized token signature verification cache for the {0} topology.")
    public void initializedSignatureVerificationCache(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to parse passcode token: {0}")
    public void failedToParsePasscodeToken(@StackTrace(level=MessageLevel.ERROR) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Token is disabled: {0}")
    public void disabledToken(String var1);

    @Message(level=MessageLevel.INFO, text="Missing token: {0}")
    public void missingTokenFromHeader(Pair<JWTFederationFilter.TokenType, String> var1);
}

