/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;

public final class ExtendedRequestFactory
implements Messagefactory {
    public static final ExtendedRequestFactory INSTANCE = new ExtendedRequestFactory();

    private ExtendedRequestFactory() {
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        ExtendedRequest extendedRequest = (ExtendedRequest)message;
        ExtendedOperationFactory factory = codec.getExtendedRequestFactories().get(extendedRequest.getRequestName());
        if (factory != null) {
            factory.encodeValue(buffer, extendedRequest);
            if (buffer.getPos() > start) {
                BerValue.encodeSequence((Asn1Buffer)buffer, (byte)-127, (int)start);
            }
        }
        if (!Strings.isEmpty((String)extendedRequest.getRequestName())) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)-128, (String)extendedRequest.getRequestName());
        }
        BerValue.encodeSequence((Asn1Buffer)buffer, (byte)119, (int)start);
    }
}

