/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.handler.AbstractSearchEntryHandler;
import org.ldaptive.handler.HandlerResult;

public class RecursiveEntryHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 829;
    private String searchAttribute;
    private String[] mergeAttributes;
    private String[] retAttrs;

    public RecursiveEntryHandler() {
    }

    public RecursiveEntryHandler(String searchAttr, String ... mergeAttrs) {
        this.searchAttribute = searchAttr;
        this.mergeAttributes = mergeAttrs;
        this.initalizeReturnAttributes();
    }

    public String getSearchAttribute() {
        return this.searchAttribute;
    }

    public void setSearchAttribute(String name) {
        this.searchAttribute = name;
        this.initalizeReturnAttributes();
    }

    public String[] getMergeAttributes() {
        return this.mergeAttributes;
    }

    public void setMergeAttributes(String ... mergeAttrs) {
        this.mergeAttributes = mergeAttrs;
        this.initalizeReturnAttributes();
    }

    protected void initalizeReturnAttributes() {
        if (this.mergeAttributes != null && this.searchAttribute != null) {
            this.retAttrs = new String[this.mergeAttributes.length + 1];
            System.arraycopy(this.mergeAttributes, 0, this.retAttrs, 0, this.mergeAttributes.length);
            this.retAttrs[this.retAttrs.length - 1] = this.searchAttribute;
        }
    }

    @Override
    public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        ArrayList<String> searchedDns = new ArrayList<String>();
        if (entry.getAttribute(this.searchAttribute) != null) {
            searchedDns.add(entry.getDn());
            this.readSearchAttribute(conn, entry, searchedDns);
        } else {
            this.recursiveSearch(conn, entry.getDn(), entry, searchedDns);
        }
        return new HandlerResult<SearchEntry>(entry);
    }

    private void readSearchAttribute(Connection conn, LdapEntry entry, List<String> searchedDns) throws LdapException {
        LdapAttribute attr;
        if (entry != null && (attr = entry.getAttribute(this.searchAttribute)) != null && !attr.isBinary()) {
            HashSet<String> values = new HashSet<String>(attr.getStringValues());
            for (String s : values) {
                this.recursiveSearch(conn, s, entry, searchedDns);
            }
        }
    }

    private void recursiveSearch(Connection conn, String dn, LdapEntry entry, List<String> searchedDns) throws LdapException {
        if (!searchedDns.contains(dn)) {
            LdapEntry newEntry = null;
            try {
                SearchOperation search = new SearchOperation(conn);
                SearchRequest sr = SearchRequest.newObjectScopeSearchRequest(dn, this.retAttrs);
                SearchResult result = (SearchResult)search.execute(sr).getResult();
                newEntry = result.getEntry(dn);
            }
            catch (LdapException e) {
                this.logger.warn("Error retrieving attribute(s): {}", (Object)Arrays.toString(this.retAttrs), (Object)e);
            }
            searchedDns.add(dn);
            if (newEntry != null) {
                this.readSearchAttribute(conn, newEntry, searchedDns);
                for (String s : this.mergeAttributes) {
                    LdapAttribute newAttr = newEntry.getAttribute(s);
                    if (newAttr == null) continue;
                    LdapAttribute oldAttr = entry.getAttribute(s);
                    if (oldAttr == null) {
                        entry.addAttribute(newAttr);
                        continue;
                    }
                    if (newAttr.isBinary()) {
                        for (Object value : newAttr.getBinaryValues()) {
                            oldAttr.addBinaryValue(new byte[][]{value});
                        }
                        continue;
                    }
                    Iterator<Object> i$ = newAttr.getStringValues().iterator();
                    while (i$.hasNext()) {
                        Object value;
                        value = (String)i$.next();
                        oldAttr.addStringValue(new String[]{value});
                    }
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RecursiveEntryHandler) {
            RecursiveEntryHandler v = (RecursiveEntryHandler)o;
            return LdapUtils.areEqual(this.mergeAttributes, v.mergeAttributes) && LdapUtils.areEqual(this.retAttrs, v.retAttrs) && LdapUtils.areEqual(this.searchAttribute, v.searchAttribute);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(829, this.mergeAttributes, this.retAttrs, this.searchAttribute);
    }

    public String toString() {
        return String.format("[%s@%d::searchAttribute=%s, mergeAttributes=%s, retAttrs=%s]", this.getClass().getName(), this.hashCode(), this.searchAttribute, Arrays.toString(this.mergeAttributes), Arrays.toString(this.retAttrs));
    }
}

