/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;

public class DefaultHaDescriptor
implements HaDescriptor {
    private ConcurrentHashMap<String, HaServiceConfig> serviceConfigs = new ConcurrentHashMap();

    @Override
    public void addServiceConfig(HaServiceConfig serviceConfig) {
        if (serviceConfig == null) {
            throw new IllegalArgumentException("Service config must not be null");
        }
        this.serviceConfigs.put(serviceConfig.getServiceName(), serviceConfig);
    }

    @Override
    public HaServiceConfig getServiceConfig(String serviceName) {
        return this.serviceConfigs.get(serviceName);
    }

    @Override
    public List<HaServiceConfig> getServiceConfigs() {
        return new ArrayList<HaServiceConfig>(this.serviceConfigs.values());
    }

    @Override
    public List<String> getServiceNames() {
        return new ArrayList<String>(this.serviceConfigs.keySet());
    }

    @Override
    public List<String> getEnabledServiceNames() {
        ArrayList<String> services = new ArrayList<String>(this.serviceConfigs.size());
        Collection<HaServiceConfig> configs = this.serviceConfigs.values();
        for (HaServiceConfig config : configs) {
            if (!config.isEnabled()) continue;
            services.add(config.getServiceName());
        }
        return services;
    }
}

