/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.services.token.state")
public interface TokenStateServiceMessages {
    @Message(level=MessageLevel.DEBUG, text="Added token {0}, expiration {1}")
    public void addedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Renewed token {0}, expiration {1}")
    public void renewedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Revoked token {0}")
    public void revokedToken(String var1);

    @Message(level=MessageLevel.DEBUG, text="Removed state for tokens {0}")
    public void removedTokenState(String var1);

    @Message(level=MessageLevel.ERROR, text="Unknown token {0}")
    public void unknownToken(String var1);

    @Message(level=MessageLevel.ERROR, text="The renewal limit for the token ({0}) has been exceeded.")
    public void renewalLimitExceeded(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to save state for token {0} : {1}")
    public void failedToSaveTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error accessing token state : {0}")
    public void errorAccessingTokenState(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Error accessing state for token {0} : {1}")
    public void errorAccessingTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Referencing the expiration in the token ({0}) because no state could not be found: {1}")
    public void permissiveTokenHandling(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to update expiration for token {0} : {1}")
    public void failedToUpdateTokenExpiration(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to create token state aliases : {0}")
    public void failedToCreateTokenStateAliases(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to remove state for token {0} : {1}")
    public void failedToRemoveTokenStateAliases(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove token state aliases : {0}")
    public void failedToRemoveTokenStateAliases(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Skipping expired token eviction")
    public void skipEviction();

    @Message(level=MessageLevel.ERROR, text="Failed to evict expired token {0} : {1}")
    public void failedExpiredTokenEviction(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to evict expired tokens : {0}")
    public void failedExpiredTokenEviction(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Evicting expired token {0}")
    public void evictToken(String var1);

    @Message(level=MessageLevel.ERROR, text="Error occurred evicting token {0}")
    public void errorEvictingTokens(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Creating token state aliases")
    public void creatingTokenStateAliases();

    @Message(level=MessageLevel.DEBUG, text="Creating token state aliases for {0}")
    public void creatingTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Created token state aliases for {0}")
    public void createdTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Removing token state aliases")
    public void removingTokenStateAliases();

    @Message(level=MessageLevel.DEBUG, text="Removing token state aliases for {0}")
    public void removingTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Removed token state aliases for {0}")
    public void removedTokenStateAliases(String var1);

    @Message(level=MessageLevel.DEBUG, text="Loading peristed token state journal entries")
    public void loadingPersistedJournalEntries();

    @Message(level=MessageLevel.DEBUG, text="Loaded peristed token state journal entry for {0}")
    public void loadedPersistedJournalEntry(String var1);

    @Message(level=MessageLevel.ERROR, text="The peristed token state journal entry {0} is empty")
    public void emptyJournalEntry(String var1);

    @Message(level=MessageLevel.DEBUG, text="Added token state journal entry for {0}")
    public void addedJournalEntry(String var1);

    @Message(level=MessageLevel.DEBUG, text="Removed token state journal entry for {0}")
    public void removedJournalEntry(String var1);

    @Message(level=MessageLevel.INFO, text="Token state journal entry not found for {0}")
    public void journalEntryNotFound(String var1);

    @Message(level=MessageLevel.DEBUG, text="Persisting token state journal entry as {0}")
    public void persistingJournalEntry(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted token state journal entry for {0} : {1}")
    public void failedToLoadJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted token state journal entry : {0}")
    public void failedToLoadJournalEntry(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to persisting token state journal entry for {0} : {1}")
    public void failedToPersistJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to add a token state journal entry for {0} : {1}")
    public void failedToAddJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove the token state journal entry for {0} : {1}")
    public void failedToRemoveJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove the token state journal entries : {0}")
    public void failedToRemoveJournalEntries(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Loading Gateway credentials on startup...")
    public void loadingGatewayCredentialsOnStartup();

    @Message(level=MessageLevel.INFO, text="Loaded {0} Gateway credentials in {1} milliseonds")
    public void loadedGatewayCredentialsOnStartup(int var1, long var2);

    @Message(level=MessageLevel.ERROR, text="Error while loading Gateway credentials on startup: {0}")
    public void errorWhileLoadingGatewayCredentialsOnStartup(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);
}

