/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;
import org.apache.knox.gateway.services.security.KeystoreServiceException;

@Messages(logger="org.apache.knox.gateway")
public interface GatewayMessages {
    @Message(level=MessageLevel.FATAL, text="Failed to parse command line: {0}")
    public void failedToParseCommandLine(@StackTrace(level=MessageLevel.FATAL) ParseException var1);

    @Message(level=MessageLevel.INFO, text="Starting gateway...")
    public void startingGateway();

    @Message(level=MessageLevel.FATAL, text="Failed to start gateway: {0}")
    public void failedToStartGateway(@StackTrace(level=MessageLevel.FATAL) Exception var1);

    @Message(level=MessageLevel.INFO, text="Started gateway on port {0}.")
    public void startedGateway(int var1);

    @Message(level=MessageLevel.INFO, text="Stopping gateway...")
    public void stoppingGateway();

    @Message(level=MessageLevel.INFO, text="Stopped gateway.")
    public void stoppedGateway();

    @Message(level=MessageLevel.INFO, text="Failed to stopped gateway.")
    public void failedToStopGateway(@StackTrace(level=MessageLevel.INFO) Exception var1);

    @Message(level=MessageLevel.INFO, text="Loading configuration resource {0}")
    public void loadingConfigurationResource(String var1);

    @Message(level=MessageLevel.INFO, text="Loading configuration file {0}")
    public void loadingConfigurationFile(String var1);

    @Message(level=MessageLevel.WARN, text="Failed to load configuration file {0}: {1}")
    public void failedToLoadConfig(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Using {1} as GATEWAY_HOME via {0}.")
    public void settingGatewayHomeDir(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Loading topologies from directory: {0}")
    public void loadingTopologiesFromDirectory(String var1);

    @Message(level=MessageLevel.DEBUG, text="Loading topology file: {0}")
    public void loadingTopologyFile(String var1);

    @Message(level=MessageLevel.INFO, text="Configured monitoring topologies in directory: {0}")
    public void configuredMonitoringTopologyChangesInDirectory(String var1);

    @Message(level=MessageLevel.INFO, text="Deploying topology {0} to {1}")
    public void deployingTopology(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Deployed topology {0}.")
    public void deployedTopology(String var1);

    @Message(level=MessageLevel.INFO, text="Loading topology {0} from {1}")
    public void redeployingTopology(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Redeployed topology {0}.")
    public void redeployedTopology(String var1);

    @Message(level=MessageLevel.INFO, text="Activating topology {0}")
    public void activatingTopology(String var1);

    @Message(level=MessageLevel.INFO, text="Activating topology {0} archive {1}")
    public void activatingTopologyArchive(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Deactivating topology {0}")
    public void deactivatingTopology(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to deploy topology {0}: {1}")
    public void failedToDeployTopology(String var1, @StackTrace(level=MessageLevel.DEBUG) Throwable var2);

    @Message(level=MessageLevel.ERROR, text="Failed to redeploy topology {0}")
    public void failedToRedeployTopology(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to redeploy topology {0}: {1}")
    public void failedToRedeployTopology(String var1, @StackTrace(level=MessageLevel.DEBUG) Throwable var2);

    @Message(level=MessageLevel.ERROR, text="Failed to load topology {0}: Topology configuration is invalid!")
    public void failedToLoadTopology(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to redeploy topologies: {0}")
    public void failedToRedeployTopologies(@StackTrace(level=MessageLevel.DEBUG) Throwable var1);

    @Message(level=MessageLevel.ERROR, text="Failed to undeploy topology {0}: {1}")
    public void failedToUndeployTopology(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.WARN, text="Failed to validate topology {0} error {1}. Please consider using descriptors instead of topologies")
    public void failedToValidateTopology(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Deleting topology {0}")
    public void deletingTopology(String var1);

    @Message(level=MessageLevel.INFO, text="Deleting deployed topology {0}")
    public void deletingDeployment(String var1);

    @Message(level=MessageLevel.DEBUG, text="Purge backups of deployed topology {0}")
    public void cleanupDeployments(String var1);

    @Message(level=MessageLevel.INFO, text="Deleting backup deployed topology {0}")
    public void cleanupDeployment(String var1);

    @Message(level=MessageLevel.INFO, text="Creating gateway home directory: {0}")
    public void creatingGatewayHomeDir(File var1);

    @Message(level=MessageLevel.INFO, text="Creating gateway deployment directory: {0}")
    public void creatingGatewayDeploymentDir(File var1);

    @Message(level=MessageLevel.INFO, text="Creating default gateway configuration file: {0}")
    public void creatingDefaultConfigFile(File var1);

    @Message(level=MessageLevel.INFO, text="Creating sample topology file: {0}")
    public void creatingDefaultTopologyFile(File var1);

    @Message(level=MessageLevel.WARN, text="Ignoring service deployment contributor with invalid null name: {0}")
    public void ignoringServiceContributorWithMissingName(String var1);

    @Message(level=MessageLevel.WARN, text="Ignoring service deployment contributor with invalid null role: {0}")
    public void ignoringServiceContributorWithMissingRole(String var1);

    @Message(level=MessageLevel.WARN, text="Ignoring service deployment contributor with invalid null version: {0}")
    public void ignoringServiceContributorWithMissingVersion(String var1);

    @Message(level=MessageLevel.WARN, text="Ignoring provider deployment contributor with invalid null name: {0}")
    public void ignoringProviderContributorWithMissingName(String var1);

    @Message(level=MessageLevel.WARN, text="Ignoring provider deployment contributor with invalid null role: {0}")
    public void ignoringProviderContributorWithMissingRole(String var1);

    @Message(level=MessageLevel.INFO, text="Loaded logging configuration: {0}")
    public void loadedLoggingConfig(String var1);

    @Message(level=MessageLevel.WARN, text="Failed to load logging configuration: {0}")
    public void failedToLoadLoggingConfig(String var1);

    @Message(level=MessageLevel.INFO, text="Creating credential store for the gateway instance.")
    public void creatingCredentialStoreForGateway();

    @Message(level=MessageLevel.INFO, text="Credential store for the gateway instance found - no need to create one.")
    public void credentialStoreForGatewayFoundNotCreating();

    @Message(level=MessageLevel.INFO, text="Creating keystore for the gateway instance.")
    public void creatingKeyStoreForGateway();

    @Message(level=MessageLevel.ERROR, text="Unable to obtain the password for the keystore for the gateway instance: {0}")
    public void failedToGetPasswordForGatewayIdentityKeystore(Exception var1);

    @Message(level=MessageLevel.ERROR, text="Unable to obtain the password for the gateway identity key: {0}")
    public void failedToGetPassphraseForGatewayIdentityKey(Exception var1);

    @Message(level=MessageLevel.INFO, text="Keystore for the gateway instance found - no need to create one.")
    public void keyStoreForGatewayFoundNotCreating();

    @Message(level=MessageLevel.INFO, text="Creating credential store for the cluster: {0}")
    public void creatingCredentialStoreForCluster(String var1);

    @Message(level=MessageLevel.INFO, text="Credential store found for the cluster: {0} - no need to create one.")
    public void credentialStoreForClusterFoundNotCreating(String var1);

    @Message(level=MessageLevel.WARN, text="An existing credential store found for the cluster {0} with a different type of {1}")
    public void credentialStoreForClusterFoundWithDifferentType(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Unable to obtain the password for the gateway truststore using the alias {0}: {1}")
    public void failedToGetPasswordForGatewayTruststore(String var1, Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Received request: {0} {1}")
    public void receivedRequest(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Dispatch request: {0} {1}")
    public void dispatchRequest(String var1, URI var2);

    @Message(level=MessageLevel.WARN, text="Connection exception dispatching request: {0} {1}")
    public void dispatchServiceConnectionException(URI var1, @StackTrace(level=MessageLevel.WARN) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Signature verified: {0}")
    public void signatureVerified(boolean var1);

    @Message(level=MessageLevel.DEBUG, text="Apache Knox Gateway {0} ({1})")
    public void gatewayVersionMessage(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to inject service {0}: {1}")
    public void failedToInjectService(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to finalize contribution: {0}")
    public void failedToFinalizeContribution(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to contribute service [role={1}, name={0}]: {2}")
    public void failedToContributeService(String var1, String var2, @StackTrace(level=MessageLevel.ERROR) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to contribute provider [role={1}, name={0}]: {2}")
    public void failedToContributeProvider(String var1, String var2, @StackTrace(level=MessageLevel.ERROR) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to initialize contribution: {0}")
    public void failedToInitializeContribution(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to initialize servlet instance: {0}")
    public void failedToInitializeServletInstace(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Gateway processing failed: {0}")
    public void failedToExecuteFilter(@StackTrace(level=MessageLevel.INFO) Throwable var1);

    @Message(level=MessageLevel.ERROR, text="Failed to load topology {0}: {1}")
    public void failedToLoadTopology(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to load topology {0}, retrying after {1}ms: {2}")
    public void failedToLoadTopologyRetrying(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to handle topology events: {0}")
    public void failedToHandleTopologyEvents(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to reload topologies: {0}")
    public void failedToReloadTopologies(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.FATAL, text="Unsupported encoding: {0}")
    public void unsupportedEncoding(@StackTrace(level=MessageLevel.FATAL) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to persist master secret: {0}")
    public void failedToPersistMasterSecret(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to encrypt master secret: {0}")
    public void failedToEncryptMasterSecret(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to initialize master service from persistent master {0}: {1}")
    public void failedToInitializeFromPersistentMaster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to encode passphrase: {0}")
    public void failedToEncodePassphrase(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to verify signature: {0}")
    public void failedToVerifySignature(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to sign the data: {0}")
    public void failedToSignData(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to decrypt password for cluster {0}: {1}")
    public void failedToDecryptPasswordForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to encrypt password for cluster {0}: {1}")
    public void failedToEncryptPasswordForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to create keystore [filename={0}, type={1}]: {2}")
    public void failedToCreateKeystore(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to load keystore [filename={0}, type={1}]: {2}")
    public void failedToLoadKeystore(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to add key for cluster {0}: {1}")
    public void failedToAddKeyForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to add credential for cluster {0}: {1}")
    public void failedToAddCredentialForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to add credentials for cluster {0}: {1}")
    public void failedToAddCredentialsForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to get key for Gateway {0}: {1}")
    public void failedToGetKeyForGateway(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to get credential for cluster {0}: {1}")
    public void failedToGetCredentialForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to get key for cluster {0}: {1}")
    public void failedToGetKeyForCluster(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to add self signed certificate for Gateway {0}: {1}")
    public void failedToAddSeflSignedCertForGateway(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to generate secret key from password: {0}")
    public void failedToGenerateKeyFromPassword(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to establish connection to {0}: {1}")
    public void failedToEstablishConnectionToUrl(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to interpret property \"{0}\": {1}")
    public void failedToInterpretProperty(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to instantiate the internal gateway services.")
    public void failedToInstantiateGatewayServices();

    @Message(level=MessageLevel.ERROR, text="Failed to serialize map to Json string {0}: {1}")
    public void failedToSerializeMapToJSON(Map<String, Object> var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to get map from Json string {0}: {1}")
    public void failedToGetMapFromJsonString(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Successful Knox->Hadoop SPNegotiation authentication for URL: {0}")
    public void successfulSPNegoAuthn(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed Knox->Hadoop SPNegotiation authentication for URL: {0}")
    public void failedSPNegoAuthn(String var1);

    @Message(level=MessageLevel.DEBUG, text="Dispatch response status: {0}")
    public void dispatchResponseStatusCode(int var1);

    @Message(level=MessageLevel.DEBUG, text="Dispatch response status: {0}, Location: {1}")
    public void dispatchResponseCreatedStatusCode(int var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to decrypt cipher text for cluster {0}: due to inability to retrieve the password.")
    public void failedToDecryptCipherForClusterNullPassword(String var1);

    @Message(level=MessageLevel.DEBUG, text="Gateway services have not been initialized.")
    public void gatewayServicesNotInitialized();

    @Message(level=MessageLevel.INFO, text="The Gateway SSL certificate is issued to hostname: {0}.")
    public void certificateHostNameForGateway(String var1);

    @Message(level=MessageLevel.INFO, text="The Gateway SSL certificate is valid between: {0} and {1}.")
    public void certificateValidityPeriod(Date var1, Date var2);

    @Message(level=MessageLevel.ERROR, text="Unable to retrieve certificate for Gateway: {0}.")
    public void unableToRetrieveCertificateForGateway(Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to generate alias for cluster: {0} {1}.")
    public void failedToGenerateAliasForCluster(String var1, KeystoreServiceException var2);

    @Message(level=MessageLevel.DEBUG, text="Key passphrase not found in credential store - using master secret.")
    public void assumingKeyPassphraseIsMaster();

    @Message(level=MessageLevel.ERROR, text="Failed to remove alias for cluster: {0} {1}.")
    public void failedToRemoveCredentialForCluster(String var1, Exception var2);

    @Message(level=MessageLevel.WARN, text="Failed to match path {0}")
    public void failedToMatchPath(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to get system ldap connection: {0}")
    public void failedToGetSystemLdapConnection(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.WARN, text="Value not found for cluster:{0}, alias: {1}")
    public void aliasValueNotFound(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Computed userDn: {0} using dnTemplate for principal: {1}")
    public void computedUserDn(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Searching from {0} where {1} scope {2}")
    public void searchBaseFilterScope(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Computed userDn: {0} using ldapSearch for principal: {1}")
    public void searchedAndFoundUserDn(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Computed roles/groups: {0} for principal: {1}")
    public void lookedUpUserRoles(Set<String> var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Initialize provider: {1}/{0}")
    public void initializeProvider(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Initialize service: {1}/{0}")
    public void initializeService(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Contribute provider: {1}/{0}")
    public void contributeProvider(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Contribute service: {1}/{0}")
    public void contributeService(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Finalize provider: {1}/{0}")
    public void finalizeProvider(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Finalize service: {1}/{0}")
    public void finalizeService(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Configured services directory is {0}")
    public void usingServicesDirectory(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to unmarshall service definition file {0} file : {1}")
    public void failedToLoadServiceDefinition(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to find service definition file {0} file : {1}")
    public void failedToFindServiceDefinitionFile(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to find rewrite file {0} file : {1}")
    public void failedToFindRewriteFile(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to unmarshall rewrite file {0} file : {1}")
    public void failedToLoadRewriteFile(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="No rewrite file found in service directory {0}")
    public void noRewriteFileFound(String var1);

    @Message(level=MessageLevel.DEBUG, text="Added Service definition name: {0}, role : {1}, version : {2}")
    public void addedServiceDefinition(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="System Property: {0}={1}")
    public void logSysProp(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Unable to get password: {0}")
    public void unableToGetPassword(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Initialize application: {0}")
    public void initializeApplication(String var1);

    @Message(level=MessageLevel.DEBUG, text="Contribute application: {0}")
    public void contributeApplication(String var1);

    @Message(level=MessageLevel.DEBUG, text="Finalize application: {0}")
    public void finalizeApplication(String var1);

    @Message(level=MessageLevel.INFO, text="Default topology {0} at {1}")
    public void defaultTopologySetup(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Default topology forward from {0} to {1}")
    public void defaultTopologyForward(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Unable to setup PagedResults")
    public void unableToSetupPagedResults();

    @Message(level=MessageLevel.INFO, text="Ignoring PartialResultException")
    public void ignoringPartialResultException();

    @Message(level=MessageLevel.WARN, text="Only retrieved first {0} groups due to SizeLimitExceededException.")
    public void sizeLimitExceededOnlyRetrieved(int var1);

    @Message(level=MessageLevel.DEBUG, text="Failed to parse path into Template: {0} : {1}")
    public void failedToParsePath(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Failed to initialize metrics reporter {0}  : {1}")
    public void failedToInitializeReporter(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Failed to start metrics reporter {0}  : {1}")
    public void failedToStartReporter(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Failed to stop metrics reporter {0}  : {1}")
    public void failedToStopReporter(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Cookie scoping feature enabled: {0}")
    public void cookieScopingFeatureEnabled(boolean var1);

    @Message(level=MessageLevel.INFO, text="Topology port mapping feature enabled: {0}")
    public void gatewayTopologyPortMappingEnabled(boolean var1);

    @Message(level=MessageLevel.ERROR, text="No topology mapped to port: {0}")
    public void noTopologyMappedToPort(int var1);

    @Message(level=MessageLevel.ERROR, text="Could not find topology {0} specified in port mapping config")
    public void noMappedTopologyFound(String var1);

    @Message(level=MessageLevel.DEBUG, text="Creating a connector for topology {0} listening on port {1}.")
    public void createJettyConnector(String var1, int var2);

    @Message(level=MessageLevel.DEBUG, text="Creating a handler for topology {0}.")
    public void createJettyHandler(String var1);

    @Message(level=MessageLevel.INFO, text="Updating request context from {0} to {1}")
    public void topologyPortMappingAddContext(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Updating request target from {0} to {1}")
    public void topologyPortMappingUpdateRequest(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Port {0} configured for Topology - {1} is already in use.")
    public void portAlreadyInUse(int var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Port {0} is already in use.")
    public void portAlreadyInUse(int var1);

    @Message(level=MessageLevel.INFO, text="Started gateway, topology \"{0}\" listening on port \"{1}\".")
    public void startedGateway(String var1, int var2);

    @Message(level=MessageLevel.ERROR, text="Topology \"{0}\" failed to start listening on port \"{1}\".")
    public void startedGatewayPortConflict(String var1, int var2);

    @Message(level=MessageLevel.ERROR, text=" Could not find topology \"{0}\" mapped to port \"{1}\" configured in gateway-config.xml. This invalid topology mapping will be ignored by the gateway. Gateway restart will be required if in the future \"{0}\" topology is added.")
    public void topologyPortMappingCannotFindTopology(String var1, int var2);

    @Message(level=MessageLevel.ERROR, text="Port mapped topology {0} cannot be configured as default topology")
    public void defaultTopologyInPortmappedTopology(String var1);

    @Message(level=MessageLevel.WARN, text="There is no registry client defined for remote configuration monitoring.")
    public void missingClientConfigurationForRemoteMonitoring();

    @Message(level=MessageLevel.WARN, text="Could not resolve a remote configuration registry client for {0}.")
    public void unresolvedClientConfigurationForRemoteMonitoring(String var1);

    @Message(level=MessageLevel.INFO, text="Configured monitoring simple descriptors in directory: {0}")
    public void configuredMonitoringDescriptorChangesInDirectory(String var1);

    @Message(level=MessageLevel.INFO, text="Configured monitoring shared provider configurations in directory: {0}")
    public void configuredMonitoringProviderConfigChangesInDirectory(String var1);

    @Message(level=MessageLevel.INFO, text="Started monitoring {0}")
    public void startedMonitor(String var1);

    @Message(level=MessageLevel.INFO, text="Stopped monitoring {0}")
    public void stoppedMonitor(String var1);

    @Message(level=MessageLevel.ERROR, text="Error registering listener for remote configuration path {0} : {1}")
    public void errorAddingRemoteConfigurationListenerForPath(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error unregistering listener for remote configuration path {0} : {1}")
    public void errorRemovingRemoteConfigurationListenerForPath(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error downloading remote configuration {0} : {1}")
    public void errorDownloadingRemoteConfiguration(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Prevented deletion of shared provider configuration because there are referencing descriptors: {0}")
    public void preventedDeletionOfSharedProviderConfiguration(String var1);

    @Message(level=MessageLevel.INFO, text="Generated topology {0} because the associated descriptor {1} changed.")
    public void generatedTopologyForDescriptorChange(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="An error occurred while attempting to initialize the remote configuration monitor: {0}")
    public void remoteConfigurationMonitorInitFailure(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.WARN, text="An error occurred while attempting to start the remote configuration monitor {0} : {1}")
    public void remoteConfigurationMonitorStartFailure(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Starting remote configuration monitor for source {0} ...")
    public void startingRemoteConfigurationMonitor(String var1);

    @Message(level=MessageLevel.INFO, text="Monitoring remote configuration source {0}")
    public void monitoringRemoteConfigurationSource(String var1);

    @Message(level=MessageLevel.INFO, text="Remote configuration monitor downloaded {0} configuration file {1}")
    public void downloadedRemoteConfigFile(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Remote configuration monitor deleted {0} configuration file {1} based on remote change.")
    public void deletedRemoteConfigFile(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to delete remote {0} file {1}.")
    public void failedToDeletedRemoteConfigFile(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="An error occurred while processing {0} : {1}")
    public void simpleDescriptorHandlingError(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Successfully wrote configuration: {0}")
    public void wroteConfigurationFile(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to write configuration: {0}")
    public void failedToWriteConfigurationFile(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Deleting topology {0} because the associated descriptor {1} was deleted.")
    public void deletingTopologyForDescriptorDeletion(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Deleting descriptor {0} because the associated topology {1} was deleted.")
    public void deletingDescriptorForTopologyDeletion(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Added descriptor {0} reference to provider configuration {1}.")
    public void addedProviderConfigurationReference(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Removed descriptor {0} reference to provider configuration {1}.")
    public void removedProviderConfigurationReference(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="The permissions for the remote configuration registry entry \"{0}\" are such that its content may not be trustworthy.")
    public void suspectWritableRemoteConfigurationEntry(String var1);

    @Message(level=MessageLevel.DEBUG, text="Correcting the suspect permissions for the remote configuration registry entry \"{0}\".")
    public void correctingSuspectWritableRemoteConfigurationEntry(String var1);

    @Message(level=MessageLevel.INFO, text="A cluster configuration change was noticed for {1} @ {0}")
    public void noticedClusterConfigurationChange(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Triggering topology regeneration for descriptor {2} because of change to the {1} @ {0} configuration.")
    public void triggeringTopologyRegeneration(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="Encountered an error processing {2} in response to a {1} @ {0} configuration change: {3}")
    public void errorRespondingToConfigChange(String var1, String var2, String var3, @StackTrace(level=MessageLevel.DEBUG) Exception var4);

    @Message(level=MessageLevel.INFO, text="Adding alias {1} for cluster {0} locally (local keystore) ")
    public void addAliasLocally(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Error adding alias {1} for cluster {0} locally (local keystore), cause: {2} ")
    public void errorAddingAliasLocally(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Remove alias {1} for cluster {0} locally (local keystore) ")
    public void removeAliasLocally(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Error removing alias {1} for cluster {0} locally (local keystore), cause: {2} ")
    public void errorRemovingAliasLocally(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Adding remote listener for path {0} ")
    public void addRemoteListener(String var1);

    @Message(level=MessageLevel.ERROR, text="Error adding remote listener for path {0}, cause: {1} ")
    public void errorAddingRemoteListener(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Error removing remote listener for path {0}, cause: {1} ")
    public void errorRemovingRemoteListener(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Remote Alias Service disabled")
    public void remoteAliasServiceDisabled();

    @Message(level=MessageLevel.INFO, text="Remote Alias Service enabled")
    public void remoteAliasServiceEnabled();

    @Message(level=MessageLevel.ERROR, text="The path to the keystore file does not exist: {0}")
    public void keystoreFileDoesNotExist(String var1);

    @Message(level=MessageLevel.ERROR, text="The path to the keystore file is not a file: {0}")
    public void keystoreFileIsNotAFile(String var1);

    @Message(level=MessageLevel.ERROR, text="The path to the keystore is not accessible: {0}")
    public void keystoreFileIsNotAccessible(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to add credential: {1}")
    public void failedToAddCredential(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to remove credential: {1}")
    public void failedToRemoveCredential(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Starting service: {0}")
    public void startingService(String var1);

    @Message(level=MessageLevel.INFO, text="Stopping service: {0}")
    public void stoppingService(String var1);

    @Message(level=MessageLevel.INFO, text="Redeploying topology {0} due to service definition change {1} / {2} / {3}")
    public void redeployingTopologyOnServiceDefinitionChange(String var1, String var2, String var3, String var4);

    @Message(level=MessageLevel.INFO, text="Saved service definition {0} / {1} / {2}")
    public void savedServiceDefinitionChange(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Updated service definition {0} / {1} / {2}")
    public void updatedServiceDefinitionChange(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Deleted service definition {0} / {1} / {2}")
    public void deletedServiceDefinitionChange(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="Failed to save gateway status")
    public void failedToSaveGatewayStatus();

    @Message(level=MessageLevel.ERROR, text="Error validating topology {0}")
    public void errorValidatingTopology(String var1);

    @Message(level=MessageLevel.ERROR, text="Error parsing topology {0}")
    public void errorParsingTopology(String var1);

    @Message(level=MessageLevel.ERROR, text="Error creating provider configuration {0} from topology {1}, cause: {2}")
    public void errorSavingProviderConfiguration(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="Error creating provider descriptor {0} from topology {1}, cause: {2}")
    public void errorSavingDescriptorConfiguration(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="No service found by type {0}")
    public void noServiceFound(String var1);

    @Message(level=MessageLevel.INFO, text="Using {0} implementation for {1}")
    public void usingServiceImplementation(String var1, String var2);
}

