/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.util.Collection;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.SortKey;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.SearchEntry;
import org.ldaptive.SortBehavior;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SecurityStrength;

public class JndiUtils {
    public static final boolean DEFAULT_IGNORE_CASE = true;
    private final SortBehavior sortBehavior;

    public JndiUtils() {
        this.sortBehavior = SortBehavior.getDefaultSortBehavior();
    }

    public JndiUtils(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public Attribute fromLdapAttribute(LdapAttribute attr) {
        BasicAttribute attribute = new BasicAttribute(attr.getName());
        if (attr.isBinary()) {
            for (byte[] value : attr.getBinaryValues()) {
                attribute.add(value);
            }
        } else {
            for (String value : attr.getStringValues()) {
                attribute.add(value);
            }
        }
        return attribute;
    }

    public LdapAttribute toLdapAttribute(Attribute attr) throws NamingException {
        HashSet<Object> values = new HashSet<Object>();
        NamingEnumeration<?> ne = attr.getAll();
        while (ne.hasMore()) {
            values.add(ne.next());
        }
        return LdapAttribute.createLdapAttribute(this.sortBehavior, attr.getID(), values);
    }

    public Attributes fromLdapAttributes(Collection<LdapAttribute> attrs) {
        BasicAttributes attributes = new BasicAttributes(true);
        for (LdapAttribute a : attrs) {
            attributes.put(this.fromLdapAttribute(a));
        }
        return attributes;
    }

    public SearchResult fromSearchEntry(SearchEntry entry) {
        return new SearchResult(entry.getDn(), (Object)null, this.fromLdapAttributes(entry.getAttributes()));
    }

    public SearchEntry toSearchEntry(SearchResult result) throws NamingException {
        SearchEntry se = new SearchEntry(-1, null, this.sortBehavior);
        se.setDn(result.getName());
        Attributes a = result.getAttributes();
        NamingEnumeration<? extends Attribute> ne = a.getAll();
        while (ne.hasMore()) {
            se.addAttribute(this.toLdapAttribute(ne.next()));
        }
        return se;
    }

    public ModificationItem[] fromAttributeModification(AttributeModification[] mods) {
        ModificationItem[] mi = new ModificationItem[mods.length];
        for (int i = 0; i < mods.length; ++i) {
            mi[i] = new ModificationItem(JndiUtils.getAttributeModification(mods[i].getAttributeModificationType()), this.fromLdapAttribute(mods[i].getAttribute()));
        }
        return mi;
    }

    public static SortKey[] fromSortKey(org.ldaptive.control.SortKey[] keys) {
        SortKey[] sk = null;
        if (keys != null) {
            sk = new SortKey[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                sk[i] = new SortKey(keys[i].getAttributeDescription(), !keys[i].getReverseOrder(), keys[i].getMatchingRuleId());
            }
        }
        return sk;
    }

    protected static int getAttributeModification(AttributeModificationType type) {
        int op = -1;
        if (type == AttributeModificationType.ADD) {
            op = 1;
        } else if (type == AttributeModificationType.REMOVE) {
            op = 3;
        } else if (type == AttributeModificationType.REPLACE) {
            op = 2;
        }
        return op;
    }

    public static String getQualityOfProtection(QualityOfProtection qop) {
        String s;
        switch (qop) {
            case AUTH: {
                s = "auth";
                break;
            }
            case AUTH_INT: {
                s = "auth-int";
                break;
            }
            case AUTH_CONF: {
                s = "auth-conf";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL quality of protection: " + (Object)((Object)qop));
            }
        }
        return s;
    }

    public static String getSecurityStrength(SecurityStrength ss) {
        String s;
        switch (ss) {
            case HIGH: {
                s = "high";
                break;
            }
            case MEDIUM: {
                s = "medium";
                break;
            }
            case LOW: {
                s = "low";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL security strength: " + (Object)((Object)ss));
            }
        }
        return s;
    }

    public static String getAuthenticationType(Mechanism m) {
        String s;
        switch (m) {
            case EXTERNAL: {
                s = "EXTERNAL";
                break;
            }
            case DIGEST_MD5: {
                s = "DIGEST-MD5";
                break;
            }
            case CRAM_MD5: {
                s = "CRAM-MD5";
                break;
            }
            case GSSAPI: {
                s = "GSSAPI";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL authentication mechanism: " + (Object)((Object)m));
            }
        }
        return s;
    }
}

